/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval.util;

import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.NoEvalException;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.Symbol;
import org.matheclipse.core.generic.Predicates;
import org.matheclipse.core.generic.interfaces.IIterator;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISignedNumber;

public class Iterator
implements IIterator<IExpr> {
    IExpr count;
    final boolean fNumericMode;
    EvalEngine evalEngine;
    IExpr start;
    IExpr maxCounterOrList;
    int maxCounterOrListIndex;
    IExpr step;
    final IExpr originalStart;
    final IExpr originalMaxCount;
    final IExpr originalStep;
    final Symbol variable;

    public Iterator(IAST lst, EvalEngine sess) {
        this.evalEngine = sess;
        this.fNumericMode = this.evalEngine.isNumericMode() || lst.isMember(Predicates.isNumeric(), false);
        switch (lst.size()) {
            case 2: {
                this.start = F.C1;
                this.maxCounterOrList = this.evalEngine.evalWithoutNumericReset(lst.arg1());
                this.step = F.C1;
                this.variable = null;
                break;
            }
            case 3: {
                this.start = F.C1;
                this.maxCounterOrList = this.evalEngine.evalWithoutNumericReset(lst.arg2());
                this.step = F.C1;
                if (lst.arg1() instanceof Symbol) {
                    this.variable = (Symbol)lst.arg1();
                    break;
                }
                this.variable = null;
                break;
            }
            case 4: {
                this.start = this.evalEngine.evalWithoutNumericReset(lst.arg2());
                this.maxCounterOrList = this.evalEngine.evalWithoutNumericReset(lst.arg3());
                this.step = F.C1;
                if (lst.arg1().isSymbol()) {
                    this.variable = (Symbol)lst.arg1();
                    break;
                }
                this.variable = null;
                break;
            }
            case 5: {
                this.start = this.evalEngine.evalWithoutNumericReset(lst.arg2());
                this.maxCounterOrList = this.evalEngine.evalWithoutNumericReset(lst.arg3());
                this.step = this.evalEngine.evalWithoutNumericReset(lst.arg4());
                if (lst.arg1() instanceof Symbol) {
                    this.variable = (Symbol)lst.arg1();
                    break;
                }
                this.variable = null;
                break;
            }
            default: {
                this.start = null;
                this.maxCounterOrList = null;
                this.step = null;
                this.variable = null;
            }
        }
        this.originalStart = this.start;
        this.originalMaxCount = this.maxCounterOrList;
        this.originalStep = this.step;
    }

    public Iterator(IAST lst, Symbol symbol, EvalEngine sess) {
        this.evalEngine = sess;
        this.fNumericMode = this.evalEngine.isNumericMode();
        switch (lst.size()) {
            case 2: {
                this.start = F.C1;
                this.maxCounterOrList = this.evalEngine.evalWithoutNumericReset(lst.arg1());
                this.step = F.C1;
                this.variable = symbol;
                break;
            }
            case 3: {
                this.start = this.evalEngine.evalWithoutNumericReset(lst.arg1());
                this.maxCounterOrList = this.evalEngine.evalWithoutNumericReset(lst.arg2());
                this.step = F.C1;
                this.variable = symbol;
                break;
            }
            case 4: {
                this.start = this.evalEngine.evalWithoutNumericReset(lst.arg1());
                this.maxCounterOrList = this.evalEngine.evalWithoutNumericReset(lst.arg2());
                this.step = this.evalEngine.evalWithoutNumericReset(lst.arg3());
                this.variable = symbol;
                break;
            }
            default: {
                this.start = null;
                this.maxCounterOrList = null;
                this.step = null;
                this.variable = null;
            }
        }
        this.originalStart = this.start;
        this.originalMaxCount = this.maxCounterOrList;
        this.originalStep = this.step;
    }

    @Override
    public boolean hasNext() {
        if (this.maxCounterOrList == null) {
            throw new NoEvalException();
        }
        if (this.maxCounterOrList.isList()) {
            return this.maxCounterOrListIndex <= ((IAST)this.maxCounterOrList).size();
        }
        if (this.step.isZero()) {
            throw new NoEvalException();
        }
        if (this.step.isSignedNumber()) {
            return ((ISignedNumber)this.step).isNegative() ? this.evalEngine.evalTrue(F.LessEqual(this.maxCounterOrList, this.count)) : this.evalEngine.evalTrue(F.LessEqual(this.count, this.maxCounterOrList));
        }
        IExpr sub = this.evalEngine.evaluate(F.Divide(F.Subtract(this.maxCounterOrList, this.count), this.step));
        if (sub.isSignedNumber()) {
            return !((ISignedNumber)sub).isNegative();
        }
        return false;
    }

    @Override
    public IExpr next() {
        if (this.variable != null) {
            this.variable.set(this.count);
        }
        IExpr temp = this.count;
        if (this.maxCounterOrList.isList()) {
            if (this.maxCounterOrListIndex == ((IAST)this.maxCounterOrList).size()) {
                ++this.maxCounterOrListIndex;
                return temp;
            }
            this.count = (IExpr)((IAST)this.maxCounterOrList).get(this.maxCounterOrListIndex++);
        } else {
            this.count = this.evalEngine.evaluate(F.Plus(this.count, this.step));
        }
        return temp;
    }

    @Override
    public boolean setUp() {
        this.start = this.originalStart;
        if (!this.originalStart.isSignedNumber()) {
            this.start = this.evalEngine.evalWithoutNumericReset(this.originalStart);
        }
        this.maxCounterOrList = this.originalMaxCount;
        if (!this.originalMaxCount.isSignedNumber()) {
            this.maxCounterOrList = this.evalEngine.evalWithoutNumericReset(this.originalMaxCount);
        }
        this.maxCounterOrListIndex = 1;
        this.step = this.originalStep;
        if (!this.originalStep.isSignedNumber()) {
            this.step = this.evalEngine.evalWithoutNumericReset(this.originalStep);
        }
        if (this.step.isSignedNumber() && (this.step.isNegative() ? this.evalEngine.evaluate(F.Less(this.start, this.maxCounterOrList)) == F.True : this.evalEngine.evaluate(F.Less(this.maxCounterOrList, this.start)) == F.True)) {
            return false;
        }
        this.count = this.maxCounterOrList.isList() ? this.maxCounterOrList.getAt(this.maxCounterOrListIndex++) : this.start;
        if (this.variable != null) {
            this.variable.pushLocalVariable(this.count);
        }
        return true;
    }

    @Override
    public void tearDown() {
        if (this.variable != null) {
            this.variable.popLocalVariable();
        }
        EvalEngine.get().setNumericMode(this.fNumericMode);
    }

    @Override
    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }
}

