/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval.interfaces;

import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IComplex;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.INumber;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.patternmatching.PatternMatcherAndInvoker;
import org.matheclipse.parser.client.SyntaxError;

public abstract class AbstractFunctionEvaluator
implements IFunctionEvaluator {
    @Override
    public IExpr numericEval(IAST ast) {
        return this.evaluate(ast);
    }

    public IAST getRuleAST() {
        return null;
    }

    @Override
    public void setUp(ISymbol symbol) throws SyntaxError {
        IAST ruleList = this.getRuleAST();
        if (ruleList != null) {
            EvalEngine.get().addRules(ruleList);
        }
        F.SYMBOL_OBSERVER.createPredefinedSymbol(symbol.toString());
    }

    @Override
    public abstract IExpr evaluate(IAST var1);

    public void createRuleFromMethod(ISymbol symbol, String patternString, String methodName) {
        PatternMatcherAndInvoker pm = new PatternMatcherAndInvoker(patternString, (IFunctionEvaluator)this, methodName);
        symbol.putDownRule(pm);
    }

    public static boolean isNegativeExpression(IExpr expr) {
        IExpr arg1;
        return expr.isNumber() ? ((INumber)expr).complexSign() < 0 : (expr.isTimes() ? ((arg1 = ((IAST)expr).arg1()).isNumber() ? ((INumber)arg1).complexSign() < 0 : arg1.isNegativeInfinity()) : (expr.isPlus() ? ((arg1 = ((IAST)expr).arg1()).isNumber() ? ((INumber)arg1).complexSign() < 0 : arg1.isNegativeInfinity()) : expr.isNegativeInfinity()));
    }

    public static IExpr getNormalizedNegativeExpression(IExpr expr) {
        if (expr.isNumber() && ((INumber)expr).complexSign() < 0) {
            return (IExpr)((INumber)expr).negate();
        }
        if (expr.isAST()) {
            if (expr.isTimes()) {
                IAST timesAST = (IAST)expr;
                IExpr arg1 = timesAST.arg1();
                if (arg1.isNumber()) {
                    if (((INumber)arg1).complexSign() < 0) {
                        return timesAST.setAtClone(1, (IExpr)((INumber)arg1).negate());
                    }
                } else if (arg1.isNegativeInfinity()) {
                    return timesAST.setAtClone(1, F.CInfinity);
                }
            } else if (expr.isPlus()) {
                IAST plusAST = (IAST)expr;
                IExpr arg1 = plusAST.arg1();
                if (arg1.isNumber()) {
                    if (((INumber)arg1).complexSign() < 0) {
                        IAST result = plusAST.clone();
                        result.set(1, arg1.negate());
                        for (int i = 2; i < plusAST.size(); ++i) {
                            result.set(i, ((IExpr)plusAST.get(i)).negate());
                        }
                        return result;
                    }
                } else {
                    IExpr arg1Negated;
                    if (arg1.isNegativeInfinity()) {
                        IAST result = plusAST.clone();
                        result.set(1, F.CInfinity);
                        for (int i = 2; i < plusAST.size(); ++i) {
                            result.set(i, ((IExpr)plusAST.get(i)).negate());
                        }
                        return result;
                    }
                    if (arg1.isTimes() && (arg1Negated = AbstractFunctionEvaluator.getNormalizedNegativeExpression(arg1)) != null) {
                        int positiveElementsCounter = 0;
                        IAST result = plusAST.clone();
                        result.set(1, arg1Negated);
                        for (int i = 2; i < plusAST.size(); ++i) {
                            IExpr temp = (IExpr)plusAST.get(i);
                            if (!temp.isTimes() && !temp.isPower()) {
                                return null;
                            }
                            arg1Negated = AbstractFunctionEvaluator.getNormalizedNegativeExpression(temp);
                            if (arg1Negated != null) {
                                result.set(i, arg1Negated);
                                continue;
                            }
                            if (++positiveElementsCounter * 2 >= plusAST.size() - 1) {
                                return null;
                            }
                            result.set(i, temp.negate());
                        }
                        return result;
                    }
                }
            } else if (expr.isNegativeInfinity()) {
                return F.CInfinity;
            }
        }
        return null;
    }

    public static IExpr[] getPeriodicParts(IExpr expr, IExpr period) {
        IExpr[] result = new IExpr[]{F.C0, F.C1};
        if (expr.equals(period)) {
            return result;
        }
        if (expr.isAST()) {
            IAST ast = (IAST)expr;
            if (ast.isTimes()) {
                for (int i = 1; i < ast.size(); ++i) {
                    if (!((IExpr)ast.get(i)).equals(period)) continue;
                    result[1] = ast.removeAtClone(i).getOneIdentity(F.C1);
                    if (!result[1].isNumber()) continue;
                    return result;
                }
                return null;
            }
            if (ast.isPlus()) {
                for (int i = 1; i < ast.size(); ++i) {
                    IExpr[] temp = AbstractFunctionEvaluator.getPeriodicParts((IExpr)ast.get(i), period);
                    if (temp == null || !temp[0].isZero()) continue;
                    result[0] = ast.removeAtClone(i).getOneIdentity(F.C0);
                    result[1] = temp[1];
                    return result;
                }
                return null;
            }
        }
        return null;
    }

    public static IExpr getPureImaginaryPart(IExpr expr) {
        IAST times;
        IExpr arg1;
        if (expr.isComplex() && ((IComplex)expr).getRe().isZero()) {
            IComplex compl = (IComplex)expr;
            return compl.getIm();
        }
        if (expr.isTimes() && (arg1 = (times = (IAST)expr).arg1()).isComplex() && ((IComplex)arg1).getRe().isZero()) {
            return times.setAtClone(1, ((IComplex)arg1).getIm());
        }
        return null;
    }
}

