/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval;

import java.io.Writer;
import org.matheclipse.core.convert.AST2Expr;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.form.tex.TeXFormFactory;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.parser.client.Parser;
import org.matheclipse.parser.client.ast.ASTNode;

public class TeXUtilities {
    protected EvalEngine fEvalEngine;
    protected TeXFormFactory fTeXFactory;
    Parser fParser;

    public TeXUtilities(EvalEngine evalEngine, boolean relaxedSyntax) {
        this.fEvalEngine = evalEngine;
        EvalEngine.set(evalEngine);
        this.fTeXFactory = new TeXFormFactory();
        this.fParser = new Parser(relaxedSyntax);
    }

    public synchronized void toTeX(String inputExpression, Writer out) {
        IExpr parsedExpression = null;
        if (inputExpression != null) {
            try {
                ASTNode node = this.fParser.parse(inputExpression);
                parsedExpression = AST2Expr.CONST.convert(node);
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        this.toTeX(parsedExpression, out);
    }

    public synchronized void toTeX(IExpr objectExpression, Writer out) {
        StringBuffer buf = new StringBuffer();
        if (objectExpression != null) {
            IExpr result = objectExpression;
            if (objectExpression.isAST()) {
                result = this.fEvalEngine.evalSetAttributes((IAST)objectExpression);
            }
            this.fTeXFactory.convert(buf, result, 0);
            try {
                out.write(buf.toString());
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
    }

    public void stopRequest() {
        this.fEvalEngine.stopRequest();
    }
}

