/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval;

import java.io.Writer;
import org.matheclipse.core.builtin.function.JavaForm;
import org.matheclipse.core.convert.AST2Expr;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.form.mathml.MathMLContentFormFactory;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.parser.client.Parser;
import org.matheclipse.parser.client.ast.ASTNode;

public class MathMLContentUtilities {
    protected EvalEngine fEvalEngine;
    protected MathMLContentFormFactory fMathMLFactory;
    Parser fParser;

    public MathMLContentUtilities(EvalEngine evalEngine, boolean relaxedSyntax) {
        this.fEvalEngine = evalEngine;
        this.startRequest();
        this.fMathMLFactory = new MathMLContentFormFactory();
        this.fParser = new Parser(relaxedSyntax);
    }

    public synchronized void toMathML(String inputExpression, Writer out) {
        IExpr parsedExpression = null;
        if (inputExpression != null) {
            try {
                ASTNode node = this.fParser.parse(inputExpression);
                parsedExpression = AST2Expr.CONST.convert(node, this.fEvalEngine);
            }
            catch (Throwable e) {
                return;
            }
        }
        this.toMathML(parsedExpression, out);
    }

    public synchronized void toMathML(IExpr objectExpression, Writer out) {
        StringBuffer buf = new StringBuffer();
        if (objectExpression != null) {
            this.fMathMLFactory.convert(buf, objectExpression, 0);
            try {
                out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                out.write("<math:math xmlns=\"http://www.w3.org/1998/Math/MathML\">\n");
                out.write(buf.toString());
                out.write("\n</math:math>");
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
    }

    public synchronized void toJava(String inputExpression, Writer out, boolean strictJava) {
        IExpr parsedExpression = null;
        if (inputExpression != null) {
            try {
                ASTNode node = this.fParser.parse(inputExpression);
                parsedExpression = AST2Expr.CONST.convert(node, this.fEvalEngine);
                out.write(JavaForm.javaForm(parsedExpression, strictJava));
            }
            finally {
                return;
            }
        }
    }

    public void startRequest() {
        EvalEngine.set(this.fEvalEngine);
    }

    public void stopRequest() {
        this.fEvalEngine.stopRequest();
    }
}

