/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval;

import java.io.Serializable;
import org.matheclipse.core.interfaces.IExpr;

public class LastCalculationsHistory
implements Serializable {
    private static final long serialVersionUID = 5003679826481359674L;
    private final IExpr[] fOutHistory;
    private final int fMaximumCapacity;
    private int fIndex;
    private int fAllEntriesCounter;

    public LastCalculationsHistory(int n) {
        this.fMaximumCapacity = n;
        this.fOutHistory = new IExpr[this.fMaximumCapacity];
        this.fIndex = 0;
        this.fAllEntriesCounter = 0;
    }

    public void add(IExpr entry) {
        this.fOutHistory[this.fIndex++] = entry;
        ++this.fAllEntriesCounter;
        if (this.fIndex == this.fMaximumCapacity) {
            this.fIndex = 0;
        }
    }

    public IExpr get(int index) {
        if (index > this.fAllEntriesCounter || index == 0) {
            return null;
        }
        if (index > 0) {
            index -= this.fAllEntriesCounter + 1;
        }
        if (index <= 0) {
            if (this.fMaximumCapacity < (index *= -1)) {
                return null;
            }
            if (index > this.fIndex) {
                return this.fOutHistory[this.fMaximumCapacity + this.fIndex - index];
            }
            return this.fOutHistory[this.fIndex - index];
        }
        return null;
    }

    public int size() {
        return this.fOutHistory.length;
    }
}

