/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval;

import com.google.common.base.Predicate;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.matheclipse.core.convert.AST2Expr;
import org.matheclipse.core.eval.LastCalculationsHistory;
import org.matheclipse.core.eval.SystemNamespace;
import org.matheclipse.core.eval.TraceStack;
import org.matheclipse.core.eval.exception.IterationLimitExceeded;
import org.matheclipse.core.eval.exception.RecursionLimitExceeded;
import org.matheclipse.core.eval.interfaces.ICoreFunctionEvaluator;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.MethodSymbol;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IEvaluationEngine;
import org.matheclipse.core.interfaces.IEvaluator;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IPatternObject;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.list.algorithms.EvaluationSupport;
import org.matheclipse.parser.client.Parser;
import org.matheclipse.parser.client.ast.ASTNode;
import org.matheclipse.parser.client.math.MathException;

public class EvalEngine
implements Serializable,
IEvaluationEngine {
    private static final long serialVersionUID = 407328682800652434L;
    private Map<String, ISymbol> fUserVariableMap;
    private transient IdentityHashMap<ISymbol, Stack<IExpr>> fLocalVariableStackMap = null;
    volatile transient boolean fStopRequested;
    transient int fRecursionCounter;
    transient boolean fNumericMode;
    transient int fNumericPrecision = 15;
    transient boolean fEvalLHSMode;
    transient String fSessionID;
    transient boolean fTraceMode;
    transient TraceStack fTraceStack = null;
    transient PrintStream fOutPrintStream = null;
    protected int fRecursionLimit;
    protected int fIterationLimit;
    static int fAnonymousCounter = 0;
    protected boolean fPackageMode = false;
    transient int fModuleCounter = 0;
    private boolean fRelaxedSyntax;
    transient IAST reapList = null;
    protected Set<ISymbol> fModifiedVariablesList;
    protected transient LastCalculationsHistory fOutList = null;
    protected transient IExpr fAnswer = null;
    private transient boolean fOutListDisabled = true;
    transient boolean fQuietMode = false;
    public static final int DOUBLE_PRECISION = 15;
    public static final boolean DEBUG = false;
    private static final transient ThreadLocal<EvalEngine> instance = new ThreadLocal<EvalEngine>(){
        private int fID = 1;

        @Override
        public EvalEngine initialValue() {
            return new EvalEngine("ThreadLocal" + this.fID++, 0, System.out, false, true);
        }
    };

    public static final IExpr eval(IExpr expr) {
        return instance.get().evaluate(expr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final IExpr evalQuiet(IExpr expr) {
        EvalEngine engine = instance.get();
        boolean quiet = engine.isQuietMode();
        try {
            engine.setQuietMode(true);
            IExpr iExpr = engine.evaluate(expr);
            return iExpr;
        }
        finally {
            engine.setQuietMode(quiet);
        }
    }

    public static final IExpr evalNull(IExpr expr) {
        return instance.get().evaluateNull(expr);
    }

    public static synchronized int getNextAnonymousCounter() {
        return ++fAnonymousCounter;
    }

    public static synchronized String getNextCounter() {
        return Integer.toString(++fAnonymousCounter);
    }

    public static final Stack<IExpr> localStack(ISymbol symbol) {
        return EvalEngine.get().getLocalVariableStackMap().get(symbol);
    }

    public static Stack<IExpr> localStackCreate(ISymbol symbol) {
        Map<ISymbol, Stack<IExpr>> localVariableStackMap = EvalEngine.get().getLocalVariableStackMap();
        Stack<IExpr> temp = localVariableStackMap.get(symbol);
        if (temp != null) {
            return temp;
        }
        temp = new Stack();
        localVariableStackMap.put(symbol, temp);
        return temp;
    }

    public static void set(EvalEngine engine) {
        instance.set(engine);
    }

    public static IAST threadASTListArgs(IAST ast) {
        IAST result;
        int listLength = 0;
        int astSize = ast.size();
        for (int i = 1; i < astSize; ++i) {
            if (!((IExpr)ast.get(i)).isList()) continue;
            if (listLength == 0) {
                listLength = ((IAST)ast.get(i)).size() - 1;
                continue;
            }
            if (listLength == ((IAST)ast.get(i)).size() - 1) continue;
            ast.setEvalFlags(1024);
            return null;
        }
        if (listLength != 0 && (result = EvaluationSupport.threadList(ast, listLength, 1)) != null) {
            result.setEvalFlags(1024);
            return result;
        }
        ast.setEvalFlags(1024);
        return null;
    }

    public static EvalEngine get() {
        return instance.get();
    }

    public static void remove() {
        instance.remove();
    }

    public EvalEngine() {
        this("", 0, System.out, false, true);
    }

    public EvalEngine(boolean relaxedSyntax) {
        this("", 0, System.out, relaxedSyntax, true);
    }

    public EvalEngine(boolean relaxedSyntax, boolean outListDisabled) {
        this("", 0, System.out, relaxedSyntax, outListDisabled);
    }

    public EvalEngine(String sessionID, int recursionLimit, int iterationLimit, PrintStream out, boolean relaxedSyntax, boolean outListDisabled) {
        this.fSessionID = sessionID;
        this.fRecursionLimit = recursionLimit;
        this.fIterationLimit = iterationLimit;
        this.fOutPrintStream = out;
        this.fRelaxedSyntax = relaxedSyntax;
        this.fOutListDisabled = outListDisabled;
        this.init();
        EvalEngine.set(this);
    }

    public EvalEngine(String sessionID, int recursionLimit, PrintStream out, boolean relaxedSyntax, boolean outListDisabled) {
        this(sessionID, recursionLimit, -1, out, relaxedSyntax, outListDisabled);
    }

    public EvalEngine(String sessionID, PrintStream out) {
        this(sessionID, -1, -1, out, false, true);
    }

    public boolean addModifiedVariable(ISymbol arg0) {
        return this.fModifiedVariablesList.add(arg0);
    }

    public void addOut(IExpr arg0) {
        this.fAnswer = arg0 == null ? F.Null : arg0;
        ISymbol ans = F.$s("$ans");
        ans.putDownRule(F.Set, true, ans, this.fAnswer, false);
        if (this.fOutListDisabled) {
            return;
        }
        this.fOutList.add(this.fAnswer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRules(IAST ruleList) {
        boolean oldPackageMode = this.isPackageMode();
        boolean oldTraceMode = this.isTraceMode();
        try {
            this.setPackageMode(true);
            this.setTraceMode(false);
            int ruleSize = ruleList.size();
            for (int i = 1; i < ruleSize; ++i) {
                if (ruleList.get(i) == null) continue;
                this.evaluate((IExpr)ruleList.get(i));
            }
        }
        finally {
            this.setPackageMode(oldPackageMode);
            this.setTraceMode(oldTraceMode);
        }
    }

    public void beginTrace(Predicate<IExpr> matcher, IAST list) {
        this.setTraceMode(true);
        this.fTraceStack = new TraceStack(matcher, list);
    }

    public IAST endTrace() {
        this.setTraceMode(false);
        IAST ast = this.fTraceStack.getList();
        this.fTraceStack = null;
        if (ast.size() > 1) {
            return ast.getAST(1);
        }
        return ast;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IAST evalArgs(IAST ast, int attr) {
        int astSize = ast.size();
        if (astSize > 1) {
            IExpr evaledExpr;
            boolean numericMode = this.fNumericMode;
            boolean localNumericMode = this.fNumericMode;
            if (!this.fNumericMode) {
                for (int i = 1; i < astSize; ++i) {
                    if (!((IExpr)ast.get(i)).isNumeric()) continue;
                    localNumericMode = true;
                    break;
                }
            }
            IAST resultList = null;
            if ((0x20 & attr) == 0) {
                try {
                    this.fNumericMode = (0x2000 & attr) == 8192 ? false : localNumericMode;
                    evaledExpr = this.evalLoop(ast.arg1());
                    if (evaledExpr != null) {
                        resultList = ast.setAtClone(1, evaledExpr);
                        resultList.setEvalFlags(ast.getEvalFlags() & 0x60);
                        if (astSize == 2) {
                            IAST iAST = resultList;
                            return iAST;
                        }
                    }
                }
                finally {
                    if ((0x2000 & attr) == 8192) {
                        this.fNumericMode = numericMode;
                    }
                }
            }
            if ((0x40 & attr) == 0) {
                numericMode = this.fNumericMode;
                try {
                    this.fNumericMode = (0x4000 & attr) == 16384 ? false : localNumericMode;
                    for (int i = 2; i < astSize; ++i) {
                        evaledExpr = this.evalLoop((IExpr)ast.get(i));
                        if (evaledExpr == null) continue;
                        if (resultList == null) {
                            resultList = ast.clone();
                            resultList.setEvalFlags(ast.getEvalFlags() & 0x60);
                        }
                        resultList.set(i, evaledExpr);
                    }
                }
                finally {
                    if ((0x4000 & attr) == 16384) {
                        this.fNumericMode = numericMode;
                    }
                }
            }
            if (resultList != null) {
                return resultList;
            }
        }
        return null;
    }

    public IExpr evalAST(IAST ast) {
        IExpr result;
        IExpr head = ast.head();
        ISymbol symbol = null;
        if (head instanceof ISymbol) {
            symbol = (ISymbol)head;
            IEvaluator module = symbol.getEvaluator();
            if (module instanceof ICoreFunctionEvaluator) {
                if (this.fNumericMode) {
                    return ((ICoreFunctionEvaluator)module).numericEval(ast);
                }
                return ((ICoreFunctionEvaluator)module).evaluate(ast);
            }
        } else {
            symbol = ast.topHead();
        }
        if ((result = this.evalAttributes(symbol, ast)) != null) {
            return result;
        }
        return this.evalRules(symbol, ast);
    }

    public IExpr evalRules(ISymbol symbol, IAST ast) {
        for (int i = 1; i < ast.size(); ++i) {
            if (ast.get(i) instanceof IPatternObject) continue;
            IExpr arg = (IExpr)ast.get(i);
            ISymbol lhsSymbol = null;
            lhsSymbol = arg.isSymbol() ? (ISymbol)arg : arg.topHead();
            IExpr result = lhsSymbol.evalUpRule(this, ast);
            if (result == null) continue;
            return result;
        }
        return this.evalASTBuiltinFunction(symbol, ast);
    }

    public IExpr evalASTAttributes(IAST ast) {
        IExpr head = ast.head();
        ISymbol symbol = null;
        if (head instanceof ISymbol) {
            symbol = (ISymbol)head;
            IEvaluator module = symbol.getEvaluator();
            if (module instanceof ICoreFunctionEvaluator) {
                if (this.fNumericMode) {
                    return ((ICoreFunctionEvaluator)module).numericEval(ast);
                }
                return ((ICoreFunctionEvaluator)module).evaluate(ast);
            }
        } else {
            symbol = ast.topHead();
        }
        return this.evalAttributes(symbol, ast);
    }

    public IExpr evalAttributes(ISymbol symbol, IAST ast) {
        IExpr head = ast.head();
        int astSize = ast.size();
        if (astSize == 2) {
            return this.evalASTArg1(ast);
        }
        IExpr result = this.evalLoop(head);
        if (result != null) {
            return ast.apply(result);
        }
        if (astSize != 1) {
            int attr = symbol.getAttributes();
            result = this.flattenSequences(ast);
            if (result != null) {
                return result;
            }
            IAST flattened = null;
            if ((8 & attr) == 8 && (flattened = EvaluationSupport.flatten(ast)) != null) {
                IAST resultList = this.evalArgs(flattened, attr);
                if (resultList != null) {
                    return resultList;
                }
                return flattened;
            }
            IAST resultList = this.evalArgs(ast, attr);
            if (resultList != null) {
                return resultList;
            }
            if ((0x80 & attr) == 128 && (ast.getEvalFlags() & 0x400) != 1024 && (resultList = EvalEngine.threadASTListArgs(ast)) != null) {
                return resultList;
            }
            if (astSize > 2 && (4 & attr) == 4) {
                EvaluationSupport.sort(ast);
            }
        }
        return null;
    }

    private IExpr evalASTArg1(IAST ast) {
        IExpr arg1;
        IExpr result = this.evalLoop(ast.head());
        if (result != null) {
            return ast.apply(result);
        }
        ISymbol symbol = ast.topHead();
        int attr = symbol.getAttributes();
        result = this.flattenSequences(ast);
        if (result != null) {
            return result;
        }
        if ((1 & attr) == 1) {
            return ast.arg1();
        }
        if ((8 & attr) == 8 && (arg1 = ast.arg1()).topHead().equals(symbol)) {
            return arg1;
        }
        result = this.evalArgs(ast, attr);
        if (result != null) {
            return result;
        }
        if ((0x80 & attr) == 128 && (arg1 = ast.arg1()).isList() && (result = EvaluationSupport.threadList(ast, ((IAST)arg1).size() - 1, 1)) != null) {
            return result;
        }
        if (!(ast.arg1() instanceof IPatternObject)) {
            arg1 = ast.arg1();
            ISymbol lhsSymbol = null;
            lhsSymbol = arg1.isSymbol() ? (ISymbol)arg1 : arg1.topHead();
            result = lhsSymbol.evalUpRule(this, ast);
            if (result != null) {
                return result;
            }
        }
        return this.evalASTBuiltinFunction(symbol, ast);
    }

    private IExpr evalASTBuiltinFunction(ISymbol symbol, IAST ast) {
        IExpr result;
        int attr;
        if (this.fEvalLHSMode && ((0x60 & (attr = symbol.getAttributes())) == 96 ? !symbol.equals(F.Set) && !symbol.equals(F.SetDelayed) && !symbol.equals(F.UpSet) && !symbol.equals(F.UpSetDelayed) : (0x400 & attr) != 1024)) {
            return null;
        }
        if (!symbol.equals(F.Integrate) && (result = symbol.evalDownRule(this, ast)) != null) {
            return result;
        }
        if (symbol instanceof MethodSymbol) {
            return ((MethodSymbol)symbol).invoke(ast);
        }
        IEvaluator module = symbol.getEvaluator();
        if (module instanceof IFunctionEvaluator) {
            if (this.fNumericMode) {
                return ((IFunctionEvaluator)module).numericEval(ast);
            }
            return ((IFunctionEvaluator)module).evaluate(ast);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IExpr evalLoop(IExpr expr) {
        if (this.fRecursionLimit > 0 && this.fRecursionCounter > this.fRecursionLimit) {
            RecursionLimitExceeded.throwIt(this.fRecursionLimit, expr);
        }
        try {
            IExpr temp;
            ++this.fRecursionCounter;
            if (this.fTraceMode) {
                this.fTraceStack.pushList();
            }
            if ((temp = expr.evaluate(this)) != null) {
                if (this.fTraceMode) {
                    this.fTraceStack.addIfEmpty(expr);
                    this.fTraceStack.add(temp);
                }
                IExpr result = temp;
                int iterationCounter = 2;
                do {
                    if ((temp = result.evaluate(this)) == null) continue;
                    if (this.fTraceMode) {
                        this.fTraceStack.add(temp);
                    }
                    result = temp;
                    if (this.fIterationLimit < 0 || this.fIterationLimit > ++iterationCounter) continue;
                    IterationLimitExceeded.throwIt(iterationCounter, result);
                } while (temp != null);
                IExpr iExpr = result;
                return iExpr;
            }
            IExpr iExpr = null;
            return iExpr;
        }
        finally {
            --this.fRecursionCounter;
            if (this.fTraceMode) {
                this.fTraceStack.popList();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IAST evalSetAttributes(IAST ast) {
        boolean evalLHSMode = this.fEvalLHSMode;
        try {
            this.fEvalLHSMode = true;
            if ((ast.getEvalFlags() & 0x300) != 0) {
                IAST iAST = ast;
                return iAST;
            }
            IAST result = this.evalSetAttributesRecursive(ast);
            if (result != null) {
                IAST iAST = result;
                return iAST;
            }
            IAST iAST = ast;
            return iAST;
        }
        finally {
            this.fEvalLHSMode = evalLHSMode;
        }
    }

    private IAST evalSetAttributesRecursive(IAST ast) {
        IAST result;
        ISymbol symbol = ast.topHead();
        int attr = symbol.getAttributes();
        IAST resultList = null;
        if ((0x60 & attr) != 96) {
            IAST temp;
            int astSize = ast.size();
            if ((0x20 & attr) == 0 && astSize > 1 && ast.arg1().isAST() && (result = this.evalSetAttributesRecursive(temp = (IAST)ast.arg1())) != null) {
                resultList = ast.setAtClone(1, result);
            }
            if ((0x40 & attr) == 0) {
                for (int i = 2; i < astSize; ++i) {
                    IAST temp2;
                    if (!((IExpr)ast.get(i)).isAST() || (result = this.evalSetAttributesRecursive(temp2 = (IAST)ast.get(i))) == null) continue;
                    if (resultList == null) {
                        resultList = ast.clone();
                    }
                    resultList.set(i, result);
                }
            }
        }
        if (resultList != null) {
            if (ast.size() > 2) {
                if ((8 & attr) == 8 && (result = EvaluationSupport.flatten(resultList)) != null) {
                    resultList = result;
                }
                if ((4 & attr) == 4) {
                    EvaluationSupport.sort(resultList);
                }
            }
            return resultList;
        }
        if ((8 & attr) == 8 && (result = EvaluationSupport.flatten(ast)) != null) {
            resultList = result;
            if ((4 & attr) == 4) {
                EvaluationSupport.sort(resultList);
            }
            return resultList;
        }
        if ((4 & attr) == 4) {
            EvaluationSupport.sort(ast);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IAST evalTrace(IExpr expr, Predicate<IExpr> matcher, IAST list) {
        IAST traceList = F.List();
        try {
            this.beginTrace(matcher, list);
            this.evaluate(expr);
        }
        finally {
            traceList = this.endTrace();
        }
        return traceList;
    }

    public final boolean evalTrue(IExpr expr) {
        try {
            if (expr.isTrue()) {
                return true;
            }
            if (expr.isFalse()) {
                return false;
            }
            return this.evaluate(expr).isTrue();
        }
        catch (MathException fce) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IExpr evaluate(IExpr expr) {
        boolean numericMode = this.fNumericMode;
        try {
            IExpr iExpr = this.evalWithoutNumericReset(expr);
            return iExpr;
        }
        finally {
            this.fNumericMode = numericMode;
        }
    }

    public final IExpr evaluate(String expression) {
        return this.evaluate(this.parse(expression));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IExpr evaluateNull(IExpr expr) {
        boolean numericMode = this.fNumericMode;
        try {
            IExpr iExpr = this.evalLoop(expr);
            return iExpr;
        }
        finally {
            this.fNumericMode = numericMode;
        }
    }

    @Override
    public final IExpr evalWithoutNumericReset(IExpr expr) {
        IExpr temp = this.evalLoop(expr);
        return temp == null ? expr : temp;
    }

    private IAST flattenSequences(IAST ast) {
        List seqResult = null;
        int astSize = ast.size();
        for (int i = 1; i < astSize; ++i) {
            if (((IExpr)ast.get(i)).isSequence()) {
                IAST seq = (IAST)ast.get(i);
                if (seqResult == null) {
                    seqResult = ast.copyUntil(i);
                }
                seqResult.addAll(seq, 1, seq.size());
                continue;
            }
            if (seqResult == null) continue;
            seqResult.add(ast.get(i));
        }
        return seqResult;
    }

    public IExpr getAnswer() {
        return this.fAnswer;
    }

    public int getIterationLimit() {
        return this.fIterationLimit;
    }

    public final Map<ISymbol, Stack<IExpr>> getLocalVariableStackMap() {
        if (this.fLocalVariableStackMap == null) {
            this.fLocalVariableStackMap = new IdentityHashMap();
        }
        return this.fLocalVariableStackMap;
    }

    public Set<ISymbol> getModifiedVariables() {
        return this.fModifiedVariablesList;
    }

    public LastCalculationsHistory getOutList() {
        return this.fOutList;
    }

    public PrintStream getOutPrintStream() {
        return this.fOutPrintStream;
    }

    public IAST getReapList() {
        return this.reapList;
    }

    public int getRecursionLimit() {
        return this.fRecursionLimit;
    }

    public String getSessionID() {
        return this.fSessionID;
    }

    public ISymbol getUserVariable(String symbolName) {
        if (this.fUserVariableMap == null) {
            this.fUserVariableMap = new HashMap<String, ISymbol>();
        }
        return this.fUserVariableMap.get(symbolName);
    }

    public ISymbol putUserVariable(String symbolName, ISymbol symbol) {
        if (this.fUserVariableMap == null) {
            this.fUserVariableMap = new HashMap<String, ISymbol>();
        }
        return this.fUserVariableMap.put(symbolName, symbol);
    }

    public void removeUserVariables(Map<ISymbol, ISymbol> moduleVariables) {
        if (this.fUserVariableMap != null) {
            for (ISymbol symbol : moduleVariables.values()) {
                this.fUserVariableMap.remove(symbol.toString());
            }
        }
    }

    public int incModuleCounter() {
        return ++this.fModuleCounter;
    }

    @Override
    public final void init() {
        this.fRecursionCounter = 0;
        this.fNumericMode = false;
        this.fEvalLHSMode = false;
        this.fTraceMode = false;
        this.fTraceStack = null;
        this.fStopRequested = false;
        this.fModifiedVariablesList = new HashSet<ISymbol>();
    }

    public boolean isEvalLHSMode() {
        return this.fEvalLHSMode;
    }

    public boolean isNumericMode() {
        return this.fNumericMode;
    }

    public boolean isOutListDisabled() {
        return this.fOutListDisabled;
    }

    public boolean isPackageMode() {
        return this.fPackageMode;
    }

    public boolean isQuietMode() {
        return this.fQuietMode;
    }

    public boolean isRelaxedSyntax() {
        return this.fRelaxedSyntax;
    }

    public boolean isStopRequested() {
        return this.fStopRequested;
    }

    public boolean isTraceMode() {
        return this.fTraceMode;
    }

    public final IExpr parse(String expression) {
        if (this.fRelaxedSyntax) {
            Parser parser = new Parser(this.fRelaxedSyntax);
            ASTNode node = parser.parse(expression);
            return AST2Expr.CONST_LC.convert(node, this);
        }
        Parser parser = new Parser();
        ASTNode node = parser.parse(expression);
        return AST2Expr.CONST.convert(node, this);
    }

    public final ASTNode parseNode(String expression) {
        if (this.fRelaxedSyntax) {
            Parser parser = new Parser(this.fRelaxedSyntax);
            return parser.parse(expression);
        }
        Parser parser = new Parser();
        return parser.parse(expression);
    }

    public void reset() {
        this.fNumericMode = false;
        this.fEvalLHSMode = false;
        this.fRecursionCounter = 0;
    }

    public void setIterationLimit(int i) {
        this.fIterationLimit = i;
    }

    public void setNumericMode(boolean b) {
        this.fNumericMode = b;
    }

    public void setNumericMode(boolean b, int precision) {
        this.fNumericMode = b;
        this.fNumericPrecision = precision;
    }

    public int getNumericPrecision() {
        return this.fNumericPrecision;
    }

    public boolean isApfloat() {
        return this.fNumericPrecision > 15;
    }

    public static boolean isApfloat(int precision) {
        return precision > 15;
    }

    public void setNumericPrecision(int precision) {
        this.fNumericPrecision = precision;
    }

    public void setOutListDisabled(boolean outListDisabled, int historyCapacity) {
        if (!outListDisabled) {
            if (this.fOutList == null) {
                this.fOutList = new LastCalculationsHistory(100);
            }
        } else {
            this.fOutList = null;
        }
        this.fOutListDisabled = outListDisabled;
    }

    public void setOutPrintStream(PrintStream outPrintStream) {
        this.fOutPrintStream = outPrintStream;
    }

    public void setPackageMode(boolean packageMode) {
        this.fPackageMode = packageMode;
    }

    public void setQuietMode(boolean quietMode) {
        this.fQuietMode = quietMode;
    }

    public void setReapList(IAST reapList) {
        this.reapList = reapList;
    }

    public void setRecursionLimit(int i) {
        this.fRecursionLimit = i;
    }

    public void setRelaxedSyntax(boolean fRelaxedSyntax) {
        this.fRelaxedSyntax = fRelaxedSyntax;
    }

    public void setSessionID(String string) {
        this.fSessionID = string;
    }

    public void setStopRequested(boolean stopRequested) {
        this.fStopRequested = stopRequested;
    }

    public void setTraceMode(boolean b) {
        this.fTraceMode = b;
    }

    public int sizeOut() {
        return this.fOutList.size();
    }

    public void stopRequest() {
        this.fStopRequested = true;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.fUserVariableMap != null) {
            buf.append(this.fUserVariableMap.toString());
        }
        if (this.fLocalVariableStackMap != null) {
            buf.append(this.fLocalVariableStackMap.toString());
        }
        if (SystemNamespace.DEFAULT != null) {
            buf.append(SystemNamespace.DEFAULT.toString());
        }
        return buf.toString();
    }
}

