/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.convert;

import com.google.common.base.Predicates;
import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.arith.ModLong;
import edu.jas.arith.ModLongRing;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.Monomial;
import edu.jas.poly.TermOrder;
import edu.jas.structure.RingElem;
import java.util.ArrayList;
import java.util.List;
import org.matheclipse.core.eval.exception.JASConversionException;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.exception.WrongArgumentType;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;

public class JASModInteger {
    private final ModLongRing fRingFactory;
    private final TermOrder fTermOrder;
    private final GenPolynomialRing<ModLong> fPolyFactory;
    private final GenPolynomialRing<BigInteger> fBigIntegerPolyFactory;
    private final List<? extends IExpr> fVariables;

    public JASModInteger(IExpr variable, ModLongRing ringFactory) {
        ArrayList<? extends IExpr> varList = new ArrayList<IExpr>();
        varList.add(variable);
        this.fRingFactory = ringFactory;
        this.fVariables = varList;
        String[] vars = new String[this.fVariables.size()];
        for (int i = 0; i < this.fVariables.size(); ++i) {
            vars[i] = this.fVariables.get(i).toString();
        }
        this.fTermOrder = new TermOrder(2);
        this.fPolyFactory = new GenPolynomialRing<ModLong>(this.fRingFactory, this.fVariables.size(), this.fTermOrder, vars);
        this.fBigIntegerPolyFactory = new GenPolynomialRing<BigInteger>(BigInteger.ZERO, this.fVariables.size(), this.fTermOrder, vars);
    }

    public JASModInteger(List<? extends IExpr> variablesList, ModLongRing ringFactory) {
        this(variablesList, ringFactory, new TermOrder(2));
    }

    public JASModInteger(List<? extends IExpr> variablesList, ModLongRing ringFactory, TermOrder termOrder) {
        this.fRingFactory = ringFactory;
        this.fVariables = variablesList;
        String[] vars = new String[this.fVariables.size()];
        for (int i = 0; i < this.fVariables.size(); ++i) {
            vars[i] = this.fVariables.get(i).toString();
        }
        this.fTermOrder = termOrder;
        this.fPolyFactory = new GenPolynomialRing<ModLong>(this.fRingFactory, this.fVariables.size(), this.fTermOrder, vars);
        this.fBigIntegerPolyFactory = new GenPolynomialRing<BigInteger>(BigInteger.ZERO, this.fVariables.size(), this.fTermOrder, vars);
    }

    public GenPolynomial<ModLong> expr2JAS(IExpr exprPoly) throws JASConversionException {
        try {
            return this.expr2Poly(exprPoly, false);
        }
        catch (Exception ae) {
            throw new JASConversionException();
        }
    }

    public GenPolynomial<ModLong> numericExpr2JAS(IExpr exprPoly) throws JASConversionException {
        try {
            return this.numericExpr2Poly(exprPoly);
        }
        catch (Exception ae) {
            throw new JASConversionException();
        }
    }

    public GenPolynomial<ModLong> expr2IExprJAS(IExpr exprPoly) throws JASConversionException {
        try {
            return this.expr2IExprPoly(exprPoly);
        }
        catch (Exception ae) {
            throw new JASConversionException();
        }
    }

    private GenPolynomial<ModLong> numericExpr2Poly(IExpr exprPoly) throws ArithmeticException, ClassCastException {
        return this.expr2Poly(exprPoly, true);
    }

    private GenPolynomial<ModLong> expr2Poly(IExpr exprPoly, boolean numeric2Rational) throws ArithmeticException, ClassCastException {
        if (exprPoly instanceof IAST) {
            IAST ast = (IAST)exprPoly;
            GenPolynomial<RingElem<ModLong>> result = this.fPolyFactory.getZERO();
            GenPolynomial<ModLong> p = this.fPolyFactory.getZERO();
            if (ast.isPlus()) {
                IExpr expr = (IExpr)ast.get(1);
                result = this.expr2Poly(expr, numeric2Rational);
                for (int i = 2; i < ast.size(); ++i) {
                    expr = (IExpr)ast.get(i);
                    p = this.expr2Poly(expr, numeric2Rational);
                    result = result.sum((RingElem<ModLong>)p);
                }
                return result;
            }
            if (ast.isTimes()) {
                IExpr expr = (IExpr)ast.get(1);
                result = this.expr2Poly(expr, numeric2Rational);
                for (int i = 2; i < ast.size(); ++i) {
                    expr = (IExpr)ast.get(i);
                    p = this.expr2Poly(expr, numeric2Rational);
                    result = result.multiply((RingElem<ModLong>)p);
                }
                return result;
            }
            if (ast.isPower()) {
                IExpr expr = (IExpr)ast.get(1);
                for (int i = 0; i < this.fVariables.size(); ++i) {
                    if (!this.fVariables.get(i).equals(expr)) continue;
                    int exponent = -1;
                    try {
                        exponent = Validate.checkPowerExponent(ast);
                    }
                    catch (WrongArgumentType e) {
                        // empty catch block
                    }
                    if (exponent < 0) {
                        throw new ArithmeticException("JASConvert:expr2Poly - invalid exponent: " + ast.arg2().toString());
                    }
                    ExpVector e = ExpVector.create(this.fVariables.size(), i, exponent);
                    return this.fPolyFactory.valueOf(e);
                }
            }
        } else if (exprPoly instanceof ISymbol) {
            for (int i = 0; i < this.fVariables.size(); ++i) {
                if (!this.fVariables.get(i).equals(exprPoly)) continue;
                ExpVector e = ExpVector.create(this.fVariables.size(), i, 1L);
                return ((GenPolynomial)this.fPolyFactory.getONE()).multiply(e);
            }
        } else if (exprPoly instanceof IInteger) {
            return this.fPolyFactory.fromInteger((java.math.BigInteger)((IInteger)exprPoly).asType(java.math.BigInteger.class));
        }
        throw new ClassCastException(exprPoly.toString());
    }

    private GenPolynomial<ModLong> fraction2Poly(IFraction exprPoly) {
        java.math.BigInteger n = exprPoly.getBigNumerator();
        java.math.BigInteger d = exprPoly.getBigDenominator();
        BigRational nr = new BigRational(n);
        BigRational dr = new BigRational(d);
        BigRational r = nr.divide(dr);
        return new GenPolynomial<BigRational>(this.fPolyFactory, r);
    }

    private GenPolynomial<ModLong> expr2IExprPoly(IExpr exprPoly) throws ArithmeticException, ClassCastException {
        if (exprPoly instanceof IAST) {
            IAST ast = (IAST)exprPoly;
            GenPolynomial<RingElem<ModLong>> result = this.fPolyFactory.getZERO();
            GenPolynomial<ModLong> p = this.fPolyFactory.getZERO();
            if (ast.isPlus()) {
                IExpr expr = (IExpr)ast.get(1);
                result = this.expr2IExprPoly(expr);
                for (int i = 2; i < ast.size(); ++i) {
                    expr = (IExpr)ast.get(i);
                    p = this.expr2IExprPoly(expr);
                    result = result.sum((RingElem<ModLong>)p);
                }
                return result;
            }
            if (ast.isTimes()) {
                IExpr expr = (IExpr)ast.get(1);
                result = this.expr2IExprPoly(expr);
                for (int i = 2; i < ast.size(); ++i) {
                    expr = (IExpr)ast.get(i);
                    p = this.expr2IExprPoly(expr);
                    result = result.multiply((RingElem<ModLong>)p);
                }
                return result;
            }
            if (ast.isPower()) {
                IExpr expr = (IExpr)ast.get(1);
                for (int i = 0; i < this.fVariables.size(); ++i) {
                    if (!this.fVariables.get(i).equals(expr)) continue;
                    int exponent = -1;
                    try {
                        exponent = Validate.checkPowerExponent(ast);
                    }
                    catch (WrongArgumentType e) {
                        // empty catch block
                    }
                    if (exponent < 0) {
                        throw new ArithmeticException("JASConvert:expr2Poly - invalid exponent: " + ast.arg2().toString());
                    }
                    ExpVector e = ExpVector.create(this.fVariables.size(), i, exponent);
                    return ((GenPolynomial)this.fPolyFactory.getONE()).multiply(e);
                }
            }
        } else {
            if (exprPoly instanceof ISymbol) {
                for (int i = 0; i < this.fVariables.size(); ++i) {
                    if (!this.fVariables.get(i).equals(exprPoly)) continue;
                    ExpVector e = ExpVector.create(this.fVariables.size(), i, 1L);
                    return ((GenPolynomial)this.fPolyFactory.getONE()).multiply(e);
                }
                return new GenPolynomial<IExpr>(this.fPolyFactory, exprPoly);
            }
            if (exprPoly instanceof IInteger) {
                return this.fPolyFactory.fromInteger((java.math.BigInteger)((IInteger)exprPoly).asType(java.math.BigInteger.class));
            }
            if (exprPoly instanceof IFraction) {
                return this.fraction2Poly((IFraction)exprPoly);
            }
        }
        if (exprPoly.isFree(Predicates.in(this.fVariables), true)) {
            return new GenPolynomial<IExpr>(this.fPolyFactory, exprPoly);
        }
        for (int i = 0; i < this.fVariables.size(); ++i) {
            if (!this.fVariables.get(i).equals(exprPoly)) continue;
            ExpVector e = ExpVector.create(this.fVariables.size(), i, 1L);
            return ((GenPolynomial)this.fPolyFactory.getONE()).multiply(e);
        }
        throw new ClassCastException(exprPoly.toString());
    }

    public GenPolynomialRing<ModLong> getPolynomialRingFactory() {
        return this.fPolyFactory;
    }

    public IExpr modLongPoly2Expr(GenPolynomial<ModLong> poly) throws ArithmeticException, ClassCastException {
        if (poly.length() == 0) {
            return F.Plus((IExpr)F.C0);
        }
        IAST result = F.Plus();
        for (Monomial<ModLong> monomial : poly) {
            ModLong coeff = monomial.coefficient();
            ExpVector exp = monomial.exponent();
            IInteger coeffValue = F.integer(coeff.getVal());
            IAST monomTimes = F.Times((IExpr)coeffValue);
            for (int i = 0; i < exp.length(); ++i) {
                long lExp = exp.getVal(i);
                if (lExp == 0L) continue;
                monomTimes.add(F.Power(this.fVariables.get(i), F.integer(lExp)));
            }
            result.add(monomTimes.getOneIdentity(F.C1));
        }
        return result.getOneIdentity(F.C0);
    }

    public static ModLongRing option2ModLongRing(ISignedNumber option) {
        long longValue = option.toLong();
        java.math.BigInteger value = java.math.BigInteger.valueOf(longValue);
        return new ModLongRing(longValue, value.isProbablePrime(32));
    }
}

