/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.convert;

import com.google.common.base.Predicates;
import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.poly.Complex;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.Monomial;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.TermOrder;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import org.matheclipse.core.eval.exception.JASConversionException;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.exception.WrongArgumentType;
import org.matheclipse.core.expression.ExprRingFactory;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.polynomials.ExponentArray;
import org.matheclipse.core.polynomials.Polynomial;

public class JASIExpr {
    private final RingFactory<IExpr> fRingFactory;
    private final TermOrder fTermOrder;
    private final GenPolynomialRing<IExpr> fPolyFactory;
    private final GenPolynomialRing<BigInteger> fBigIntegerPolyFactory;
    private final List<? extends IExpr> fVariables;
    private boolean fNumericFunction = false;

    public JASIExpr(IExpr variable, boolean numericFunction) {
        this(variable, new ExprRingFactory(), numericFunction);
    }

    public JASIExpr(IExpr variable, RingFactory<IExpr> ringFactory) {
        this(variable, ringFactory, false);
    }

    public JASIExpr(IExpr variable, RingFactory<IExpr> ringFactory, boolean numericFunction) {
        this.fNumericFunction = numericFunction;
        ArrayList<? extends IExpr> varList = new ArrayList<IExpr>();
        varList.add(variable);
        this.fRingFactory = ringFactory;
        this.fVariables = varList;
        String[] vars = new String[this.fVariables.size()];
        for (int i = 0; i < this.fVariables.size(); ++i) {
            vars[i] = this.fVariables.get(i).toString();
        }
        this.fTermOrder = new TermOrder(2);
        this.fPolyFactory = new GenPolynomialRing<IExpr>(this.fRingFactory, this.fVariables.size(), this.fTermOrder, vars);
        this.fBigIntegerPolyFactory = new GenPolynomialRing<BigInteger>(BigInteger.ZERO, this.fVariables.size(), this.fTermOrder, vars);
    }

    public JASIExpr(List<? extends IExpr> variablesList) {
        this(variablesList, new ExprRingFactory(), new TermOrder(2), false);
    }

    public JASIExpr(List<? extends IExpr> variablesList, boolean numericFunction) {
        this(variablesList, new ExprRingFactory(), new TermOrder(2), numericFunction);
    }

    public JASIExpr(List<? extends IExpr> variablesList, RingFactory<IExpr> ringFactory) {
        this(variablesList, ringFactory, new TermOrder(2), false);
    }

    public JASIExpr(List<? extends IExpr> variablesList, RingFactory<IExpr> ringFactory, TermOrder termOrder, boolean numericFunction) {
        this.fNumericFunction = numericFunction;
        this.fRingFactory = ringFactory;
        this.fVariables = variablesList;
        String[] vars = new String[this.fVariables.size()];
        for (int i = 0; i < this.fVariables.size(); ++i) {
            vars[i] = this.fVariables.get(i).toString();
        }
        this.fTermOrder = termOrder;
        this.fPolyFactory = new GenPolynomialRing<IExpr>(this.fRingFactory, this.fVariables.size(), this.fTermOrder, vars);
        this.fBigIntegerPolyFactory = new GenPolynomialRing<BigInteger>(BigInteger.ZERO, this.fVariables.size(), this.fTermOrder, vars);
    }

    public IExpr complexPoly2Expr(GenPolynomial<Complex<BigRational>> poly) throws ArithmeticException, ClassCastException {
        if (poly.length() == 0) {
            return F.C0;
        }
        IAST result = F.Plus();
        for (Monomial<Complex<BigRational>> monomial : poly) {
            Complex<BigRational> coeff = monomial.coefficient();
            ExpVector exp = monomial.exponent();
            BigRational re = coeff.getRe();
            BigRational im = coeff.getIm();
            IAST monomTimes = F.Times((IExpr)F.complex(F.fraction(re.numerator(), re.denominator()), F.fraction(im.numerator(), im.denominator())));
            for (int i = 0; i < exp.length(); ++i) {
                long lExp = exp.getVal(i);
                if (lExp == 0L) continue;
                monomTimes.add(F.Power(this.fVariables.get(i), F.integer(lExp)));
            }
            if (monomTimes.size() == 2) {
                result.add(monomTimes.get(1));
                continue;
            }
            result.add(monomTimes);
        }
        if (result.size() == 2) {
            return (IExpr)result.get(1);
        }
        return result;
    }

    public GenPolynomial<IExpr> expr2IExprJAS(IExpr exprPoly) throws JASConversionException {
        try {
            return this.expr2IExprPoly(exprPoly);
        }
        catch (Exception ae) {
            throw new JASConversionException();
        }
    }

    public GenPolynomial<IExpr> expr2IExprJAS(Polynomial exprPoly) {
        GenPolynomial<IExpr> result = new GenPolynomial<IExpr>(this.fPolyFactory);
        SortedMap<ExponentArray, org.matheclipse.core.polynomials.Monomial> monoms = exprPoly.getMonomials();
        for (org.matheclipse.core.polynomials.Monomial monom : monoms.values()) {
            long[] arr = monom.getExponents().getExponents();
            IExpr coeff = monom.getCoefficient();
            if (coeff.isZero()) continue;
            result.doPutToMap(ExpVector.create(arr), monom.getCoefficient());
        }
        return result;
    }

    private GenPolynomial<IExpr> expr2IExprPoly(IExpr exprPoly) throws ArithmeticException, ClassCastException {
        if (exprPoly instanceof IAST) {
            IAST ast = (IAST)exprPoly;
            GenPolynomial<RingElem<IExpr>> result = this.fPolyFactory.getZERO();
            GenPolynomial<IExpr> p = this.fPolyFactory.getZERO();
            if (ast.isPlus()) {
                IExpr expr = (IExpr)ast.get(1);
                result = this.expr2IExprPoly(expr);
                for (int i = 2; i < ast.size(); ++i) {
                    expr = (IExpr)ast.get(i);
                    p = this.expr2IExprPoly(expr);
                    result = result.sum((RingElem<IExpr>)p);
                }
                return result;
            }
            if (ast.isTimes()) {
                IExpr expr = (IExpr)ast.get(1);
                result = this.expr2IExprPoly(expr);
                for (int i = 2; i < ast.size(); ++i) {
                    expr = (IExpr)ast.get(i);
                    p = this.expr2IExprPoly(expr);
                    result = result.multiply((RingElem<IExpr>)p);
                }
                return result;
            }
            if (ast.isPower()) {
                IExpr expr = (IExpr)ast.get(1);
                for (int i = 0; i < this.fVariables.size(); ++i) {
                    if (!this.fVariables.get(i).equals(expr)) continue;
                    int exponent = -1;
                    try {
                        exponent = Validate.checkPowerExponent(ast);
                    }
                    catch (WrongArgumentType e) {
                        // empty catch block
                    }
                    if (exponent < 0) {
                        throw new ArithmeticException("JASConvert:expr2Poly - invalid exponent: " + ast.arg2().toString());
                    }
                    ExpVector e = ExpVector.create(this.fVariables.size(), i, exponent);
                    return ((GenPolynomial)this.fPolyFactory.getONE()).multiply(e);
                }
            } else if (this.fNumericFunction && ast.isNumericFunction()) {
                return new GenPolynomial<IExpr>(this.fPolyFactory, ast);
            }
        } else {
            if (exprPoly instanceof ISymbol) {
                for (int i = 0; i < this.fVariables.size(); ++i) {
                    if (!this.fVariables.get(i).equals(exprPoly)) continue;
                    ExpVector e = ExpVector.create(this.fVariables.size(), i, 1L);
                    return ((GenPolynomial)this.fPolyFactory.getONE()).multiply(e);
                }
                if (this.fNumericFunction) {
                    if (exprPoly.isNumericFunction()) {
                        return new GenPolynomial<IExpr>(this.fPolyFactory, exprPoly);
                    }
                    throw new ClassCastException(exprPoly.toString());
                }
                return new GenPolynomial<IExpr>(this.fPolyFactory, exprPoly);
            }
            if (exprPoly instanceof IInteger) {
                return new GenPolynomial<IExpr>(this.fPolyFactory, exprPoly);
            }
            if (exprPoly instanceof IFraction) {
                return new GenPolynomial<IExpr>(this.fPolyFactory, exprPoly);
            }
        }
        if (exprPoly.isFree(Predicates.in(this.fVariables), true)) {
            return new GenPolynomial<IExpr>(this.fPolyFactory, exprPoly);
        }
        for (int i = 0; i < this.fVariables.size(); ++i) {
            if (!this.fVariables.get(i).equals(exprPoly)) continue;
            ExpVector e = ExpVector.create(this.fVariables.size(), i, 1L);
            return ((GenPolynomial)this.fPolyFactory.getONE()).multiply(e);
        }
        throw new ClassCastException(exprPoly.toString());
    }

    public IExpr exprPoly2Expr(GenPolynomial<IExpr> poly) {
        return this.exprPoly2Expr(poly, null);
    }

    public IExpr exprPoly2Expr(GenPolynomial<IExpr> poly, IExpr variable) {
        if (poly.length() == 0) {
            return F.Plus((IExpr)F.C0);
        }
        boolean getVar = variable == null;
        IAST result = F.Plus();
        for (Monomial<IExpr> monomial : poly) {
            IExpr coeff = monomial.coefficient();
            ExpVector exp = monomial.exponent();
            IAST monomTimes = F.Times(coeff);
            for (int i = 0; i < exp.length(); ++i) {
                long lExp = exp.getVal(i);
                if (lExp == 0L) continue;
                if (getVar) {
                    variable = this.fVariables.get(i);
                }
                monomTimes.add(F.Power(variable, F.integer(lExp)));
            }
            result.add(monomTimes.getOneIdentity(F.C1));
        }
        return result.getOneIdentity(F.C0);
    }

    public Object[] factorTerms(GenPolynomial<BigRational> A) {
        return PolyUtil.integerFromRationalCoefficientsFactor(this.fBigIntegerPolyFactory, A);
    }

    public GenPolynomialRing<IExpr> getPolynomialRingFactory() {
        return this.fPolyFactory;
    }

    public GenPolynomial<BigInteger> integerFromRationalCoefficients(GenPolynomial<BigRational> A) {
        return PolyUtil.integerFromRationalCoefficients(this.fBigIntegerPolyFactory, A);
    }

    public IExpr integerPoly2Expr(GenPolynomial<BigInteger> poly) throws ArithmeticException, ClassCastException {
        if (poly.length() == 0) {
            return F.C0;
        }
        IAST result = F.Plus();
        for (Monomial<BigInteger> monomial : poly) {
            BigInteger coeff = monomial.coefficient();
            ExpVector exp = monomial.exponent();
            IInteger coeffValue = F.integer(coeff.getVal());
            IAST monomTimes = F.Times((IExpr)coeffValue);
            for (int i = 0; i < exp.length(); ++i) {
                long lExp = exp.getVal(i);
                if (lExp == 0L) continue;
                monomTimes.add(F.Power(this.fVariables.get(i), F.integer(lExp)));
            }
            if (monomTimes.size() == 2) {
                result.add(monomTimes.get(1));
                continue;
            }
            result.add(monomTimes);
        }
        if (result.size() == 2) {
            return (IExpr)result.get(1);
        }
        return result;
    }
}

