/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.convert;

import edu.jas.arith.BigRational;
import edu.jas.arith.ModIntegerRing;
import edu.jas.integrate.Integral;
import edu.jas.integrate.LogIntegral;
import edu.jas.integrate.QuotIntegral;
import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.Complex;
import edu.jas.poly.ComplexRing;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.Monomial;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.TermOrder;
import edu.jas.structure.ElemFactory;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import edu.jas.structure.UnaryFunctor;
import edu.jas.ufd.Quotient;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.matheclipse.core.eval.exception.JASConversionException;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.exception.WrongArgumentType;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IComplex;
import org.matheclipse.core.interfaces.IComplexNum;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.INumber;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;

public class JASConvert<C extends RingElem<C>> {
    private final RingFactory<C> fRingFactory;
    private final TermOrder fTermOrder;
    private final GenPolynomialRing<C> fPolyFactory;
    private final GenPolynomialRing<edu.jas.arith.BigInteger> fBigIntegerPolyFactory;
    private final List<? extends IExpr> fVariables;

    public JASConvert(IExpr variable, RingFactory<C> ringFactory) {
        ArrayList<? extends IExpr> varList = new ArrayList<IExpr>();
        varList.add(variable);
        this.fRingFactory = ringFactory;
        this.fVariables = varList;
        String[] vars = new String[this.fVariables.size()];
        for (int i = 0; i < this.fVariables.size(); ++i) {
            vars[i] = this.fVariables.get(i).toString();
        }
        this.fTermOrder = new TermOrder(2);
        this.fPolyFactory = new GenPolynomialRing<C>(this.fRingFactory, this.fVariables.size(), this.fTermOrder, vars);
        this.fBigIntegerPolyFactory = new GenPolynomialRing<edu.jas.arith.BigInteger>(edu.jas.arith.BigInteger.ZERO, this.fVariables.size(), this.fTermOrder, vars);
    }

    public JASConvert(List<? extends IExpr> variablesList, RingFactory<C> ringFactory) {
        this(variablesList, ringFactory, new TermOrder(2));
    }

    public JASConvert(List<? extends IExpr> variablesList, RingFactory<C> ringFactory, TermOrder termOrder) {
        this.fRingFactory = ringFactory;
        this.fVariables = variablesList;
        String[] vars = new String[this.fVariables.size()];
        for (int i = 0; i < this.fVariables.size(); ++i) {
            vars[i] = this.fVariables.get(i).toString();
        }
        this.fTermOrder = termOrder;
        this.fPolyFactory = new GenPolynomialRing<C>(this.fRingFactory, this.fVariables.size(), this.fTermOrder, vars);
        this.fBigIntegerPolyFactory = new GenPolynomialRing<edu.jas.arith.BigInteger>(edu.jas.arith.BigInteger.ZERO, this.fVariables.size(), this.fTermOrder, vars);
    }

    public GenPolynomial<C> expr2JAS(IExpr exprPoly, boolean numeric2Rational) throws JASConversionException {
        try {
            return this.expr2Poly(exprPoly, numeric2Rational);
        }
        catch (Exception ae) {
            throw new JASConversionException();
        }
    }

    public GenPolynomial<C> numericExpr2JAS(IExpr exprPoly) throws JASConversionException {
        try {
            return this.numericExpr2Poly(exprPoly);
        }
        catch (Exception ae) {
            throw new JASConversionException();
        }
    }

    private GenPolynomial<C> numericExpr2Poly(IExpr exprPoly) throws ArithmeticException, ClassCastException {
        return this.expr2Poly(exprPoly, true);
    }

    private GenPolynomial<C> expr2Poly(IExpr exprPoly, boolean numeric2Rational) throws ArithmeticException, ClassCastException {
        if (exprPoly instanceof IAST) {
            IAST ast = (IAST)exprPoly;
            GenPolynomial<Object> result = this.fPolyFactory.getZERO();
            GenPolynomial<C> p = this.fPolyFactory.getZERO();
            if (ast.isPlus()) {
                IExpr expr = (IExpr)ast.get(1);
                result = this.expr2Poly(expr, numeric2Rational);
                for (int i = 2; i < ast.size(); ++i) {
                    expr = (IExpr)ast.get(i);
                    p = this.expr2Poly(expr, numeric2Rational);
                    result = result.sum((Object)p);
                }
                return result;
            }
            if (ast.isTimes()) {
                IExpr expr = (IExpr)ast.get(1);
                result = this.expr2Poly(expr, numeric2Rational);
                for (int i = 2; i < ast.size(); ++i) {
                    expr = (IExpr)ast.get(i);
                    p = this.expr2Poly(expr, numeric2Rational);
                    result = result.multiply((Object)p);
                }
                return result;
            }
            if (ast.isPower()) {
                IExpr expr = (IExpr)ast.get(1);
                for (int i = 0; i < this.fVariables.size(); ++i) {
                    if (!this.fVariables.get(i).equals(expr)) continue;
                    int exponent = -1;
                    try {
                        exponent = Validate.checkPowerExponent(ast);
                    }
                    catch (WrongArgumentType e) {
                        // empty catch block
                    }
                    if (exponent < 0) {
                        throw new ArithmeticException("JASConvert:expr2Poly - invalid exponent: " + ast.arg2().toString());
                    }
                    ExpVector e = ExpVector.create(this.fVariables.size(), i, exponent);
                    return this.fPolyFactory.valueOf(e);
                }
            }
        } else if (exprPoly instanceof ISymbol) {
            for (int i = 0; i < this.fVariables.size(); ++i) {
                if (!this.fVariables.get(i).equals(exprPoly)) continue;
                ExpVector e = ExpVector.create(this.fVariables.size(), i, 1L);
                return ((GenPolynomial)this.fPolyFactory.getONE()).multiply(e);
            }
        } else {
            if (exprPoly instanceof IInteger) {
                return this.fPolyFactory.fromInteger((BigInteger)((IInteger)exprPoly).asType(BigInteger.class));
            }
            if (exprPoly instanceof IFraction) {
                return this.fraction2Poly((IFraction)exprPoly);
            }
            if (exprPoly instanceof INum && numeric2Rational) {
                IFraction frac = F.fraction(((INum)exprPoly).getRealPart());
                return this.fraction2Poly(frac);
            }
            if (exprPoly instanceof IComplexNum && numeric2Rational && F.isZero(((IComplexNum)exprPoly).getImaginaryPart())) {
                IFraction frac = F.fraction(((INum)exprPoly).getRealPart());
                return this.fraction2Poly(frac);
            }
        }
        throw new ClassCastException(exprPoly.toString());
    }

    private GenPolynomial<C> fraction2Poly(IFraction exprPoly) {
        BigInteger n = exprPoly.getBigNumerator();
        BigInteger d = exprPoly.getBigDenominator();
        BigRational nr = new BigRational(n);
        BigRational dr = new BigRational(d);
        BigRational r = nr.divide(dr);
        if (this.fRingFactory instanceof ComplexRing) {
            ComplexRing ring = (ComplexRing)this.fRingFactory;
            Complex<BigRational> c = new Complex<BigRational>(ring, r);
            return new GenPolynomial<Complex<BigRational>>(this.fPolyFactory, c);
        }
        return new GenPolynomial<BigRational>(this.fPolyFactory, r);
    }

    public Object[] factorTerms(GenPolynomial<BigRational> A) {
        return PolyUtil.integerFromRationalCoefficientsFactor(this.fBigIntegerPolyFactory, A);
    }

    public GenPolynomialRing<C> getPolynomialRingFactory() {
        return this.fPolyFactory;
    }

    public GenPolynomial<edu.jas.arith.BigInteger> integerFromRationalCoefficients(GenPolynomial<BigRational> A) {
        return PolyUtil.integerFromRationalCoefficients(this.fBigIntegerPolyFactory, A);
    }

    public IExpr integerPoly2Expr(GenPolynomial<edu.jas.arith.BigInteger> poly) throws ArithmeticException, ClassCastException {
        if (poly.length() == 0) {
            return F.C0;
        }
        IAST result = F.Plus();
        for (Monomial<edu.jas.arith.BigInteger> monomial : poly) {
            edu.jas.arith.BigInteger coeff = monomial.coefficient();
            ExpVector exp = monomial.exponent();
            IInteger coeffValue = F.integer(coeff.getVal());
            IAST monomTimes = F.Times((IExpr)coeffValue);
            for (int i = 0; i < exp.length(); ++i) {
                long lExp = exp.getVal(i);
                if (lExp == 0L) continue;
                monomTimes.add(F.Power(this.fVariables.get(i), F.integer(lExp)));
            }
            if (monomTimes.size() == 2) {
                result.add(monomTimes.get(1));
                continue;
            }
            result.add(monomTimes);
        }
        if (result.size() == 2) {
            return (IExpr)result.get(1);
        }
        return result;
    }

    public IExpr complexPoly2Expr(GenPolynomial<Complex<BigRational>> poly) throws ArithmeticException, ClassCastException {
        if (poly.length() == 0) {
            return F.C0;
        }
        IAST result = F.Plus();
        for (Monomial<Complex<BigRational>> monomial : poly) {
            Complex<BigRational> coeff = monomial.coefficient();
            ExpVector exp = monomial.exponent();
            BigRational re = coeff.getRe();
            BigRational im = coeff.getIm();
            IAST monomTimes = F.Times((IExpr)F.complex(F.fraction(re.numerator(), re.denominator()), F.fraction(im.numerator(), im.denominator())));
            for (int i = 0; i < exp.length(); ++i) {
                long lExp = exp.getVal(i);
                if (lExp == 0L) continue;
                monomTimes.add(F.Power(this.fVariables.get(i), F.integer(lExp)));
            }
            if (monomTimes.size() == 2) {
                result.add(monomTimes.get(1));
                continue;
            }
            result.add(monomTimes);
        }
        if (result.size() == 2) {
            return (IExpr)result.get(1);
        }
        return result;
    }

    public IAST integral2Expr(Integral<BigRational> integral) {
        IAST sum = F.Plus();
        GenPolynomial<BigRational> pol = integral.pol;
        List rational = integral.rational;
        List logarithm = integral.logarithm;
        if (!pol.isZERO()) {
            sum.add(this.poly2Expr(pol, null));
        }
        if (rational.size() != 0) {
            int i = 0;
            while (i < rational.size()) {
                sum.add(F.Times((IExpr)this.poly2Expr(rational.get(i++), null), (IExpr)F.Power((IExpr)this.poly2Expr(rational.get(i++), null), F.CN1)));
            }
        }
        if (logarithm.size() != 0) {
            for (LogIntegral<BigRational> logIntegral : logarithm) {
                sum.add(this.logIntegral2Expr(logIntegral));
            }
        }
        return sum;
    }

    public IAST logIntegral2Expr(LogIntegral<BigRational> logIntegral) {
        int i;
        IAST plus = F.Plus();
        List cfactors = logIntegral.cfactors;
        List cdenom = logIntegral.cdenom;
        List afactors = logIntegral.afactors;
        List adenom = logIntegral.adenom;
        if (cfactors.size() > 0) {
            for (i = 0; i < cfactors.size(); ++i) {
                BigRational cp = (BigRational)cfactors.get(i);
                GenPolynomial<BigRational> p = cdenom.get(i);
                plus.add(F.Times((IExpr)F.fraction(cp.numerator(), cp.denominator()), (IExpr)F.Log(this.poly2Expr(p, null))));
            }
        }
        if (afactors.size() > 0) {
            for (i = 0; i < afactors.size(); ++i) {
                AlgebraicNumber ap = afactors.get(i);
                ElemFactory ar = ap.factory();
                GenPolynomial<AlgebraicNumber<BigRational>> p = adenom.get(i);
                if (p.degree(0) >= ((AlgebraicNumberRing)ar).modul.degree(0) || ((AlgebraicNumberRing)ar).modul.degree(0) > 2L) {
                    // empty if block
                }
                GenPolynomial<BigRational> v = ap.getVal();
                IAST times = F.Times();
                AlgebraicNumber arGen = ((AlgebraicNumberRing)ar).getGenerator();
                if (p.degree(0) < ((AlgebraicNumberRing)ar).modul.degree(0) && ((AlgebraicNumberRing)ar).modul.degree(0) > 2L) {
                    IAST rootOf = F.ast(F.RootOf);
                    rootOf.add(this.poly2Expr(((AlgebraicNumberRing)ar).modul, null));
                    times.add(rootOf);
                    throw new UnsupportedOperationException("JASConvert#logIntegral2Expr()");
                }
                times.add(this.poly2Expr(v, null));
                times.add(F.Log(this.polyAlgebraicNumber2Expr(p)));
                plus.add(times);
            }
        }
        return plus;
    }

    public IAST poly2Expr(GenPolynomial<BigRational> poly) throws ArithmeticException, ClassCastException {
        return this.poly2Expr(poly, null);
    }

    public IAST poly2Expr(GenPolynomial<BigRational> poly, IExpr variable) throws ArithmeticException, ClassCastException {
        if (poly.length() == 0) {
            return F.Plus((IExpr)F.C0);
        }
        boolean getVar = variable == null;
        IAST result = F.Plus();
        for (Monomial<BigRational> monomial : poly) {
            BigRational coeff = monomial.coefficient();
            ExpVector exp = monomial.exponent();
            IFraction coeffValue = F.fraction(coeff.numerator(), coeff.denominator());
            IAST monomTimes = F.Times((IExpr)coeffValue);
            for (int i = 0; i < exp.length(); ++i) {
                long lExp = exp.getVal(i);
                if (lExp == 0L) continue;
                if (getVar) {
                    variable = this.fVariables.get(i);
                }
                monomTimes.add(F.Power(variable, F.integer(lExp)));
            }
            result.add(monomTimes);
        }
        return result;
    }

    public IExpr exprPoly2Expr(GenPolynomial<IExpr> poly, IExpr variable) throws ArithmeticException, ClassCastException {
        if (poly.length() == 0) {
            return F.Plus((IExpr)F.C0);
        }
        boolean getVar = variable == null;
        IAST result = F.Plus();
        for (Monomial<IExpr> monomial : poly) {
            IExpr coeff = monomial.coefficient();
            ExpVector exp = monomial.exponent();
            IAST monomTimes = F.Times(coeff);
            for (int i = 0; i < exp.length(); ++i) {
                long lExp = exp.getVal(i);
                if (lExp == 0L) continue;
                if (getVar) {
                    variable = this.fVariables.get(i);
                }
                monomTimes.add(F.Power(variable, F.integer(lExp)));
            }
            result.add(monomTimes.getOneIdentity(F.C1));
        }
        return result.getOneIdentity(F.C0);
    }

    public IAST polyAlgebraicNumber2Expr(GenPolynomial<AlgebraicNumber<BigRational>> poly) throws ArithmeticException, ClassCastException {
        if (poly.length() == 0) {
            return F.Plus((IExpr)F.C0);
        }
        SortedMap<ExpVector, AlgebraicNumber<BigRational>> val = poly.getMap();
        if (val.size() == 0) {
            return F.Plus((IExpr)F.C0);
        }
        IAST result = F.Plus();
        String symbolName = ((GenPolynomialRing)poly.factory()).getVars()[0];
        ISymbol sym = F.$s(symbolName);
        for (Map.Entry<ExpVector, AlgebraicNumber<BigRational>> m : val.entrySet()) {
            long lExp;
            AlgebraicNumber<BigRational> c = m.getValue();
            IAST times = F.Times();
            ExpVector e = m.getKey();
            if (!c.isONE() || e.isZERO()) {
                times.add(this.algebraicNumber2Expr(c, sym));
            }
            if (e != null && sym != null && (lExp = e.getVal(0)) != 0L) {
                times.add(F.Power((IExpr)sym, F.integer(lExp)));
            }
            if (times.size() <= 1) continue;
            result.add(times);
        }
        return result;
    }

    public IAST algebraicNumber2Expr(AlgebraicNumber<BigRational> coeff, IExpr variable) throws ArithmeticException, ClassCastException {
        GenPolynomial<BigRational> val = coeff.val;
        return this.poly2Expr(val, variable);
    }

    public IAST quotIntegral2Expr(QuotIntegral<BigRational> integral) {
        IAST sum = F.Plus();
        List rational = integral.rational;
        List logarithm = integral.logarithm;
        if (rational.size() != 0) {
            for (int i = 0; i < rational.size(); ++i) {
                Quotient qTemp = rational.get(i);
                GenPolynomial<BigRational> genPolynomial = qTemp.num;
                GenPolynomial<BigRational> qDen = qTemp.den;
                sum.add(F.Times((IExpr)this.poly2Expr(genPolynomial, null), (IExpr)F.Power((IExpr)this.poly2Expr(qDen, null), F.CN1)));
            }
        }
        if (logarithm.size() != 0) {
            for (LogIntegral<BigRational> logIntegral : logarithm) {
                sum.add(this.logIntegral2Expr(logIntegral));
            }
        }
        return sum;
    }

    public IAST rationalPoly2Expr(GenPolynomial<BigRational> poly) throws ArithmeticException, ClassCastException {
        if (poly.length() == 0) {
            return F.Plus((IExpr)F.C0);
        }
        IAST result = F.Plus();
        for (Monomial<BigRational> monomial : poly) {
            BigRational coeff = monomial.coefficient();
            ExpVector exp = monomial.exponent();
            IFraction coeffValue = F.fraction(coeff.numerator(), coeff.denominator());
            IAST monomTimes = F.Times((IExpr)coeffValue);
            for (int i = 0; i < exp.length(); ++i) {
                long lExp = exp.getVal(i);
                if (lExp == 0L) continue;
                monomTimes.add(F.Power(this.fVariables.get(i), F.integer(lExp)));
            }
            result.add(monomTimes);
        }
        return result;
    }

    public static ModIntegerRing option2ModIntegerRing(ISignedNumber option) {
        long longValue = option.toLong();
        BigInteger value = BigInteger.valueOf(longValue);
        return new ModIntegerRing(longValue, value.isProbablePrime(32));
    }

    public static IComplex jas2Complex(Complex<BigRational> c) {
        IFraction re = F.fraction(c.getRe().numerator(), c.getRe().denominator());
        IFraction im = F.fraction(c.getIm().numerator(), c.getIm().denominator());
        return F.complex(re, im);
    }

    public static INumber jas2Numeric(Complex<BigRational> c, double epsilon) {
        IFraction re = F.fraction(c.getRe().numerator(), c.getRe().denominator());
        double red = re.doubleValue();
        IFraction im = F.fraction(c.getIm().numerator(), c.getIm().denominator());
        double imd = im.doubleValue();
        return F.chopNumber(F.complexNum(red, imd), epsilon);
    }

    public static INumber jas2Numeric(org.apache.commons.math3.complex.Complex c, double epsilon) {
        double red = c.getReal();
        double imd = c.getImaginary();
        return F.chopNumber(F.complexNum(red, imd), epsilon);
    }

    public static Object[] rationalFromRationalCoefficientsFactor(GenPolynomialRing<BigRational> fac, GenPolynomial<BigRational> A) {
        Object[] result = new Object[3];
        if (A == null || A.isZERO()) {
            result[0] = BigInteger.ONE;
            result[1] = BigInteger.ZERO;
            result[2] = fac.getZERO();
            return result;
        }
        BigInteger gcd = null;
        BigInteger lcm = null;
        int sLCM = 0;
        int sGCD = 0;
        Iterator<BigRational> iter = A.coefficientIterator();
        while (iter.hasNext()) {
            BigRational y = iter.next();
            BigInteger numerator = y.numerator();
            BigInteger denominator = y.denominator();
            if (lcm == null) {
                lcm = denominator;
                sLCM = denominator.signum();
            } else {
                BigInteger d = lcm.gcd(denominator);
                lcm = lcm.multiply(denominator.divide(d));
            }
            if (gcd == null) {
                gcd = numerator;
                sGCD = numerator.signum();
                continue;
            }
            gcd = gcd.gcd(numerator);
        }
        if (sLCM < 0) {
            lcm = lcm.negate();
        }
        if (sGCD < 0) {
            gcd = gcd.negate();
        }
        result[0] = gcd;
        result[1] = lcm;
        result[2] = PolyUtil.map(fac, A, new RatToRatFactor(gcd, lcm));
        return result;
    }

    static class RatToRatFactor
    implements UnaryFunctor<BigRational, BigRational> {
        final BigInteger lcm;
        final BigInteger gcd;

        public RatToRatFactor(BigInteger gcd, BigInteger lcm) {
            this.gcd = gcd;
            this.lcm = lcm;
        }

        @Override
        public BigRational eval(BigRational c) {
            if (c == null) {
                return BigRational.ZERO;
            }
            if (this.gcd.equals(BigInteger.ONE)) {
                BigInteger b = this.lcm.divide(c.denominator());
                return BigRational.valueOf(c.numerator().multiply(b));
            }
            BigInteger a = c.numerator().divide(this.gcd);
            BigInteger b = this.lcm.divide(c.denominator());
            return BigRational.valueOf(a.multiply(b));
        }
    }
}

