/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.convert;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.visit.VisitorCollectionBoolean;

public class ExprVariables {
    private final Set<IExpr> set = new TreeSet<IExpr>();

    public ExprVariables() {
    }

    public ExprVariables(IExpr expression) {
        expression.accept(new VariablesVisitor(1, this.set));
    }

    public boolean add(ISymbol symbol) {
        return this.set.add(symbol);
    }

    public void addVarList(IExpr expression) {
        expression.accept(new VariablesVisitor(1, this.set));
    }

    public boolean contains(IExpr o) {
        return this.set.contains(o);
    }

    public boolean containsAll(Collection<? extends IExpr> c) {
        return this.set.containsAll(c);
    }

    public IAST getVarList() {
        Iterator<IExpr> iter = this.set.iterator();
        IAST list = F.List();
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        return list;
    }

    public List<IExpr> getArrayList() {
        Iterator<IExpr> iter = this.set.iterator();
        ArrayList<IExpr> list = new ArrayList<IExpr>();
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        return list;
    }

    public List<IExpr> appendToList(List<IExpr> list) {
        Iterator<IExpr> iter = this.set.iterator();
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        return list;
    }

    public String[] getVarListAsString() {
        String[] result = new String[this.set.size()];
        Iterator<IExpr> iter = this.set.iterator();
        int i = 0;
        while (iter.hasNext()) {
            result[i++] = iter.next().toString();
        }
        return result;
    }

    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    public boolean isSize(int size) {
        return this.set.size() == size;
    }

    public int size() {
        return this.set.size();
    }

    public IExpr[] toArray(IExpr[] a) {
        return this.set.toArray(a);
    }

    public static class VariablesVisitor
    extends VisitorCollectionBoolean {
        public VariablesVisitor(int hOffset, Collection<IExpr> collection) {
            super(hOffset, collection);
        }

        @Override
        public boolean visit(ISymbol symbol) {
            return !symbol.isConstant();
        }
    }
}

