/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.convert;

import org.apache.commons.math3.FieldElement;
import org.apache.commons.math3.analysis.polynomials.PolynomialFunction;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.ArrayFieldVector;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.BlockFieldMatrix;
import org.apache.commons.math3.linear.FieldMatrix;
import org.apache.commons.math3.linear.FieldVector;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.matheclipse.core.expression.ExprFieldElement;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.INumber;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;

public class Convert {
    private Convert() {
    }

    public static IExpr doubleToExprTranspose(double[][] dd) {
        IAST list = F.List();
        try {
            for (int j = 0; j < dd[0].length; ++j) {
                IAST row = F.List();
                for (int i = 0; i < dd.length; ++i) {
                    row.add(F.num(dd[i][j]));
                }
                list.add(row);
            }
            list.addEvalFlags(32);
            return list;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static FieldMatrix<ExprFieldElement> list2Matrix(IAST listMatrix) throws ClassCastException, IndexOutOfBoundsException {
        if (listMatrix == null) {
            return null;
        }
        IExpr header = listMatrix.head();
        if (header != F.List) {
            return null;
        }
        IAST currInRow = (IAST)listMatrix.get(1);
        if (currInRow.size() == 1) {
            FieldElement[][] array = new ExprFieldElement[0][0];
            return new BlockFieldMatrix(array);
        }
        int rowSize = listMatrix.size() - 1;
        int colSize = currInRow.size() - 1;
        FieldElement[][] elements = new ExprFieldElement[rowSize][colSize];
        for (int i = 1; i < rowSize + 1; ++i) {
            currInRow = (IAST)listMatrix.get(i);
            if (currInRow.head() != F.List) {
                return null;
            }
            for (int j = 1; j < colSize + 1; ++j) {
                elements[i - 1][j - 1] = new ExprFieldElement((IExpr)currInRow.get(j));
            }
        }
        return new BlockFieldMatrix(elements);
    }

    public static IAST matrix2List(FieldMatrix<ExprFieldElement> matrix) {
        if (matrix == null) {
            return null;
        }
        int rowSize = matrix.getRowDimension();
        int colSize = matrix.getColumnDimension();
        IAST out = F.List();
        for (int i = 0; i < rowSize; ++i) {
            IAST currOutRow = F.List();
            out.add(currOutRow);
            for (int j = 0; j < colSize; ++j) {
                IExpr expr = matrix.getEntry(i, j).getExpr();
                if (expr instanceof INumber) {
                    currOutRow.add(expr);
                    continue;
                }
                currOutRow.add(F.eval(F.Together(expr)));
            }
        }
        out.addEvalFlags(32);
        return out;
    }

    public static RealMatrix list2RealMatrix(IAST listMatrix) throws ClassCastException, IndexOutOfBoundsException {
        if (listMatrix == null) {
            return null;
        }
        IExpr header = listMatrix.head();
        if (header != F.List) {
            return null;
        }
        IAST currInRow = (IAST)listMatrix.get(1);
        if (currInRow.size() == 1) {
            double[][] array = new double[0][0];
            return new Array2DRowRealMatrix(array);
        }
        int rowSize = listMatrix.size() - 1;
        int colSize = currInRow.size() - 1;
        double[][] elements = new double[rowSize][colSize];
        for (int i = 1; i < rowSize + 1; ++i) {
            currInRow = (IAST)listMatrix.get(i);
            if (currInRow.head() != F.List) {
                return null;
            }
            for (int j = 1; j < colSize + 1; ++j) {
                elements[i - 1][j - 1] = ((ISignedNumber)currInRow.get(j)).doubleValue();
            }
        }
        return new Array2DRowRealMatrix(elements);
    }

    public static IAST realMatrix2List(RealMatrix matrix) {
        if (matrix == null) {
            return null;
        }
        int rowSize = matrix.getRowDimension();
        int colSize = matrix.getColumnDimension();
        IAST out = F.List();
        for (int i = 0; i < rowSize; ++i) {
            IAST currOutRow = F.List();
            out.add(currOutRow);
            for (int j = 0; j < colSize; ++j) {
                currOutRow.add(F.num(matrix.getEntry(i, j)));
            }
        }
        out.addEvalFlags(32);
        return out;
    }

    public static FieldVector<ExprFieldElement> list2Vector(IAST listVector) throws ClassCastException, IndexOutOfBoundsException {
        if (listVector == null) {
            return null;
        }
        IExpr header = listVector.head();
        if (header != F.List) {
            return null;
        }
        int rowSize = listVector.size() - 1;
        FieldElement[] elements = new ExprFieldElement[rowSize];
        for (int i = 0; i < rowSize; ++i) {
            elements[i] = new ExprFieldElement((IExpr)listVector.get(i + 1));
        }
        return new ArrayFieldVector(elements);
    }

    public static RealVector list2RealVector(IAST listVector) throws ClassCastException, IndexOutOfBoundsException {
        if (listVector == null) {
            return null;
        }
        IExpr header = listVector.head();
        if (header != F.List) {
            return null;
        }
        int rowSize = listVector.size() - 1;
        double[] elements = new double[rowSize];
        for (int i = 0; i < rowSize; ++i) {
            elements[i] = ((ISignedNumber)listVector.get(i + 1)).doubleValue();
        }
        return new ArrayRealVector(elements);
    }

    public static IAST vector2List(FieldVector<ExprFieldElement> vector) {
        if (vector == null) {
            return null;
        }
        int rowSize = vector.getDimension();
        IAST out = F.List();
        for (int i = 0; i < rowSize; ++i) {
            out.add(vector.getEntry(i).getExpr());
        }
        out.addEvalFlags(64);
        return out;
    }

    public static IAST realVector2List(RealVector vector) {
        if (vector == null) {
            return null;
        }
        int rowSize = vector.getDimension();
        IAST out = F.ast(F.List);
        for (int i = 0; i < rowSize; ++i) {
            out.add(F.num(vector.getEntry(i)));
        }
        out.addEvalFlags(64);
        return out;
    }

    public static IExpr polynomialFunction2Expr(PolynomialFunction pf, ISymbol sym) {
        double[] coefficients = pf.getCoefficients();
        return Convert.polynomialFunction2Expr(coefficients, sym);
    }

    public static IExpr polynomialFunction2Expr(double[] coefficients, ISymbol sym) {
        if (coefficients[0] == 0.0 && coefficients.length == 1) {
            return F.C0;
        }
        IAST sum = F.Plus();
        sum.add(F.num(coefficients[0]));
        for (int i = 1; i < coefficients.length; ++i) {
            if (coefficients[i] == 0.0) continue;
            sum.add(F.Times((IExpr)F.num(coefficients[i]), (IExpr)F.Power((IExpr)sym, F.integer(i))));
        }
        return sum;
    }
}

