/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.convert;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apfloat.Apfloat;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.builtin.function.Blank;
import org.matheclipse.core.convert.ConversionException;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.exception.WrongArgumentType;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INumber;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.reflection.system.Complex;
import org.matheclipse.core.reflection.system.Pattern;
import org.matheclipse.core.reflection.system.Rational;
import org.matheclipse.parser.client.ast.ASTNode;
import org.matheclipse.parser.client.ast.FloatNode;
import org.matheclipse.parser.client.ast.FractionNode;
import org.matheclipse.parser.client.ast.FunctionNode;
import org.matheclipse.parser.client.ast.IntegerNode;
import org.matheclipse.parser.client.ast.Pattern2Node;
import org.matheclipse.parser.client.ast.Pattern3Node;
import org.matheclipse.parser.client.ast.PatternNode;
import org.matheclipse.parser.client.ast.StringNode;
import org.matheclipse.parser.client.ast.SymbolNode;

public class AST2Expr {
    public static final String[] UPPERCASE_SYMBOL_STRINGS = new String[]{"D", "E", "I", "N"};
    public static final String[] SYMBOL_STRINGS = new String[]{"ComplexInfinity", "Catalan", "Degree", "EulerGamma", "False", "Flat", "Glaisher", "GoldenRatio", "HoldAll", "HoldFirst", "HoldForm", "HoldRest", "Indeterminate", "Infinity", "Integer", "Khinchin", "Listable", "Modulus", "Null", "NumericFunction", "OneIdentity", "Orderless", "Pi", "Real", "Slot", "SlotSequence", "String", "Symbol", "True"};
    public static final String[] FUNCTION_STRINGS = new String[]{"DirectedInfinity", "Abs", "AddTo", "And", "Apart", "AppellF1", "Append", "AppendTo", "Apply", "ArcCos", "ArcCosh", "ArcCot", "ArcCoth", "ArcCsc", "ArcCsch", "ArcSec", "ArcSech", "ArcSin", "ArcSinh", "ArcTan", "ArcTanh", "Arg", "Array", "ArrayDepth", "ArrayQ", "AtomQ", "Attributes", "BernoulliB", "Binomial", "Blank", "Block", "Boole", "BooleanMinimize", "Break", "Cancel", "CartesianProduct", "Cases", "CatalanNumber", "Catch", "Ceiling", "CharacteristicPolynomial", "ChebyshevT", "ChessboardDistance", "Chop", "Clear", "ClearAll", "Coefficient", "CoefficientList", "Collect", "Complement", "Complex", "ComplexExpand", "ComplexInfinity", "ComposeList", "CompoundExpression", "Condition", "Conjugate", "ConjugateTranspose", "ConstantArray", "Continue", "ContinuedFraction", "CoprimeQ", "Cos", "Cosh", "CosIntegral", "CoshIntegral", "Cot", "Coth", "Count", "Cross", "Csc", "Csch", "Curl", "Decrement", "Default", "Defer", "Definition", "Delete", "DeleteCases", "DeleteDuplicates", "Denominator", "Depth", "Derivative", "Det", "DiagonalMatrix", "DigitQ", "Dimensions", "Discriminant", "Distribute", "Divergence", "DivideBy", "Divisible", "Divisors", "Do", "Dot", "Drop", "Eliminate", "EllipticE", "EllipticF", "EllipticPi", "Eigenvalues", "Eigenvectors", "Equal", "Erf", "Erfc", "Erfi", "EuclidianDistance", "EulerE", "EulerPhi", "EvenQ", "Exp", "Expand", "ExpandAll", "ExpIntegralE", "ExpIntegralEi", "Exponent", "ExtendedGCD", "Extract", "Factor", "Factorial", "Factorial2", "FactorInteger", "FactorSquareFree", "FactorSquareFreeList", "FactorTerms", "Flatten", "Fibonacci", "FindRoot", "First", "Fit", "FixedPoint", "Floor", "Fold", "FoldList", "For", "FractionalPart", "FreeQ", "FresnelC", "FresnelS", "FrobeniusSolve", "FromCharacterCode", "FromContinuedFraction", "FullForm", "FullSimplify", "Function", "Gamma", "GCD", "GeometricMean", "Graphics", "Graphics3D", "Graphics3D", "Greater", "GreaterEqual", "GroebnerBasis", "HarmonicNumber", "Head", "HermiteH", "HilbertMatrix", "Hold", "Horner", "HornerForm", "HypergeometricPFQ", "Hypergeometric2F1", "Identity", "IdentityMatrix", "If", "Im", "Increment", "Inner", "Insert", "IntegerPart", "IntegerPartitions", "IntegerQ", "Integrate", "InterpolatingFunction", "InterpolatingPolynomial", "Intersection", "Inverse", "InverseErf", "InverseFunction", "JacobiMatrix", "JacobiSymbol", "JavaForm", "Join", "KOrderlessPartitions", "KPartitions", "Last", "LCM", "LeafCount", "LaguerreL", "LegendreP", "Length", "Less", "LessEqual", "LetterQ", "Level", "Limit", "Line", "LinearProgramming", "LinearSolve", "List", "ListQ", "Log", "LogGamma", "LogIntegral", "LowerCaseQ", "LUDecomposition", "ManhattanDistance", "Map", "MapAll", "MapThread", "MatchQ", "MatrixForm", "MatrixPower", "MatrixQ", "MatrixRank", "Max", "Mean", "Median", "MemberQ", "Min", "Mod", "Module", "MoebiusMu", "MonomialList", "Most", "Multinomial", "Negative", "Nest", "NestList", "NestWhile", "NestWhileList", "NextPrime", "NFourierTransform", "NIntegrate", "NonCommutativeMultiply", "NonNegative", "Norm", "Not", "NRoots", "NSolve", "NullSpace", "NumberQ", "Numerator", "NumericQ", "OddQ", "Options", "Or", "Order", "OrderedQ", "Out", "Outer", "Package", "PadLeft", "PadRight", "ParametricPlot", "Part", "Partition", "Pattern", "Permutations", "Piecewise", "Plot", "Plot3D", "Plus", "Pochhammer", "PolyGamma", "PolyLog", "PolynomialExtendedGCD", "PolynomialGCD", "PolynomialLCM", "PolynomialQ", "PolynomialQuotient", "PolynomialQuotientRemainder", "PolynomialRemainder", "Position", "Positive", "PossibleZeroQ", "Power", "PowerExpand", "PowerMod", "PreDecrement", "PreIncrement", "Prepend", "PrependTo", "Prime", "PrimeQ", "PrimitiveRoots", "Print", "Product", "ProductLog", "Quiet", "Quotient", "RandomInteger", "RandomReal", "Range", "Rational", "Rationalize", "Re", "Reap", "ReplaceAll", "ReplacePart", "ReplaceRepeated", "Rest", "Resultant", "Return", "Reverse", "Riffle", "RootIntervals", "RootOf", "Roots", "RotateLeft", "RotateRight", "Round", "RowReduce", "Rule", "RuleDelayed", "SameQ", "Scan", "Sec", "Sech", "Select", "Sequence", "Set", "SetAttributes", "SetDelayed", "Show", "Sign", "SignCmp", "Simplify", "Sin", "Sinc", "SingularValueDecomposition", "Sinh", "SinIntegral", "SinhIntegral", "Solve", "Sort", "Sow", "Sqrt", "SquaredEuclidianDistance", "SquareFreeQ", "StirlingS2", "StringDrop", "StringJoin", "StringLength", "StringTake", "Subsets", "SubtractFrom", "Sum", "Switch", "SyntaxLength", "SyntaxQ", "Table", "Take", "Tan", "Tanh", "Taylor", "Thread", "Through", "Throw", "TimeConstrained", "Times", "TimesBy", "Timing", "ToCharacterCode", "Together", "ToString", "Total", "ToUnicode", "Tr", "Trace", "Transpose", "TrigExpand", "TrigReduce", "TrigToExp", "TrueQ", "Tuples", "Unequal", "Unevaluated", "Union", "Unique", "UnitStep", "UnitVector", "UnsameQ", "UpperCaseQ", "UpSet", "UpSetDelayed", "ValueQ", "VandermondeMatrix", "Variables", "VectorQ", "Which", "While", "Zeta"};
    public static Map<String, Integer> RUBI_STATISTICS_MAP;
    public static final Map<String, String> PREDEFINED_SYMBOLS_MAP;
    private static final String[] ALIASES_STRINGS;
    private static final IExpr[] ALIASES_SYMBOLS;
    public static final Map<String, IExpr> PREDEFINED_ALIASES_MAP;
    public static final String TIMES_STRING;
    public static final String TRUE_STRING;
    public static final AST2Expr CONST;
    public static final AST2Expr CONST_LC;
    private int fPrecision;
    private boolean fLowercaseEnabled;

    public AST2Expr(Class<ASTNode> sType, Class<IExpr> tType) {
        this(false);
    }

    public AST2Expr() {
        this(false);
    }

    public AST2Expr(boolean lowercaseEnabled) {
        this.fLowercaseEnabled = lowercaseEnabled;
    }

    public IAST convert(IAST ast, FunctionNode functionNode) throws ConversionException {
        ast.set(0, this.convert(functionNode.get(0)));
        for (int i = 1; i < functionNode.size(); ++i) {
            ast.add(this.convert(functionNode.get(i)));
        }
        return ast;
    }

    public IExpr convert(ASTNode node, EvalEngine engine) throws ConversionException {
        this.fPrecision = 15;
        if (engine != null) {
            this.fPrecision = engine.getNumericPrecision();
        }
        return this.convert(node);
    }

    public IExpr convert(ASTNode node) throws ConversionException {
        if (node == null) {
            return null;
        }
        if (node instanceof Pattern3Node) {
            throw new UnsupportedOperationException("'___' pattern-matching expression not implemented");
        }
        if (node instanceof FunctionNode) {
            FunctionNode functionNode = (FunctionNode)node;
            IAST ast = F.ast(this.convert(functionNode.get(0)), functionNode.size(), false);
            for (int i = 1; i < functionNode.size(); ++i) {
                ast.add(this.convert(functionNode.get(i)));
            }
            IExpr head = ast.head();
            if (ast.isAST(F.N, 3)) {
                try {
                    int precision = Validate.checkIntType(ast.arg2());
                    if (EvalEngine.isApfloat(precision)) {
                        this.fPrecision = precision;
                        ast.set(1, this.convert(functionNode.get(1)));
                    }
                    return ast;
                }
                catch (WrongArgumentType wat) {}
            } else {
                if (ast.isAST(F.Sqrt, 2)) {
                    return F.Power(ast.arg1(), F.C1D2);
                }
                if (ast.isAST(F.Exp, 2)) {
                    return F.Power((IExpr)F.E, ast.arg1());
                }
                if (ast.isPower() && ast.arg1().isPower() && ast.arg2().isMinusOne()) {
                    IAST arg1 = (IAST)ast.arg1();
                    if (arg1.arg2().isNumber()) {
                        return F.Power(arg1.arg1(), (IExpr)((INumber)arg1.arg2()).negate());
                    }
                } else {
                    IExpr expr;
                    if (ast.isASTSizeGE(F.GreaterEqual, 3)) {
                        ISymbol compareHead = F.Greater;
                        return this.rewriteLessGreaterAST(ast, compareHead);
                    }
                    if (ast.isASTSizeGE(F.Greater, 3)) {
                        ISymbol compareHead = F.GreaterEqual;
                        return this.rewriteLessGreaterAST(ast, compareHead);
                    }
                    if (ast.isASTSizeGE(F.LessEqual, 3)) {
                        ISymbol compareHead = F.Less;
                        return this.rewriteLessGreaterAST(ast, compareHead);
                    }
                    if (ast.isASTSizeGE(F.Less, 3)) {
                        ISymbol compareHead = F.LessEqual;
                        return this.rewriteLessGreaterAST(ast, compareHead);
                    }
                    if (head.equals(F.PatternHead)) {
                        IExpr expr2 = Pattern.CONST.evaluate(ast);
                        if (expr2 != null) {
                            return expr2;
                        }
                    } else if (head.equals(F.BlankHead)) {
                        IExpr expr3 = Blank.CONST.evaluate(ast);
                        if (expr3 != null) {
                            return expr3;
                        }
                    } else if (head.equals(F.Complex)) {
                        IExpr expr4 = Complex.CONST.evaluate(ast);
                        if (expr4 != null) {
                            return expr4;
                        }
                    } else if (head.equals(F.Rational) && (expr = Rational.CONST.evaluate(ast)) != null) {
                        return expr;
                    }
                }
            }
            return ast;
        }
        if (node instanceof SymbolNode) {
            String temp;
            String nodeStr = node.getString();
            if (Config.PARSER_USE_LOWERCASE_SYMBOLS) {
                if (nodeStr.length() == 1) {
                    if (nodeStr.equals("I")) {
                        return F.CI;
                    }
                    return F.$s(nodeStr);
                }
                if ((nodeStr = nodeStr.toLowerCase()).equals("infinity")) {
                    return F.CInfinity;
                }
                if (nodeStr.equals("complexinfinity")) {
                    return F.CComplexInfinity;
                }
                IExpr temp2 = PREDEFINED_ALIASES_MAP.get(nodeStr);
                if (temp2 != null) {
                    return temp2;
                }
                return F.$s(nodeStr);
            }
            if (this.fLowercaseEnabled && (temp = PREDEFINED_SYMBOLS_MAP.get(nodeStr = nodeStr.toLowerCase())) != null) {
                nodeStr = temp;
            }
            if (Config.RUBI_CONVERT_SYMBOLS) {
                Integer num = RUBI_STATISTICS_MAP.get(nodeStr);
                if (num == null) {
                    RUBI_STATISTICS_MAP.put(nodeStr, 1);
                } else {
                    RUBI_STATISTICS_MAP.put(nodeStr, num + 1);
                }
            }
            if (nodeStr.equals("I")) {
                return F.CI;
            }
            if (nodeStr.equals("Infinity")) {
                return F.CInfinity;
            }
            return F.$s(nodeStr);
        }
        if (node instanceof Pattern2Node) {
            Pattern2Node p2n = (Pattern2Node)node;
            return F.$ps((ISymbol)this.convert(p2n.getSymbol()), this.convert(p2n.getConstraint()), p2n.isDefault());
        }
        if (node instanceof PatternNode) {
            PatternNode pn = (PatternNode)node;
            return F.$p((ISymbol)this.convert(pn.getSymbol()), this.convert(pn.getConstraint()), pn.isDefault());
        }
        if (node instanceof IntegerNode) {
            IntegerNode integerNode = (IntegerNode)node;
            String iStr = integerNode.getString();
            if (iStr != null) {
                return F.integer(iStr, integerNode.getNumberFormat());
            }
            return F.integer(integerNode.getIntValue());
        }
        if (node instanceof FractionNode) {
            FractionNode fr = (FractionNode)node;
            IInteger numerator = (IInteger)this.convert(fr.getNumerator());
            IInteger denominator = (IInteger)this.convert(fr.getDenominator());
            if (denominator.isZero()) {
                return F.Rational(fr.isSign() ? numerator.negate() : numerator, denominator);
            }
            return F.fraction(numerator, fr.isSign() ? (IInteger)denominator.negate() : denominator);
        }
        if (node instanceof StringNode) {
            return F.stringx(node.getString());
        }
        if (node instanceof FloatNode) {
            if (EvalEngine.isApfloat(this.fPrecision)) {
                return F.num(new Apfloat(node.getString(), (long)this.fPrecision));
            }
            return F.num(Double.parseDouble(node.getString()));
        }
        return F.$s(node.toString());
    }

    private IExpr rewriteLessGreaterAST(IAST ast, ISymbol compareHead) {
        boolean evaled = false;
        IAST andAST = F.ast(F.And);
        for (int i = 1; i < ast.size(); ++i) {
            IExpr temp = (IExpr)ast.get(i);
            if (!temp.isASTSizeGE(compareHead, 3)) continue;
            IAST lt = (IAST)temp;
            andAST.add(lt);
            ast.set(i, lt.get(lt.size() - 1));
            evaled = true;
        }
        if (evaled) {
            andAST.add(ast);
            return andAST;
        }
        return ast;
    }

    static {
        PREDEFINED_SYMBOLS_MAP = new HashMap<String, String>(997);
        ALIASES_STRINGS = new String[]{"ACos", "ASin", "ATan", "ACosh", "ASinh", "ATanh", "ComplexInfinity", "Diff", "EvalF", "Infinity", "Int", "Trunc"};
        ALIASES_SYMBOLS = new IExpr[]{F.ArcCos, F.ArcSin, F.ArcTan, F.ArcCosh, F.ArcSinh, F.ArcTanh, F.CComplexInfinity, F.D, F.N, F.CInfinity, F.Integrate, F.IntegerPart};
        PREDEFINED_ALIASES_MAP = new HashMap<String, IExpr>(97);
        TIMES_STRING = Config.PARSER_USE_LOWERCASE_SYMBOLS ? "times" : "Times";
        TRUE_STRING = Config.PARSER_USE_LOWERCASE_SYMBOLS ? "true" : "True";
        for (String str : UPPERCASE_SYMBOL_STRINGS) {
            PREDEFINED_SYMBOLS_MAP.put(str, str);
        }
        for (String str : SYMBOL_STRINGS) {
            PREDEFINED_SYMBOLS_MAP.put(str.toLowerCase(), str);
        }
        for (String str : FUNCTION_STRINGS) {
            PREDEFINED_SYMBOLS_MAP.put(str.toLowerCase(), str);
        }
        if (Config.PARSER_USE_LOWERCASE_SYMBOLS) {
            for (int i = 0; i < ALIASES_STRINGS.length; ++i) {
                PREDEFINED_ALIASES_MAP.put(ALIASES_STRINGS[i].toLowerCase(), ALIASES_SYMBOLS[i]);
            }
        }
        if (Config.RUBI_CONVERT_SYMBOLS) {
            for (int i = 0; i < ALIASES_STRINGS.length; ++i) {
                PREDEFINED_SYMBOLS_MAP.put(ALIASES_STRINGS[i].toLowerCase(), ALIASES_STRINGS[i]);
            }
        }
        if (Config.RUBI_CONVERT_SYMBOLS) {
            RUBI_STATISTICS_MAP = new TreeMap<String, Integer>();
        }
        CONST = new AST2Expr();
        CONST_LC = new AST2Expr(true);
    }
}

