/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin.function;

import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.BreakException;
import org.matheclipse.core.eval.exception.ContinueException;
import org.matheclipse.core.eval.exception.IterationLimitExceeded;
import org.matheclipse.core.eval.exception.ReturnException;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractCoreFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;

public class While
extends AbstractCoreFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkRange(ast, 2, 3);
        EvalEngine engine = EvalEngine.get();
        int iterationLimit = engine.getIterationLimit();
        int iterationCounter = 1;
        IExpr test = ast.arg1();
        IExpr body = F.Null;
        if (ast.size() == 3) {
            body = ast.arg2();
        }
        while (engine.evaluate(test).isTrue()) {
            try {
                if (ast.size() == 3) {
                    engine.evaluate(body);
                }
                if (iterationLimit < 0 || iterationLimit > ++iterationCounter) continue;
                IterationLimitExceeded.throwIt(iterationCounter, ast);
            }
            catch (BreakException e) {
                return F.Null;
            }
            catch (ContinueException e) {
            }
            catch (ReturnException e) {
                return e.getValue();
            }
        }
        return F.Null;
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(96);
    }
}

