/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin.function;

import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.RuleCreationError;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractCoreFunctionEvaluator;
import org.matheclipse.core.eval.interfaces.ICreatePatternMatcher;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IPatternObject;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.patternmatching.PatternMatcher;

public class UpSetDelayed
extends AbstractCoreFunctionEvaluator
implements ICreatePatternMatcher {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkSize(ast, 3);
        IExpr leftHandSide = ast.arg1();
        IExpr rightHandSide = ast.arg2();
        this.createPatternMatcher(leftHandSide, rightHandSide, false);
        return F.Null;
    }

    @Override
    public Object[] createPatternMatcher(IExpr leftHandSide, IExpr rightHandSide, boolean packageMode) throws RuleCreationError {
        Object[] result = new Object[2];
        EvalEngine engine = EvalEngine.get();
        if (leftHandSide.isAST() && (((IAST)leftHandSide).getEvalFlags() & 0x300) == 0) {
            leftHandSide = PatternMatcher.evalLeftHandSide((IAST)leftHandSide, engine);
        }
        result[0] = null;
        result[1] = rightHandSide;
        IAST lhsAST = Validate.checkASTUpRuleType(leftHandSide);
        for (int i = 1; i < lhsAST.size(); ++i) {
            IExpr temp = (IExpr)lhsAST.get(i);
            if (temp instanceof IPatternObject) continue;
            ISymbol lhsSymbol = null;
            lhsSymbol = temp.isSymbol() ? (ISymbol)temp : ((IExpr)lhsAST.get(i)).topHead();
            result[0] = lhsSymbol.putUpRule(F.UpSetDelayed, false, lhsAST, rightHandSide);
        }
        return result;
    }

    @Override
    public IExpr numericEval(IAST functionList) {
        return this.evaluate(functionList);
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(96);
    }
}

