/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin.function;

import org.matheclipse.core.basic.Config;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.RuleCreationError;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractCoreFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;

public class SetAttributes
extends AbstractCoreFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkSize(ast, 3);
        if (ast.arg1().isSymbol()) {
            IExpr arg2 = F.eval(ast.arg2());
            ISymbol sym = (ISymbol)ast.arg1();
            if (!EvalEngine.get().isPackageMode() && Config.SERVER_MODE && sym.toString().charAt(0) != '$') {
                throw new RuleCreationError(sym);
            }
            if (arg2.isSymbol()) {
                ISymbol attribute = (ISymbol)arg2;
                if (attribute == F.Flat) {
                    sym.setAttributes(8);
                    return F.Null;
                }
                if (attribute == F.Listable) {
                    sym.setAttributes(128);
                    return F.Null;
                }
                if (attribute == F.OneIdentity) {
                    sym.setAttributes(1);
                    return F.Null;
                }
                if (attribute == F.Orderless) {
                    sym.setAttributes(4);
                    return F.Null;
                }
                if (attribute == F.HoldAll) {
                    sym.setAttributes(96);
                    return F.Null;
                }
                if (attribute == F.HoldFirst) {
                    sym.setAttributes(32);
                    return F.Null;
                }
                if (attribute == F.HoldRest) {
                    sym.setAttributes(64);
                    return F.Null;
                }
                if (attribute == F.NHoldAll) {
                    sym.setAttributes(24576);
                    return F.Null;
                }
                if (attribute == F.NHoldFirst) {
                    sym.setAttributes(8192);
                    return F.Null;
                }
                if (attribute == F.NHoldRest) {
                    sym.setAttributes(16384);
                    return F.Null;
                }
                if (attribute == F.NumericFunction) {
                    sym.setAttributes(1024);
                    return F.Null;
                }
            } else if (ast.arg2().isList()) {
                IAST lst = (IAST)ast.arg2();
                int symbolAttributes = 0;
                for (int i = 1; i < lst.size(); ++i) {
                    ISymbol attribute = (ISymbol)lst.get(i);
                    if (attribute == F.Flat) {
                        sym.setAttributes(symbolAttributes | 8);
                    }
                    if (attribute == F.Listable) {
                        sym.setAttributes(symbolAttributes | 0x80);
                    }
                    if (attribute == F.OneIdentity) {
                        sym.setAttributes(symbolAttributes | 1);
                    }
                    if (attribute == F.Orderless) {
                        sym.setAttributes(symbolAttributes | 4);
                    }
                    if (attribute == F.HoldAll) {
                        sym.setAttributes(symbolAttributes | 0x60);
                    }
                    if (attribute == F.HoldFirst) {
                        sym.setAttributes(symbolAttributes | 0x20);
                    }
                    if (attribute == F.HoldRest) {
                        sym.setAttributes(symbolAttributes | 0x40);
                    }
                    if (attribute == F.NHoldAll) {
                        sym.setAttributes(symbolAttributes | 0x6000);
                    }
                    if (attribute == F.NHoldFirst) {
                        sym.setAttributes(symbolAttributes | 0x2000);
                    }
                    if (attribute == F.NHoldRest) {
                        sym.setAttributes(symbolAttributes | 0x4000);
                    }
                    if (attribute == F.NumericFunction) {
                        sym.setAttributes(symbolAttributes | 0x400);
                    }
                    symbolAttributes = sym.getAttributes();
                }
                return F.Null;
            }
        }
        return null;
    }
}

