/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin.function;

import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ConditionException;
import org.matheclipse.core.eval.exception.ReturnException;
import org.matheclipse.core.eval.exception.RuleCreationError;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractCoreFunctionEvaluator;
import org.matheclipse.core.eval.interfaces.ICreatePatternMatcher;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.patternmatching.PatternMatcher;

public class Set
extends AbstractCoreFunctionEvaluator
implements ICreatePatternMatcher {
    public static final Set CONST = new Set();

    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkSize(ast, 3);
        IExpr leftHandSide = ast.arg1();
        IExpr rightHandSide = ast.arg2();
        if (leftHandSide.isList()) {
            try {
                rightHandSide = F.eval(rightHandSide);
            }
            catch (ReturnException e) {
                rightHandSide = e.getValue();
            }
            IAST temp = EvalEngine.threadASTListArgs(F.Set(leftHandSide, rightHandSide));
            if (temp != null) {
                return F.eval(temp);
            }
        }
        Object[] result = this.createPatternMatcher(leftHandSide, rightHandSide, EvalEngine.get().isPackageMode());
        return (IExpr)result[1];
    }

    @Override
    public Object[] createPatternMatcher(IExpr leftHandSide, IExpr rightHandSide, boolean packageMode) throws RuleCreationError {
        EvalEngine engine = EvalEngine.get();
        if (leftHandSide.isAST()) {
            leftHandSide = PatternMatcher.evalLeftHandSide((IAST)leftHandSide, engine);
        }
        try {
            rightHandSide = engine.evaluate(rightHandSide);
        }
        catch (ConditionException e) {
            System.out.println("Condition[] in right-hand-side of Set[]");
        }
        catch (ReturnException e) {
            rightHandSide = e.getValue();
        }
        return this.putDownRule(leftHandSide, rightHandSide, packageMode);
    }

    public Object[] putDownRule(IExpr leftHandSide, IExpr rightHandSide, boolean packageMode) {
        Object[] result = new Object[]{null, rightHandSide};
        if (leftHandSide.isAST()) {
            ISymbol lhsSymbol = ((IAST)leftHandSide).topHead();
            result[0] = lhsSymbol.putDownRule(F.Set, false, leftHandSide, rightHandSide, packageMode);
            return result;
        }
        if (leftHandSide.isSymbol()) {
            ISymbol lhsSymbol = (ISymbol)leftHandSide;
            if (lhsSymbol.hasLocalVariableStack()) {
                lhsSymbol.set(rightHandSide);
                return result;
            }
            result[0] = lhsSymbol.putDownRule(F.Set, true, leftHandSide, rightHandSide, packageMode);
            return result;
        }
        throw new RuleCreationError(leftHandSide);
    }

    @Override
    public IExpr numericEval(IAST functionList) {
        return this.evaluate(functionList);
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(96);
    }
}

