/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin.function;

import com.google.common.base.Predicate;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractCoreFunctionEvaluator;
import org.matheclipse.core.eval.util.LevelSpec;
import org.matheclipse.core.eval.util.LevelSpecification;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.generic.PositionConverter;
import org.matheclipse.core.generic.interfaces.IPositionConverter;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.patternmatching.PatternMatcher;

public class Position
extends AbstractCoreFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkRange(ast, 3, 4);
        IExpr arg1 = F.eval(ast.arg1());
        if (arg1.isAST()) {
            IExpr arg2 = F.eval(ast.arg2());
            if (ast.size() == 3) {
                LevelSpec level = new LevelSpec(0, Integer.MAX_VALUE);
                return Position.position((IAST)arg1, arg2, level);
            }
            if (ast.size() == 4) {
                IExpr arg3 = F.eval(ast.arg3());
                LevelSpecification level = new LevelSpecification(arg3, false);
                return Position.position((IAST)arg1, arg2, level);
            }
        }
        return null;
    }

    public static IAST position(IAST list, IAST prototypeList, IAST resultCollection, LevelSpec level, Predicate<? super IExpr> matcher, IPositionConverter<? extends IExpr> positionConverter, int headOffset) {
        int minDepth = 0;
        level.incCurrentLevel();
        IAST clone = null;
        int size = list.size();
        for (int i = headOffset; i < size; ++i) {
            if (matcher.apply((IExpr)list.get(i))) {
                if (!level.isInRange()) continue;
                clone = prototypeList.clone();
                IExpr IExpr2 = positionConverter.toObject(i);
                clone.add(IExpr2);
                resultCollection.add(clone);
                continue;
            }
            if (!((IExpr)list.get(i)).isAST()) continue;
            clone = prototypeList.clone();
            clone.add(positionConverter.toObject(i));
            Position.position((IAST)list.get(i), clone, resultCollection, level, matcher, positionConverter, headOffset);
            if (level.getCurrentDepth() >= minDepth) continue;
            minDepth = level.getCurrentDepth();
        }
        level.setCurrentDepth(--minDepth);
        level.decCurrentLevel();
        return resultCollection;
    }

    public static IAST position(IAST list, IExpr pattern, LevelSpec level) {
        PatternMatcher matcher = new PatternMatcher(pattern);
        PositionConverter pos = new PositionConverter();
        IAST cloneList = list.copyHead();
        IAST resultList = F.List();
        Position.position(list, cloneList, resultList, level, matcher, pos, 1);
        return resultList;
    }
}

