/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin.function;

import com.google.common.base.Predicate;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractCoreFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.INumber;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.parser.client.SyntaxError;

public class NumericQ
extends AbstractCoreFunctionEvaluator
implements Predicate<IExpr> {
    public static final NumericQ CONST = new NumericQ();

    @Override
    public boolean apply(IExpr arg) {
        return arg.isNumericFunction();
    }

    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkSize(ast, 2);
        IExpr arg1 = F.eval(ast.arg1());
        return F.bool(this.apply(arg1));
    }

    @Override
    public void setUp(ISymbol symbol) throws SyntaxError {
    }

    public static ISignedNumber getSignedNumberNumericQ(IExpr arg1) {
        IExpr result;
        if (arg1.isSignedNumber()) {
            return (ISignedNumber)arg1;
        }
        if (arg1.isNumber()) {
            return null;
        }
        if (arg1.isNumericFunction() && (result = F.evaln(arg1)).isSignedNumber()) {
            return (ISignedNumber)result;
        }
        return null;
    }

    public static INumber getNumberNumericQ(IExpr arg1) {
        IExpr result;
        if (arg1.isNumber()) {
            return (INumber)arg1;
        }
        if (arg1.isNumericFunction() && (result = F.evaln(arg1)).isNumber()) {
            return (INumber)result;
        }
        return null;
    }
}

