/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin.function;

import com.google.common.base.Function;
import java.util.Collection;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractCoreFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.generic.Functors;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;

public class NestList
extends AbstractCoreFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkSize(ast, 4);
        return NestList.evaluateNestList(ast, F.List());
    }

    public static IExpr evaluateNestList(IAST ast, IAST resultList) {
        IExpr arg3 = F.eval(ast.arg3());
        if (arg3.isInteger()) {
            int n = Validate.checkIntType(arg3);
            NestList.nestList(ast.arg2(), n, Functors.append(F.ast(ast.arg1())), resultList);
            return resultList;
        }
        return null;
    }

    public static void nestList(IExpr expr, int n, Function<IExpr, IExpr> fn, Collection<IExpr> resultList) {
        IExpr temp = expr;
        resultList.add(temp);
        for (int i = 0; i < n; ++i) {
            temp = F.eval(fn.apply(temp));
            resultList.add(temp);
        }
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(96);
    }
}

