/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin.function;

import com.google.common.base.Function;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractCoreFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.generic.Functors;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;

public class Nest
extends AbstractCoreFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkSize(ast, 4);
        return Nest.evaluateNest(ast);
    }

    public static IExpr evaluateNest(IAST ast) {
        IExpr arg3 = F.eval(ast.arg3());
        if (arg3.isInteger()) {
            int n = Validate.checkIntType(arg3);
            return Nest.nest(ast.arg2(), n, Functors.append(F.ast(ast.arg1())));
        }
        return null;
    }

    public static IExpr nest(IExpr expr, int n, Function<IExpr, IExpr> fn) {
        IExpr temp = expr;
        for (int i = 0; i < n; ++i) {
            temp = F.eval(fn.apply(temp));
        }
        return temp;
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(96);
    }
}

