/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin.function;

import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractCoreFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IComplex;
import org.matheclipse.core.interfaces.IComplexNum;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.visit.AbstractVisitorLong;

public class LeafCount
extends AbstractCoreFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkSize(ast, 2);
        return F.integer(F.eval(ast.arg1()).leafCount());
    }

    public static class LeafCountVisitor
    extends AbstractVisitorLong {
        int fHeadOffset;

        public LeafCountVisitor() {
            this(1);
        }

        public LeafCountVisitor(int hOffset) {
            this.fHeadOffset = hOffset;
        }

        @Override
        public long visit(IFraction element) {
            return 3L;
        }

        @Override
        public long visit(IComplex element) {
            return 3L;
        }

        @Override
        public long visit(IComplexNum element) {
            return 3L;
        }

        @Override
        public long visit(IAST list) {
            long sum = 0L;
            for (int i = this.fHeadOffset; i < list.size(); ++i) {
                sum += ((IExpr)list.get(i)).accept(this);
            }
            return sum;
        }
    }
}

