/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin.function;

import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.BreakException;
import org.matheclipse.core.eval.exception.ContinueException;
import org.matheclipse.core.eval.exception.IterationLimitExceeded;
import org.matheclipse.core.eval.exception.ReturnException;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractCoreFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;

public class For
extends AbstractCoreFunctionEvaluator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkRange(ast, 4, 5);
        EvalEngine engine = EvalEngine.get();
        int iterationLimit = engine.getIterationLimit();
        int iterationCounter = 1;
        engine.evaluate(ast.arg1());
        IExpr test = ast.arg2();
        IExpr incr = ast.arg3();
        IExpr body = F.Null;
        if (ast.size() == 5) {
            body = ast.arg4();
        }
        boolean exit = false;
        while (true) {
            try {
                if (!engine.evaluate(test).isTrue()) {
                    exit = true;
                    ISymbol iSymbol = F.Null;
                    return iSymbol;
                }
                if (ast.size() == 5) {
                    engine.evaluate(body);
                }
                if (iterationLimit < 0 || iterationLimit > ++iterationCounter) continue;
                IterationLimitExceeded.throwIt(iterationCounter, ast);
                continue;
            }
            catch (BreakException e) {
                exit = true;
                ISymbol iSymbol = F.Null;
                return iSymbol;
            }
            catch (ContinueException e) {
                if (iterationLimit < 0 || iterationLimit > ++iterationCounter) continue;
                IterationLimitExceeded.throwIt(iterationCounter, ast);
                continue;
            }
            catch (ReturnException e) {
                IExpr iExpr = e.getValue();
                return iExpr;
            }
            finally {
                if (exit) continue;
                engine.evaluate(incr);
                continue;
            }
            break;
        }
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(96);
    }
}

