/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin.function;

import java.util.ArrayList;
import java.util.List;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.BreakException;
import org.matheclipse.core.eval.exception.ContinueException;
import org.matheclipse.core.eval.exception.NoEvalException;
import org.matheclipse.core.eval.exception.ReturnException;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractCoreFunctionEvaluator;
import org.matheclipse.core.eval.util.Iterator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.generic.interfaces.IIterator;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;

public class Do
extends AbstractCoreFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkRange(ast, 3);
        try {
            EvalEngine engine = EvalEngine.get();
            ArrayList<Iterator> iterList = new ArrayList<Iterator>();
            for (int i = 2; i < ast.size(); ++i) {
                iterList.add(new Iterator((IAST)ast.get(i), engine));
            }
            DoIterator generator = new DoIterator(iterList);
            return generator.doIt(ast.arg1());
        }
        catch (ClassCastException e) {
        }
        catch (NoEvalException noEvalException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(96);
    }

    public static class DoIterator {
        final List<? extends IIterator<IExpr>> fIterList;
        int fIndex;

        public DoIterator(List<? extends IIterator<IExpr>> iterList) {
            this.fIterList = iterList;
            this.fIndex = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public IExpr doIt(IExpr input) {
            if (this.fIndex >= this.fIterList.size()) return null;
            IIterator<IExpr> iter = this.fIterList.get(this.fIndex);
            if (!iter.setUp()) return F.Null;
            try {
                ++this.fIndex;
                while (iter.hasNext()) {
                    try {
                        iter.next();
                        F.eval(input);
                    }
                    catch (ReturnException e) {
                        IExpr iExpr = e.getValue();
                        --this.fIndex;
                        iter.tearDown();
                        return iExpr;
                    }
                    catch (BreakException e) {
                        ISymbol iSymbol = F.Null;
                        --this.fIndex;
                        iter.tearDown();
                        return iSymbol;
                    }
                    catch (ContinueException e) {
                        continue;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                                return F.Null;
                            }
                        }
                    }
                }
            }
            finally {
                --this.fIndex;
                iter.tearDown();
            }
        }
    }
}

