/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin.function;

import com.google.common.base.Function;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractCoreFunctionEvaluator;
import org.matheclipse.core.generic.Functors;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.patternmatching.PatternMatcher;

public class DeleteCases
extends AbstractCoreFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkRange(ast, 3, 4);
        EvalEngine engine = EvalEngine.get();
        IExpr arg1 = engine.evaluate(ast.arg1());
        if (arg1.isAST()) {
            if (ast.size() == 4) {
                Validate.checkSize(ast, 3);
            } else {
                return DeleteCases.deleteCases((IAST)ast.arg1(), ast.arg2());
            }
        }
        return null;
    }

    public static IAST deleteCases(IAST ast, IExpr pattern) {
        if (pattern.isRuleAST()) {
            Function<IExpr, IExpr> function = Functors.rules((IAST)pattern);
            IAST[] results = ast.filter(function);
            return results[1];
        }
        PatternMatcher matcher = new PatternMatcher(pattern);
        IAST[] results = ast.filter(matcher);
        return results[1];
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(96);
    }

    private static class CasesRulesFunctor
    implements Function<IExpr, IExpr> {
        protected final Function<IExpr, IExpr> function;
        protected IAST resultCollection;

        public CasesRulesFunctor(Function<IExpr, IExpr> function, IAST resultCollection) {
            this.function = function;
            this.resultCollection = resultCollection;
        }

        @Override
        public IExpr apply(IExpr arg) {
            if (arg.isAST()) {
                IAST ast = (IAST)arg;
                IAST[] results = ast.filter(this.function);
                this.resultCollection.addAll(results[1]);
            }
            return null;
        }
    }

    private static class CasesPatternMatcherFunctor
    implements Function<IExpr, IExpr> {
        protected final PatternMatcher matcher;
        protected IAST resultCollection;

        public CasesPatternMatcherFunctor(PatternMatcher matcher, IAST resultCollection) {
            this.matcher = matcher;
            this.resultCollection = resultCollection;
        }

        @Override
        public IExpr apply(IExpr arg) {
            if (arg.isAST()) {
                IAST ast = (IAST)arg;
                IAST[] results = ast.filter(this.matcher);
                this.resultCollection.addAll(results[1]);
            }
            return null;
        }
    }
}

