/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin.function;

import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractCoreFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;

public class Attributes
extends AbstractCoreFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkSize(ast, 2);
        if (ast.arg1().isSymbol()) {
            IAST result = F.List();
            ISymbol sym = (ISymbol)ast.arg1();
            int attributea = sym.getAttributes();
            if ((attributea & 8) != 0) {
                result.add(F.Flat);
            }
            if ((attributea & 0x80) != 0) {
                result.add(F.Listable);
            }
            if ((attributea & 1) != 0) {
                result.add(F.OneIdentity);
            }
            if ((attributea & 4) != 0) {
                result.add(F.Orderless);
            }
            if ((attributea & 0x60) != 0) {
                result.add(F.HoldAll);
            }
            if ((attributea & 0x20) != 0) {
                result.add(F.HoldFirst);
            }
            if ((attributea & 0x40) != 0) {
                result.add(F.HoldRest);
            }
            if ((attributea & 0x6000) != 0) {
                result.add(F.NHoldAll);
            }
            if ((attributea & 0x2000) != 0) {
                result.add(F.NHoldFirst);
            }
            if ((attributea & 0x4000) != 0) {
                result.add(F.NHoldRest);
            }
            if ((attributea & 0x400) != 0) {
                result.add(F.NumericFunction);
            }
            return result;
        }
        return null;
    }
}

