/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin.function;

import java.util.ArrayList;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractCoreFunctionEvaluator;
import org.matheclipse.core.eval.util.TableGenerator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.generic.MultipleArrayFunction;
import org.matheclipse.core.generic.interfaces.IIterator;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;

public class Array
extends AbstractCoreFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        return Array.evaluateArray(ast, F.List());
    }

    public static IExpr evaluateArray(IAST ast, IAST resultList) {
        block15: {
            try {
                IAST dimIter;
                if (ast.size() < 3 || ast.size() > 5) break block15;
                EvalEngine engine = EvalEngine.get();
                ArrayList<ArrayIterator> iterList = new ArrayList<ArrayIterator>();
                if (ast.size() == 3 && ast.arg2().isInteger()) {
                    int indx1 = Validate.checkIntType(ast, 2);
                    iterList.add(new ArrayIterator(indx1));
                } else if (ast.size() == 3 && ast.arg2().isList()) {
                    dimIter = (IAST)ast.arg2();
                    for (int i = 1; i < dimIter.size(); ++i) {
                        int indx1 = Validate.checkIntType(dimIter, i);
                        iterList.add(new ArrayIterator(indx1));
                    }
                } else if (ast.size() >= 4) {
                    if (ast.arg2().isInteger() && ast.arg3().isInteger()) {
                        int indx1 = Validate.checkIntType(ast, 3);
                        int indx2 = Validate.checkIntType(ast, 2);
                        iterList.add(new ArrayIterator(indx1, indx2));
                    } else if (ast.arg2().isList() && ast.arg3().isList()) {
                        dimIter = (IAST)ast.arg2();
                        IAST originIter = (IAST)ast.arg3();
                        for (int i = 1; i < dimIter.size(); ++i) {
                            int indx1 = Validate.checkIntType(originIter, i);
                            int indx2 = Validate.checkIntType(dimIter, i);
                            iterList.add(new ArrayIterator(indx1, indx2));
                        }
                    }
                }
                if (iterList.size() > 0) {
                    if (ast.size() == 5) {
                        resultList = F.ast(ast.arg4());
                    }
                    IAST list = F.ast(ast.arg1());
                    TableGenerator generator = new TableGenerator(iterList, resultList, new MultipleArrayFunction(engine, list));
                    return generator.table();
                }
            }
            catch (ClassCastException e) {
            }
            catch (ArithmeticException arithmeticException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(96);
    }

    public static class ArrayIterator
    implements IIterator<IExpr> {
        int fCurrent;
        final int fFrom;
        final int fTo;

        public ArrayIterator(int to) {
            this(1, to);
        }

        public ArrayIterator(int from, int length) {
            this.fFrom = from;
            this.fCurrent = from;
            this.fTo = from + length - 1;
        }

        @Override
        public boolean setUp() {
            return true;
        }

        @Override
        public void tearDown() {
            this.fCurrent = this.fFrom;
        }

        @Override
        public boolean hasNext() {
            return this.fCurrent <= this.fTo;
        }

        @Override
        public IExpr next() {
            return F.integer(this.fCurrent++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

