/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.boole;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.matheclipse.core.boole.QuineMcCluskyTerm;
import org.matheclipse.core.convert.ExprVariables;
import org.matheclipse.core.eval.exception.BooleanFunctionConversionException;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;

public class QuineMcCluskyFormula {
    private List<QuineMcCluskyTerm> termList;
    private List<QuineMcCluskyTerm> originalTermList;
    private final IAST variables;

    public QuineMcCluskyFormula(List<QuineMcCluskyTerm> termList, IAST variables) {
        this.termList = termList;
        this.variables = variables;
    }

    public String toString() {
        String result = "";
        result = result + this.termList.size() + " terms, " + this.termList.get(0).getNumVars() + " variables\n";
        for (int i = 0; i < this.termList.size(); ++i) {
            result = result + this.termList.get(i) + "\n";
        }
        return result;
    }

    public IExpr toExpr() throws BooleanFunctionConversionException {
        IAST result = F.ast(F.Or);
        for (int i = 0; i < this.termList.size(); ++i) {
            result.add(this.termList.get(i).toExpr(this.variables));
        }
        if (result.size() == 1) {
            return F.True;
        }
        if (result.size() == 2) {
            return (IExpr)result.get(1);
        }
        return result;
    }

    public void reduceToPrimeImplicants() {
        int ones;
        int dontKnows;
        this.originalTermList = new ArrayList<QuineMcCluskyTerm>(this.termList);
        int numVars = this.termList.get(0).getNumVars();
        ArrayList[][] table = new ArrayList[numVars + 1][numVars + 1];
        for (dontKnows = 0; dontKnows <= numVars; ++dontKnows) {
            for (ones = 0; ones <= numVars; ++ones) {
                table[dontKnows][ones] = new ArrayList();
            }
        }
        for (int i = 0; i < this.termList.size(); ++i) {
            int dontCares = this.termList.get(i).countValues((byte)2);
            int ones2 = this.termList.get(i).countValues((byte)1);
            table[dontCares][ones2].add(this.termList.get(i));
        }
        for (dontKnows = 0; dontKnows <= numVars - 1; ++dontKnows) {
            for (ones = 0; ones <= numVars - 1; ++ones) {
                ArrayList left = table[dontKnows][ones];
                ArrayList right = table[dontKnows][ones + 1];
                ArrayList out = table[dontKnows + 1][ones];
                for (int leftIdx = 0; leftIdx < left.size(); ++leftIdx) {
                    for (int rightIdx = 0; rightIdx < right.size(); ++rightIdx) {
                        QuineMcCluskyTerm combined = ((QuineMcCluskyTerm)left.get(leftIdx)).combine((QuineMcCluskyTerm)right.get(rightIdx));
                        if (combined == null) continue;
                        if (!out.contains(combined)) {
                            out.add(combined);
                        }
                        this.termList.remove(left.get(leftIdx));
                        this.termList.remove(right.get(rightIdx));
                        if (this.termList.contains(combined)) continue;
                        this.termList.add(combined);
                    }
                }
            }
        }
    }

    public void reducePrimeImplicantsToSubset() {
        int numPrimeImplicants = this.termList.size();
        int numOriginalTerms = this.originalTermList.size();
        boolean[][] table = new boolean[numPrimeImplicants][numOriginalTerms];
        for (int impl = 0; impl < numPrimeImplicants; ++impl) {
            for (int term = 0; term < numOriginalTerms; ++term) {
                table[impl][term] = this.termList.get(impl).implies(this.originalTermList.get(term));
            }
        }
        ArrayList<QuineMcCluskyTerm> newTermList = new ArrayList<QuineMcCluskyTerm>();
        boolean done = false;
        while (!done) {
            int impl = this.extractEssentialImplicant(table);
            if (impl != -1) {
                newTermList.add(this.termList.get(impl));
                continue;
            }
            impl = this.extractLargestImplicant(table);
            if (impl != -1) {
                newTermList.add(this.termList.get(impl));
                continue;
            }
            done = true;
        }
        this.termList = newTermList;
        this.originalTermList = null;
    }

    public static QuineMcCluskyFormula read(Reader reader) throws IOException {
        QuineMcCluskyTerm term;
        ArrayList<QuineMcCluskyTerm> terms = new ArrayList<QuineMcCluskyTerm>();
        while ((term = QuineMcCluskyTerm.read(reader)) != null) {
            terms.add(term);
        }
        return new QuineMcCluskyFormula(terms, null);
    }

    public static QuineMcCluskyFormula read(String str) {
        ArrayList<QuineMcCluskyTerm> terms = QuineMcCluskyTerm.read(str);
        return new QuineMcCluskyFormula(terms, null);
    }

    public static QuineMcCluskyFormula read(IAST orAST) throws BooleanFunctionConversionException {
        ExprVariables exVar = new ExprVariables(orAST);
        IAST vars = exVar.getVarList();
        if (vars.size() == 1) {
            throw new BooleanFunctionConversionException();
        }
        ArrayList<QuineMcCluskyTerm> terms = QuineMcCluskyTerm.convertToTerms(orAST, vars);
        return new QuineMcCluskyFormula(terms, vars);
    }

    private int extractEssentialImplicant(boolean[][] table) {
        for (int term = 0; term < table[0].length; ++term) {
            int lastImplFound = -1;
            for (int impl = 0; impl < table.length; ++impl) {
                if (!table[impl][term]) continue;
                if (lastImplFound == -1) {
                    lastImplFound = impl;
                    continue;
                }
                lastImplFound = -1;
                break;
            }
            if (lastImplFound == -1) continue;
            this.extractImplicant(table, lastImplFound);
            return lastImplFound;
        }
        return -1;
    }

    private void extractImplicant(boolean[][] table, int impl) {
        for (int term = 0; term < table[0].length; ++term) {
            if (!table[impl][term]) continue;
            for (int impl2 = 0; impl2 < table.length; ++impl2) {
                table[impl2][term] = false;
            }
        }
    }

    private int extractLargestImplicant(boolean[][] table) {
        int maxNumTerms = 0;
        int maxNumTermsImpl = -1;
        for (int impl = 0; impl < table.length; ++impl) {
            int numTerms = 0;
            for (int term = 0; term < table[0].length; ++term) {
                if (!table[impl][term]) continue;
                ++numTerms;
            }
            if (numTerms <= maxNumTerms) continue;
            maxNumTerms = numTerms;
            maxNumTermsImpl = impl;
        }
        if (maxNumTermsImpl != -1) {
            this.extractImplicant(table, maxNumTermsImpl);
            return maxNumTermsImpl;
        }
        return -1;
    }
}

