/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.combinatoric;

import org.matheclipse.combinatoric.IStepVisitor;
import org.matheclipse.combinatoric.RosenNumberPartitionIterator;

public class NumberPartitionsIterator {
    private final int n;
    private final int[][] result;
    private RosenNumberPartitionIterator rosen;
    private IStepVisitor handler;

    public NumberPartitionsIterator(IStepVisitor visitor, int n, int k) {
        this.n = n;
        this.result = new int[k][];
        this.rosen = new RosenNumberPartitionIterator(n, k);
        this.handler = visitor;
    }

    public void reset() {
        this.rosen.reset();
        for (int i = 0; i < this.result.length; ++i) {
            this.result[i] = null;
        }
    }

    public boolean execute() {
        while (this.rosen.hasNext()) {
            int counter = 0;
            int[] currentRosen = this.rosen.next();
            for (int i = 0; i < currentRosen.length; ++i) {
                this.result[i] = new int[currentRosen[i]];
                for (int j = 0; j < currentRosen[i]; ++j) {
                    this.result[i][j] = counter++;
                }
            }
            if (this.handler.visit(this.result)) continue;
            return false;
        }
        return true;
    }
}

