/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.combinatoric;

import org.matheclipse.combinatoric.IStepVisitor;
import org.matheclipse.combinatoric.MultisetCombinationIterator;
import org.matheclipse.combinatoric.RosenNumberPartitionIterator;
import org.matheclipse.combinatoric.StopException;
import org.matheclipse.combinatoric.util.ArrayUtils;

public class MultisetPartitionsIterator {
    private final int n;
    private final int[] multiset;
    private final int[][] result;
    private RosenNumberPartitionIterator rosen;
    private IStepVisitor handler;

    public MultisetPartitionsIterator(IStepVisitor visitor, int k) {
        int[] mset = visitor.getMultisetArray();
        this.n = mset.length;
        this.multiset = mset;
        this.result = new int[k][];
        this.rosen = new RosenNumberPartitionIterator(this.n, k);
        this.handler = visitor;
    }

    public void reset() {
        this.rosen.reset();
        for (int i = 0; i < this.result.length; ++i) {
            this.result[i] = null;
        }
    }

    public boolean execute() {
        try {
            while (this.rosen.hasNext()) {
                this.recursiveMultisetCombination(this.multiset, this.rosen.next(), 0);
            }
        }
        catch (StopException e) {
            return false;
        }
        return true;
    }

    private void recursiveMultisetCombination(int[] multiset, int[] currentRosen, int i) throws StopException {
        if (i < currentRosen.length) {
            MultisetCombinationIterator iter = new MultisetCombinationIterator(multiset, currentRosen[i]);
            while (iter.hasNext()) {
                int[] currentSubset = iter.next();
                this.result[i] = currentSubset;
                int[] wc = ArrayUtils.deleteSubset(multiset, currentSubset);
                this.recursiveMultisetCombination(wc, currentRosen, i + 1);
            }
        } else if (!this.handler.visit(this.result)) {
            throw new StopException();
        }
    }
}

