/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.combinatoric;

import java.util.Iterator;
import org.matheclipse.combinatoric.IStepVisitor;

public class KPermutationsIterator
implements Iterator<int[]>,
Iterable<int[]> {
    private final int n;
    private final int k;
    private final int[] fPermutationsIndex;
    private final int[] y;
    private boolean first;
    private int h;
    private int i;
    private int m;
    private final int[] fCopiedResultIndex;
    private int[] fResultIndex;
    final IStepVisitor fHandler;

    public KPermutationsIterator(IStepVisitor handler, int parts) {
        this.fHandler = handler;
        int[] data = handler.getMultisetArray();
        this.n = data.length;
        this.k = parts;
        this.fPermutationsIndex = new int[this.n];
        this.y = new int[this.n];
        this.fCopiedResultIndex = new int[this.k];
        for (int a = 0; a < this.n; ++a) {
            this.fPermutationsIndex[a] = data[a];
            this.y[a] = a;
        }
        this.m = this.k == this.n ? this.k - 1 : this.k;
        this.first = true;
        this.i = this.m - 1;
        this.fResultIndex = this.nextBeforehand();
    }

    private final int[] nextBeforehand() {
        if (this.first) {
            this.first = false;
            return this.fPermutationsIndex;
        }
        do {
            if (this.y[this.i] < this.n - 1) {
                this.y[this.i] = this.y[this.i] + 1;
                if (this.fPermutationsIndex[this.i] == this.fPermutationsIndex[this.y[this.i]]) continue;
                this.h = this.fPermutationsIndex[this.i];
                this.fPermutationsIndex[this.i] = this.fPermutationsIndex[this.y[this.i]];
                this.fPermutationsIndex[this.y[this.i]] = this.h;
                this.i = this.m - 1;
                return this.fPermutationsIndex;
            }
            do {
                this.h = this.fPermutationsIndex[this.i];
                this.fPermutationsIndex[this.i] = this.fPermutationsIndex[this.y[this.i]];
                this.fPermutationsIndex[this.y[this.i]] = this.h;
                this.y[this.i] = this.y[this.i] - 1;
            } while (this.y[this.i] > this.i);
            --this.i;
        } while (this.i != -1);
        return null;
    }

    @Override
    public int[] next() {
        System.arraycopy(this.fResultIndex, 0, this.fCopiedResultIndex, 0, this.k);
        this.fResultIndex = this.nextBeforehand();
        return this.fCopiedResultIndex;
    }

    @Override
    public boolean hasNext() {
        return this.fResultIndex != null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<int[]> iterator() {
        return this;
    }

    public boolean execute() {
        while (this.hasNext()) {
            int[] current = this.next();
            if (this.fHandler.visit(current)) continue;
            return false;
        }
        return true;
    }
}

