/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optim;

import org.apache.commons.math3.exception.TooManyEvaluationsException;
import org.apache.commons.math3.exception.TooManyIterationsException;
import org.apache.commons.math3.fitting.leastsquares.WithConvergenceChecker;
import org.apache.commons.math3.fitting.leastsquares.WithMaxEvaluations;
import org.apache.commons.math3.fitting.leastsquares.WithMaxIterations;
import org.apache.commons.math3.optim.ConvergenceChecker;
import org.apache.commons.math3.util.Incrementor;

public abstract class AbstractOptimizer<PAIR, OPTIM extends AbstractOptimizer<PAIR, OPTIM>>
implements WithMaxEvaluations<OPTIM>,
WithMaxIterations<OPTIM>,
WithConvergenceChecker<PAIR, OPTIM> {
    private Incrementor evaluations = new Incrementor(Integer.MAX_VALUE, new MaxEvalCallback());
    private Incrementor iterations = new Incrementor(Integer.MAX_VALUE, new MaxIterCallback());
    private ConvergenceChecker<PAIR> checker = null;

    protected AbstractOptimizer() {
    }

    protected AbstractOptimizer(AbstractOptimizer<PAIR, OPTIM> other) {
        this.checker = other.checker;
        this.evaluations.setMaximalCount(other.getMaxEvaluations());
        this.iterations.setMaximalCount(other.getMaxIterations());
    }

    protected OPTIM self() {
        AbstractOptimizer optim = this;
        return (OPTIM)optim;
    }

    @Override
    public OPTIM withConvergenceChecker(ConvergenceChecker<PAIR> newChecker) {
        this.checker = newChecker;
        return this.self();
    }

    @Override
    public OPTIM withMaxEvaluations(int max) {
        this.evaluations.setMaximalCount(max);
        return this.self();
    }

    @Override
    public OPTIM withMaxIterations(int max) {
        this.iterations.setMaximalCount(max);
        return this.self();
    }

    public int getMaxEvaluations() {
        return this.evaluations.getMaximalCount();
    }

    public int getEvaluations() {
        return this.evaluations.getCount();
    }

    public int getMaxIterations() {
        return this.iterations.getMaximalCount();
    }

    public int getIterations() {
        return this.iterations.getCount();
    }

    public ConvergenceChecker<PAIR> getConvergenceChecker() {
        return this.checker;
    }

    public PAIR optimize() throws TooManyEvaluationsException, TooManyIterationsException {
        this.evaluations.resetCount();
        this.iterations.resetCount();
        return this.doOptimize();
    }

    public abstract OPTIM shallowCopy();

    protected abstract PAIR doOptimize();

    protected void incrementEvaluationCount() throws TooManyEvaluationsException {
        this.evaluations.incrementCount();
    }

    protected void incrementIterationCount() throws TooManyIterationsException {
        this.iterations.incrementCount();
    }

    private static class MaxIterCallback
    implements Incrementor.MaxCountExceededCallback {
        private MaxIterCallback() {
        }

        @Override
        public void trigger(int max) {
            throw new TooManyIterationsException(max);
        }
    }

    private static class MaxEvalCallback
    implements Incrementor.MaxCountExceededCallback {
        private MaxEvalCallback() {
        }

        @Override
        public void trigger(int max) {
            throw new TooManyEvaluationsException(max);
        }
    }
}

