/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.fitting.leastsquares;

import org.apache.commons.math3.analysis.MultivariateMatrixFunction;
import org.apache.commons.math3.analysis.MultivariateVectorFunction;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.fitting.leastsquares.WithModelAndJacobian;
import org.apache.commons.math3.fitting.leastsquares.WithStartPoint;
import org.apache.commons.math3.fitting.leastsquares.WithTarget;
import org.apache.commons.math3.fitting.leastsquares.WithWeight;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.DecompositionSolver;
import org.apache.commons.math3.linear.DiagonalMatrix;
import org.apache.commons.math3.linear.EigenDecomposition;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.QRDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.optim.AbstractOptimizer;
import org.apache.commons.math3.optim.PointVectorValuePair;
import org.apache.commons.math3.util.FastMath;

public abstract class AbstractLeastSquaresOptimizer<OPTIM extends AbstractLeastSquaresOptimizer<OPTIM>>
extends AbstractOptimizer<PointVectorValuePair, OPTIM>
implements WithTarget<OPTIM>,
WithWeight<OPTIM>,
WithModelAndJacobian<OPTIM>,
WithStartPoint<OPTIM> {
    private double[] target;
    private RealMatrix weight;
    private MultivariateVectorFunction model;
    private MultivariateMatrixFunction jacobian;
    private RealMatrix weightSqrt;
    private double[] start;

    protected AbstractLeastSquaresOptimizer() {
    }

    protected AbstractLeastSquaresOptimizer(AbstractLeastSquaresOptimizer<OPTIM> other) {
        super(other);
        this.target = other.target == null ? null : (double[])other.target.clone();
        this.start = other.start == null ? null : (double[])other.start.clone();
        this.weight = other.weight == null ? null : other.weight.copy();
        this.weightSqrt = other.weightSqrt == null ? null : other.weightSqrt.copy();
        this.model = other.model;
        this.jacobian = other.jacobian;
    }

    @Override
    public OPTIM withTarget(double[] newTarget) {
        this.target = (double[])newTarget.clone();
        return (OPTIM)((AbstractLeastSquaresOptimizer)this.self());
    }

    @Override
    public OPTIM withWeight(RealMatrix newWeight) {
        this.weight = newWeight;
        this.weightSqrt = this.squareRoot(newWeight);
        return (OPTIM)((AbstractLeastSquaresOptimizer)this.self());
    }

    @Override
    public OPTIM withModelAndJacobian(MultivariateVectorFunction newModel, MultivariateMatrixFunction newJacobian) {
        this.model = newModel;
        this.jacobian = newJacobian;
        return (OPTIM)((AbstractLeastSquaresOptimizer)this.self());
    }

    @Override
    public OPTIM withStartPoint(double[] newStart) {
        this.start = (double[])newStart.clone();
        return (OPTIM)((AbstractLeastSquaresOptimizer)this.self());
    }

    public double[] getTarget() {
        return this.target == null ? null : (double[])this.target.clone();
    }

    public double[] getStart() {
        return this.start == null ? null : (double[])this.start.clone();
    }

    public RealMatrix getWeightSquareRoot() {
        return this.weightSqrt == null ? null : this.weightSqrt.copy();
    }

    public MultivariateVectorFunction getModel() {
        return this.model;
    }

    public MultivariateMatrixFunction getJacobian() {
        return this.jacobian;
    }

    public double[][] computeCovariances(double[] params, double threshold) {
        RealMatrix j = this.computeWeightedJacobian(params);
        RealMatrix jTj = j.transpose().multiply(j);
        DecompositionSolver solver = new QRDecomposition(jTj, threshold).getSolver();
        return solver.getInverse().getData();
    }

    public double[] computeSigma(double[] params, double covarianceSingularityThreshold) {
        int nC = params.length;
        double[] sig = new double[nC];
        double[][] cov = this.computeCovariances(params, covarianceSingularityThreshold);
        for (int i = 0; i < nC; ++i) {
            sig[i] = FastMath.sqrt(cov[i][i]);
        }
        return sig;
    }

    public RealMatrix getWeight() {
        return this.weight.copy();
    }

    public double computeRMS(double[] params) {
        double cost = this.computeCost(this.computeResiduals(this.getModel().value(params)));
        return FastMath.sqrt(cost * cost / (double)this.target.length);
    }

    protected double[] computeObjectiveValue(double[] params) {
        super.incrementEvaluationCount();
        return this.model.value(params);
    }

    protected RealMatrix computeWeightedJacobian(double[] params) {
        return this.weightSqrt.multiply(MatrixUtils.createRealMatrix(this.computeJacobian(params)));
    }

    protected double[][] computeJacobian(double[] params) {
        return this.jacobian.value(params);
    }

    protected double computeCost(double[] residuals) {
        ArrayRealVector r = new ArrayRealVector(residuals);
        return FastMath.sqrt(r.dotProduct(this.weight.operate(r)));
    }

    protected double[] computeResiduals(double[] objectiveValue) {
        if (objectiveValue.length != this.target.length) {
            throw new DimensionMismatchException(this.target.length, objectiveValue.length);
        }
        double[] residuals = new double[this.target.length];
        for (int i = 0; i < this.target.length; ++i) {
            residuals[i] = this.target[i] - objectiveValue[i];
        }
        return residuals;
    }

    private RealMatrix squareRoot(RealMatrix m) {
        if (m instanceof DiagonalMatrix) {
            int dim = m.getRowDimension();
            DiagonalMatrix sqrtM = new DiagonalMatrix(dim);
            for (int i = 0; i < dim; ++i) {
                sqrtM.setEntry(i, i, FastMath.sqrt(m.getEntry(i, i)));
            }
            return sqrtM;
        }
        EigenDecomposition dec = new EigenDecomposition(m);
        return dec.getSquareRoot();
    }
}

