/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.util;

import edu.jas.util.LongIterable;
import edu.jas.util.LongIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

class CartesianProductLongIterator
implements Iterator<List<Long>> {
    final List<LongIterable> comps;
    final List<LongIterator> compit;
    List<Long> current;
    boolean empty;
    public final long upperBound;

    public CartesianProductLongIterator(List<LongIterable> comps, long ub) {
        if (comps == null) {
            throw new IllegalArgumentException("null comps not allowed");
        }
        this.comps = comps;
        this.upperBound = ub;
        this.current = new ArrayList<Long>(comps.size());
        this.compit = new ArrayList<LongIterator>(comps.size());
        this.empty = false;
        for (LongIterable ci : comps) {
            LongIterator it = (LongIterator)ci.iterator();
            if (it.getUpperBound() < this.upperBound) {
                throw new IllegalArgumentException("each iterator (" + it.getUpperBound() + ") must be able to reach total upper bound " + this.upperBound);
            }
            if (!it.hasNext()) {
                this.empty = true;
                this.current.clear();
                return;
            }
            this.current.add(it.next());
            this.compit.add(it);
        }
        LongIterator it = this.compit.get(this.compit.size() - 1);
        long d = -1L;
        while (it.hasNext() && (d = it.next().longValue()) < this.upperBound) {
        }
        if (d >= 0L) {
            this.current.set(this.current.size() - 1, d);
        }
        if (this.totalDegree(this.current) != this.upperBound) {
            this.empty = true;
            this.current.clear();
        }
    }

    @Override
    public synchronized boolean hasNext() {
        return !this.empty;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public synchronized List<Long> next() {
        if (this.empty) {
            throw new NoSuchElementException("invalid call of next()");
        }
        res = new ArrayList<Long>(this.current);
        while (true) {
            for (i = this.compit.size() - 1; i >= 0 && !(iter = this.compit.get(i)).hasNext(); --i) {
            }
            if (i < 0) {
                this.empty = true;
                return res;
            }
            pd = 0L;
            for (j = 0; j < i; ++j) {
                pd += this.current.get(j).longValue();
            }
            if (pd >= this.upperBound) {
                if (this.current.get(0) == this.upperBound) {
                    this.empty = true;
                    return res;
                }
                pd = this.upperBound;
            }
            rd = this.upperBound - pd;
            for (j = i + 1; j < this.compit.size(); ++j) {
                iter = (LongIterator)this.comps.get(j).iterator();
                iter.setUpperBound(rd);
                this.compit.set(j, iter);
            }
            for (j = i; j < this.compit.size(); ++j) {
                iter = this.compit.get(j);
                el = iter.next();
                this.current.set(j, el);
            }
            td = this.totalDegree(this.current);
            if (td == this.upperBound) {
                return res;
            }
            if (td > this.upperBound) ** continue;
            it = this.compit.get(this.compit.size() - 1);
            d = -1L;
            while (td < this.upperBound && it.hasNext()) {
                ++td;
                d = it.next();
            }
            if (d >= 0L) {
                this.current.set(this.current.size() - 1, d);
            }
            if (td == this.upperBound) break;
        }
        return res;
    }

    public long totalDegree(List<Long> e) {
        long d = 0L;
        for (Long i : e) {
            d += i.longValue();
        }
        return d;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("cannnot remove tuples");
    }
}

