/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.util;

import edu.jas.util.CartesianProductIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CartesianProduct<E>
implements Iterable<List<E>> {
    public final List<Iterable<E>> comps;

    public CartesianProduct(List<Iterable<E>> comps) {
        if (comps == null) {
            throw new IllegalArgumentException("null components not allowed");
        }
        this.comps = comps;
    }

    @Override
    public Iterator<List<E>> iterator() {
        return new CartesianProductIterator<E>(this.comps);
    }

    static <E> List<Iterable<E>> listToIterable(List<List<E>> comp) {
        ArrayList<Iterable<List<E>>> iter = new ArrayList<Iterable<List<E>>>(comp.size());
        for (List<E> list : comp) {
            iter.add(list);
        }
        return iter;
    }
}

