/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.GCDFactory;
import edu.jas.ufd.SquarefreeAbstract;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class SquarefreeRingChar0<C extends GcdRingElem<C>>
extends SquarefreeAbstract<C> {
    private static final Logger logger = Logger.getLogger(SquarefreeRingChar0.class);
    protected final RingFactory<C> coFac;

    public SquarefreeRingChar0(RingFactory<C> fac) {
        super(GCDFactory.getProxy(fac));
        if (fac.isField()) {
            throw new IllegalArgumentException("fac is a field: use SquarefreeFieldChar0");
        }
        if (fac.characteristic().signum() != 0) {
            throw new IllegalArgumentException("characterisic(fac) must be zero");
        }
        this.coFac = fac;
    }

    public String toString() {
        return this.getClass().getName() + " with " + this.engine + " over " + this.coFac;
    }

    @Override
    public GenPolynomial<C> baseSquarefreePart(GenPolynomial<C> P) {
        if (P == null || P.isZERO()) {
            return P;
        }
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar > 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " only for univariate polynomials");
        }
        GenPolynomial<C> pp = this.engine.basePrimitivePart(P);
        if (pp.isConstant()) {
            return pp;
        }
        GenPolynomial<C> d = PolyUtil.baseDeriviative(pp);
        d = this.engine.basePrimitivePart(d);
        GenPolynomial<C> g = this.engine.baseGcd(pp, d);
        g = this.engine.basePrimitivePart(g);
        GenPolynomial<C> q = PolyUtil.basePseudoDivide(pp, g);
        q = this.engine.basePrimitivePart(q);
        return q;
    }

    @Override
    public SortedMap<GenPolynomial<C>, Long> baseSquarefreeFactors(GenPolynomial<C> A) {
        TreeMap<GenPolynomial<C>, Long> sfactors = new TreeMap<GenPolynomial<C>, Long>();
        if (A == null || A.isZERO()) {
            return sfactors;
        }
        if (A.isConstant()) {
            sfactors.put(A, 1L);
            return sfactors;
        }
        GenPolynomialRing pfac = A.ring;
        if (pfac.nvar > 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " only for univariate polynomials");
        }
        GcdRingElem ldbcf = (GcdRingElem)A.leadingBaseCoefficient();
        if (!ldbcf.isONE()) {
            C cc = this.engine.baseContent(A);
            A = A.divide(cc);
            GenPolynomial<C> f1 = ((GenPolynomial)pfac.getONE()).multiply(cc);
            sfactors.put(f1, 1L);
        }
        GenPolynomial<C> T0 = A;
        GenPolynomial<C> T = null;
        GenPolynomial<C> V = null;
        long k = 0L;
        boolean init = true;
        while (true) {
            if (init) {
                if (T0.isConstant() || T0.isZERO()) break;
                GenPolynomial<C> Tp = PolyUtil.baseDeriviative(T0);
                T = this.engine.baseGcd(T0, Tp);
                T = this.engine.basePrimitivePart(T);
                V = PolyUtil.basePseudoDivide(T0, T);
                k = 0L;
                init = false;
            }
            if (V.isConstant()) break;
            ++k;
            GenPolynomial W = this.engine.baseGcd(T, V);
            W = this.engine.basePrimitivePart(W);
            GenPolynomial z = PolyUtil.basePseudoDivide(V, W);
            V = W;
            T = PolyUtil.basePseudoDivide(T, V);
            if (z.degree(0) <= 0L) continue;
            if (ldbcf.isONE() && !((GcdRingElem)z.leadingBaseCoefficient()).isONE()) {
                z = this.engine.basePrimitivePart(z);
                logger.info((Object)("z,pp = " + z));
            }
            sfactors.put(z, k);
        }
        return this.normalizeFactorization(sfactors);
    }

    @Override
    public GenPolynomial<GenPolynomial<C>> recursiveUnivariateSquarefreePart(GenPolynomial<GenPolynomial<C>> P) {
        if (P == null || P.isZERO()) {
            return P;
        }
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar > 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " only for multivariate polynomials");
        }
        GenPolynomial<GenPolynomial<GenPolynomial<C>>> pp = P;
        GenPolynomial<C> Pc = this.engine.recursiveContent(P);
        if (!(Pc = this.engine.basePrimitivePart(Pc)).isONE()) {
            pp = PolyUtil.coefficientPseudoDivide(pp, Pc);
        }
        if (pp.leadingExpVector().getVal(0) < 1L) {
            return pp.multiply((GenPolynomial<GenPolynomial<C>>)Pc);
        }
        GenPolynomial<GenPolynomial<C>> d = PolyUtil.recursiveDeriviative(pp);
        GenPolynomial<GenPolynomial<C>> g = this.engine.recursiveUnivariateGcd(pp, d);
        g = this.engine.baseRecursivePrimitivePart(g);
        GenPolynomial<GenPolynomial<GenPolynomial<C>>> q = PolyUtil.recursivePseudoDivide(pp, g);
        q = this.engine.baseRecursivePrimitivePart(q);
        return q.multiply((GenPolynomial<GenPolynomial<C>>)Pc);
    }

    @Override
    public SortedMap<GenPolynomial<GenPolynomial<C>>, Long> recursiveUnivariateSquarefreeFactors(GenPolynomial<GenPolynomial<C>> P) {
        TreeMap<GenPolynomial<GenPolynomial<C>>, Long> sfactors = new TreeMap<GenPolynomial<GenPolynomial<C>>, Long>();
        if (P == null || P.isZERO()) {
            return sfactors;
        }
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar > 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " only for univariate polynomials");
        }
        GenPolynomialRing cfac = (GenPolynomialRing)pfac.coFac;
        C bcc = this.engine.baseRecursiveContent(P);
        if (!bcc.isONE()) {
            GenPolynomial<C> lc = ((GenPolynomial)cfac.getONE()).multiply(bcc);
            GenPolynomial<GenPolynomial<C>> pl = ((GenPolynomial)pfac.getONE()).multiply(lc);
            sfactors.put(pl, 1L);
            P = PolyUtil.baseRecursiveDivide(P, bcc);
        }
        GenPolynomial<C> Pc = this.engine.recursiveContent(P);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Pc = " + Pc));
        }
        if (!(Pc = this.engine.basePrimitivePart(Pc)).isONE()) {
            P = PolyUtil.coefficientPseudoDivide(P, Pc);
        }
        SortedMap<GenPolynomial<C>, Long> rsf = this.squarefreeFactors((C)Pc);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("rsf = " + rsf));
        }
        for (Map.Entry<GenPolynomial<C>, Long> me : rsf.entrySet()) {
            GenPolynomial<C> c = me.getKey();
            if (c.isONE()) continue;
            GenPolynomial<GenPolynomial<C>> cr = ((GenPolynomial)pfac.getONE()).multiply(c);
            Long rk = me.getValue();
            sfactors.put(cr, rk);
        }
        GenPolynomial<GenPolynomial<C>> T0 = P;
        GenPolynomial<GenPolynomial<C>> T = null;
        GenPolynomial<GenPolynomial<C>> V = null;
        long k = 0L;
        boolean init = true;
        while (true) {
            if (init) {
                if (T0.isConstant() || T0.isZERO()) break;
                GenPolynomial<GenPolynomial<C>> Tp = PolyUtil.recursiveDeriviative(T0);
                T = this.engine.recursiveUnivariateGcd(T0, Tp);
                T = this.engine.baseRecursivePrimitivePart(T);
                V = PolyUtil.recursivePseudoDivide(T0, T);
                k = 0L;
                init = false;
            }
            if (V.isConstant()) break;
            ++k;
            GenPolynomial<GenPolynomial<GenPolynomial<C>>> W = this.engine.recursiveUnivariateGcd(T, V);
            W = this.engine.baseRecursivePrimitivePart(W);
            GenPolynomial z = PolyUtil.recursivePseudoDivide(V, W);
            V = W;
            T = PolyUtil.recursivePseudoDivide(T, V);
            if (z.isONE() || z.isZERO()) continue;
            z = this.engine.baseRecursivePrimitivePart(z);
            sfactors.put(z, k);
        }
        return sfactors;
    }

    @Override
    public GenPolynomial<C> squarefreePart(GenPolynomial<C> P) {
        if (P == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P != null");
        }
        if (P.isZERO()) {
            return P;
        }
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar <= 1) {
            return this.baseSquarefreePart(P);
        }
        GenPolynomialRing cfac = pfac.contract(1);
        GenPolynomialRing rfac = new GenPolynomialRing(cfac, 1);
        GenPolynomial Pr = PolyUtil.recursive(rfac, P);
        GenPolynomial Pc = this.engine.recursiveContent(Pr);
        Pr = PolyUtil.coefficientPseudoDivide(Pr, Pc);
        GenPolynomial Ps = this.squarefreePart(Pc);
        GenPolynomial PP = this.recursiveUnivariateSquarefreePart(Pr);
        GenPolynomial PS = PP.multiply(Ps);
        GenPolynomial D2 = PolyUtil.distribute(pfac, PS);
        return D2;
    }

    @Override
    public SortedMap<GenPolynomial<C>, Long> squarefreeFactors(GenPolynomial<C> P) {
        if (P == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P != null");
        }
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar <= 1) {
            return this.baseSquarefreeFactors(P);
        }
        TreeMap<GenPolynomial<C>, Long> sfactors = new TreeMap<GenPolynomial<C>, Long>();
        if (P.isZERO()) {
            return sfactors;
        }
        if (P.isONE()) {
            sfactors.put(P, 1L);
            return sfactors;
        }
        GenPolynomialRing cfac = pfac.contract(1);
        GenPolynomialRing rfac = new GenPolynomialRing(cfac, 1);
        GenPolynomial Pr = PolyUtil.recursive(rfac, P);
        SortedMap PP = this.recursiveUnivariateSquarefreeFactors(Pr);
        for (Map.Entry m : PP.entrySet()) {
            Long i = m.getValue();
            GenPolynomial Dr = m.getKey();
            GenPolynomial D2 = PolyUtil.distribute(pfac, Dr);
            sfactors.put(D2, i);
        }
        return this.normalizeFactorization(sfactors);
    }

    @Override
    public SortedMap<C, Long> squarefreeFactors(C P) {
        throw new UnsupportedOperationException("method not implemented");
    }
}

