/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.kern.StringUtil;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.structure.Element;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.QuotPairFactory;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.GCDFactory;
import edu.jas.ufd.GreatestCommonDivisor;
import edu.jas.ufd.Quotient;
import java.io.Reader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.log4j.Logger;

public class QuotientRing<C extends GcdRingElem<C>>
implements RingFactory<Quotient<C>>,
QuotPairFactory<GenPolynomial<C>, Quotient<C>> {
    private static final Logger logger = Logger.getLogger(QuotientRing.class);
    public final GenPolynomialRing<C> ring;
    public final GreatestCommonDivisor<C> engine;
    public final boolean ufdGCD;

    public QuotientRing(GenPolynomialRing<C> r) {
        this(r, true);
    }

    public QuotientRing(GenPolynomialRing<C> r, boolean ufdGCD) {
        this.ring = r;
        this.ufdGCD = ufdGCD;
        this.engine = GCDFactory.getProxy(this.ring.coFac);
        logger.debug((Object)"quotient ring constructed");
    }

    @Override
    public GenPolynomialRing<C> pairFactory() {
        return this.ring;
    }

    @Override
    public Quotient<C> create(GenPolynomial<C> n) {
        return new Quotient<C>(this, n);
    }

    @Override
    public Quotient<C> create(GenPolynomial<C> n, GenPolynomial<C> d) {
        return new Quotient<C>(this, n, d);
    }

    protected GenPolynomial<C> divide(GenPolynomial<C> n, GenPolynomial<C> d) {
        return PolyUtil.basePseudoDivide(n, d);
    }

    protected GenPolynomial<C> gcd(GenPolynomial<C> n, GenPolynomial<C> d) {
        if (this.ufdGCD) {
            return this.engine.gcd(n, d);
        }
        return this.engine.gcd(n, d);
    }

    @Override
    public boolean isFinite() {
        return false;
    }

    @Override
    public Quotient<C> copy(Quotient<C> c) {
        return new Quotient(c.ring, c.num, c.den, true);
    }

    @Override
    public Quotient<C> getZERO() {
        return new Quotient(this, this.ring.getZERO());
    }

    @Override
    public Quotient<C> getONE() {
        return new Quotient(this, this.ring.getONE());
    }

    @Override
    public List<Quotient<C>> generators() {
        List<GenPolynomial<C>> pgens = this.ring.generators();
        ArrayList<Quotient<C>> gens = new ArrayList<Quotient<C>>(pgens.size());
        for (GenPolynomial<C> p : pgens) {
            Quotient<C> q = new Quotient<C>(this, p);
            gens.add(q);
        }
        return gens;
    }

    @Override
    public boolean isCommutative() {
        return this.ring.isCommutative();
    }

    @Override
    public boolean isAssociative() {
        return this.ring.isAssociative();
    }

    @Override
    public boolean isField() {
        return true;
    }

    @Override
    public BigInteger characteristic() {
        return this.ring.characteristic();
    }

    @Override
    public Quotient<C> fromInteger(BigInteger a) {
        return new Quotient(this, this.ring.fromInteger(a));
    }

    @Override
    public Quotient<C> fromInteger(long a) {
        return new Quotient(this, this.ring.fromInteger(a));
    }

    public String toString() {
        String s = null;
        s = this.ring.coFac.characteristic().signum() == 0 ? "RatFunc" : "ModFunc";
        return s + "( " + this.ring.toString() + " )";
    }

    @Override
    public String toScript() {
        return "RF(" + this.ring.toScript() + ")";
    }

    public boolean equals(Object b) {
        if (b == null) {
            return false;
        }
        if (!(b instanceof QuotientRing)) {
            return false;
        }
        QuotientRing a = (QuotientRing)b;
        return this.ring.equals(a.ring);
    }

    public int hashCode() {
        int h = this.ring.hashCode();
        return h;
    }

    @Override
    public Quotient<C> random(int n) {
        GenPolynomial r = ((GenPolynomial)this.ring.random(n)).monic();
        GenPolynomial s = ((GenPolynomial)this.ring.random(n)).monic();
        while (s.isZERO()) {
            s = ((GenPolynomial)this.ring.random(n)).monic();
        }
        return new Quotient(this, r, s, false);
    }

    public Quotient<C> random(int k, int l, int d, float q) {
        GenPolynomial<C> r = this.ring.random(k, l, d, q).monic();
        GenPolynomial<C> s = this.ring.random(k, l, d, q).monic();
        while (s.isZERO()) {
            s = this.ring.random(k, l, d, q).monic();
        }
        return new Quotient<C>(this, r, s, false);
    }

    @Override
    public Quotient<C> random(int n, Random rnd) {
        GenPolynomial r = ((GenPolynomial)this.ring.random(n, rnd)).monic();
        GenPolynomial s = ((GenPolynomial)this.ring.random(n, rnd)).monic();
        while (s.isZERO()) {
            s = ((GenPolynomial)this.ring.random(n, rnd)).monic();
        }
        return new Quotient(this, r, s, false);
    }

    @Override
    public Quotient<C> parse(String s) {
        int i = s.indexOf("{");
        if (i >= 0) {
            s = s.substring(i + 1);
        }
        if ((i = s.lastIndexOf("}")) >= 0) {
            s = s.substring(0, i);
        }
        if ((i = s.indexOf("|")) < 0) {
            Element n = this.ring.parse(s);
            return new Quotient(this, n);
        }
        String s1 = s.substring(0, i);
        String s2 = s.substring(i + 1);
        Element n = this.ring.parse(s1);
        Element d = this.ring.parse(s2);
        return new Quotient(this, n, d);
    }

    @Override
    public Quotient<C> parse(Reader r) {
        String s = StringUtil.nextPairedString(r, '{', '}');
        return this.parse(s);
    }

    public long extensionDegree() {
        long degree = -1L;
        if (this.ring.nvar <= 0) {
            degree = 0L;
        }
        return degree;
    }
}

