/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.BigInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.arith.ModLong;
import edu.jas.arith.ModLongRing;
import edu.jas.arith.Modular;
import edu.jas.arith.ModularRingFactory;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.ps.PolynomialTaylorFunction;
import edu.jas.ps.UnivPowerSeries;
import edu.jas.ps.UnivPowerSeriesRing;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.Element;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.MonoidElem;
import edu.jas.structure.Power;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.GCDFactory;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import edu.jas.ufd.HenselUtil;
import edu.jas.ufd.NoLiftingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class HenselMultUtil {
    private static final Logger logger = Logger.getLogger(HenselMultUtil.class);
    private static final boolean debug = logger.isInfoEnabled();

    public static <MOD extends GcdRingElem<MOD> & Modular> List<GenPolynomial<MOD>> liftDiophant(GenPolynomial<MOD> A, GenPolynomial<MOD> B, GenPolynomial<MOD> C, List<MOD> V, long d, long k) throws NoLiftingException {
        GenPolynomialRing pkfac = C.ring;
        if (pkfac.nvar == 1) {
            return HenselUtil.liftDiophant(A, B, C, k);
        }
        if (!pkfac.equals(A.ring)) {
            throw new IllegalArgumentException("A.ring != pkfac: " + A.ring + " != " + pkfac);
        }
        ArrayList<MOD> Vp = new ArrayList<MOD>(V);
        GcdRingElem v = (GcdRingElem)Vp.remove(Vp.size() - 1);
        GenPolynomial mon = pkfac.getONE();
        GenPolynomial<Element> xv = pkfac.univariate(0, 1L);
        xv = xv.subtract(pkfac.fromInteger(((Modular)((Object)v)).getSymmetricInteger().getVal()));
        ModularRingFactory cf = (ModularRingFactory)pkfac.coFac;
        GcdRingElem vp = (GcdRingElem)cf.fromInteger(((Modular)((Object)v)).getSymmetricInteger().getVal());
        GenPolynomialRing ckfac = pkfac.contract(1);
        GenPolynomial<GcdRingElem> Ap = PolyUtil.evaluateMain(ckfac, A, vp);
        GenPolynomial<GcdRingElem> Bp = PolyUtil.evaluateMain(ckfac, B, vp);
        GenPolynomial<GcdRingElem> Cp = PolyUtil.evaluateMain(ckfac, C, vp);
        List<GenPolynomial<GcdRingElem>> su = HenselMultUtil.liftDiophant(Ap, Bp, Cp, Vp, d, k);
        if (pkfac.nvar == 2 && !HenselUtil.isDiophantLift(Bp, Ap, su.get(0), su.get(1), Cp)) {
            throw new NoLiftingException("isDiophantLift: false");
        }
        if (!ckfac.equals(su.get((int)0).ring)) {
            throw new IllegalArgumentException("qfac != ckfac: " + su.get((int)0).ring + " != " + ckfac);
        }
        GenPolynomialRing<BigInteger> ifac = new GenPolynomialRing<BigInteger>(new BigInteger(), pkfac);
        String[] mn = new String[]{pkfac.getVars()[pkfac.nvar - 1]};
        GenPolynomialRing qrfac = new GenPolynomialRing(ckfac, 1, mn);
        ArrayList<GenPolynomial<MOD>> sup = new ArrayList<GenPolynomial<MOD>>(su.size());
        ArrayList<GenPolynomial<BigInteger>> supi = new ArrayList<GenPolynomial<BigInteger>>(su.size());
        for (GenPolynomial<GcdRingElem> s : su) {
            GenPolynomial<GcdRingElem> sp = s.extend(pkfac, 0, 0L);
            sup.add(sp);
            GenPolynomial<BigInteger> spi = PolyUtil.integerFromModularCoefficients(ifac, sp);
            supi.add(spi);
        }
        GenPolynomial<BigInteger> Ai = PolyUtil.integerFromModularCoefficients(ifac, A);
        GenPolynomial<BigInteger> Bi = PolyUtil.integerFromModularCoefficients(ifac, B);
        GenPolynomial<BigInteger> Ci = PolyUtil.integerFromModularCoefficients(ifac, C);
        GenPolynomial<RingElem<BigInteger>> E2 = Ci;
        E2 = E2.subtract((RingElem<BigInteger>)Bi.multiply((BigInteger)((Object)((GenPolynomial)supi.get(0)))));
        if ((E2 = E2.subtract((RingElem<BigInteger>)Ai.multiply((BigInteger)((Object)((GenPolynomial)supi.get(1)))))).isZERO()) {
            logger.info((Object)"liftDiophant leaving on zero E");
            return sup;
        }
        GenPolynomial Ep = PolyUtil.fromIntegerCoefficients(pkfac, E2);
        logger.info((Object)("Ep(0," + pkfac.nvar + ") = " + Ep));
        if (Ep.isZERO()) {
            logger.info((Object)"liftDiophant leaving on zero Ep mod p^k");
            return sup;
        }
        int e = 1;
        while ((long)e <= d) {
            GenPolynomial Epr = PolyUtil.recursive(qrfac, Ep);
            UnivPowerSeriesRing<GenPolynomial<Element>> psfac = new UnivPowerSeriesRing<GenPolynomial<Element>>(qrfac);
            PolynomialTaylorFunction F2 = new PolynomialTaylorFunction(Epr);
            ArrayList<Element> Vs = new ArrayList<Element>(1);
            Element vq = ckfac.fromInteger(((Modular)((Object)v)).getSymmetricInteger().getVal());
            Vs.add(vq);
            UnivPowerSeries<Element> Epst = psfac.seriesOfTaylor(F2, (GenPolynomial<Element>)vq);
            GenPolynomial cm = (GenPolynomial)Epst.coefficient(e);
            List<GenPolynomial<GcdRingElem>> S = HenselMultUtil.liftDiophant(Ap, Bp, cm, Vp, d, k);
            if (!ckfac.coFac.equals(S.get((int)0).ring.coFac)) {
                throw new IllegalArgumentException("ckfac != pkfac: " + ckfac.coFac + " != " + S.get((int)0).ring.coFac);
            }
            if (pkfac.nvar == 2 && !HenselUtil.isDiophantLift(Ap, Bp, S.get(1), S.get(0), cm)) {
                throw new NoLiftingException("isDiophantLift: false");
            }
            mon = mon.multiply(xv);
            ArrayList Sp = new ArrayList(S.size());
            int i = 0;
            supi = new ArrayList(su.size());
            for (GenPolynomial<GcdRingElem> dd : S) {
                GenPolynomial<RingElem<Object>> de = dd.extend(pkfac, 0, 0L);
                GenPolynomial dm = de.multiply((GcdRingElem)((Object)mon));
                Sp.add(dm);
                de = ((GenPolynomial)sup.get(i)).sum(dm);
                sup.set(i++, de);
                GenPolynomial<BigInteger> spi = PolyUtil.integerFromModularCoefficients(ifac, dm);
                supi.add(spi);
            }
            E2 = E2.subtract((RingElem<BigInteger>)Bi.multiply((BigInteger)((Object)((GenPolynomial)supi.get(0)))));
            if ((E2 = E2.subtract((RingElem<BigInteger>)Ai.multiply((BigInteger)((Object)((GenPolynomial)supi.get(1)))))).isZERO()) {
                logger.info((Object)"liftDiophant leaving on zero E");
                return sup;
            }
            Ep = PolyUtil.fromIntegerCoefficients(pkfac, E2);
            logger.info((Object)("Ep(" + e + "," + pkfac.nvar + ") = " + Ep));
            if (Ep.isZERO()) {
                logger.info((Object)"liftDiophant leaving on zero Ep mod p^k");
                return sup;
            }
            ++e;
        }
        return sup;
    }

    /*
     * WARNING - void declaration
     */
    public static <MOD extends GcdRingElem<MOD> & Modular> List<GenPolynomial<MOD>> liftDiophant(List<GenPolynomial<MOD>> A, GenPolynomial<MOD> C, List<MOD> V, long d, long k) throws NoLiftingException {
        void var32_40;
        GenPolynomialRing pkfac = C.ring;
        if (pkfac.nvar == 1) {
            return HenselUtil.liftDiophant(A, C, k);
        }
        if (!pkfac.equals(A.get((int)0).ring)) {
            throw new IllegalArgumentException("A.ring != pkfac: " + A.get((int)0).ring + " != " + pkfac);
        }
        GenPolynomial<GenPolynomial<MOD>> As = pkfac.getONE();
        for (GenPolynomial<MOD> a : A) {
            As = As.multiply(a);
        }
        ArrayList<GenPolynomial<GenPolynomial<MOD>>> Bp = new ArrayList<GenPolynomial<GenPolynomial<MOD>>>(A.size());
        for (GenPolynomial<MOD> a : A) {
            GenPolynomial<GenPolynomial<MOD>> b = PolyUtil.basePseudoDivide(As, a);
            Bp.add(b);
        }
        ArrayList<MOD> Vp = new ArrayList<MOD>(V);
        GcdRingElem v = (GcdRingElem)Vp.remove(Vp.size() - 1);
        GenPolynomial mon = pkfac.getONE();
        GenPolynomial<Element> xv = pkfac.univariate(0, 1L);
        xv = xv.subtract(pkfac.fromInteger(((Modular)((Object)v)).getSymmetricInteger().getVal()));
        ModularRingFactory cf = (ModularRingFactory)pkfac.coFac;
        GcdRingElem vp = (GcdRingElem)cf.fromInteger(((Modular)((Object)v)).getSymmetricInteger().getVal());
        GenPolynomialRing ckfac = pkfac.contract(1);
        ArrayList<GenPolynomial<MOD>> Ap = new ArrayList<GenPolynomial<MOD>>(A.size());
        for (GenPolynomial<MOD> a : A) {
            GenPolynomial<GcdRingElem> ap = PolyUtil.evaluateMain(ckfac, a, vp);
            Ap.add(ap);
        }
        GenPolynomial<GcdRingElem> Cp = PolyUtil.evaluateMain(ckfac, C, vp);
        List su = HenselMultUtil.liftDiophant(Ap, Cp, Vp, d, k);
        if (pkfac.nvar == 2 && !HenselUtil.isDiophantLift(Ap, su, Cp)) {
            throw new NoLiftingException("isDiophantLift: false");
        }
        if (!ckfac.equals(su.get((int)0).ring)) {
            throw new IllegalArgumentException("qfac != ckfac: " + su.get((int)0).ring + " != " + ckfac);
        }
        GenPolynomialRing<BigInteger> ifac = new GenPolynomialRing<BigInteger>(new BigInteger(), pkfac);
        String[] mn = new String[]{pkfac.getVars()[pkfac.nvar - 1]};
        GenPolynomialRing qrfac = new GenPolynomialRing(ckfac, 1, mn);
        ArrayList<GenPolynomial<MOD>> sup = new ArrayList<GenPolynomial<MOD>>(su.size());
        ArrayList<GenPolynomial<BigInteger>> supi = new ArrayList<GenPolynomial<BigInteger>>(su.size());
        for (GenPolynomial s : su) {
            GenPolynomial sp = s.extend(pkfac, 0, 0L);
            sup.add(sp);
            GenPolynomial<BigInteger> genPolynomial = PolyUtil.integerFromModularCoefficients(ifac, sp);
            supi.add(genPolynomial);
        }
        ArrayList<GenPolynomial<BigInteger>> Ai = new ArrayList<GenPolynomial<BigInteger>>(A.size());
        for (GenPolynomial<MOD> a : A) {
            GenPolynomial<BigInteger> genPolynomial = PolyUtil.integerFromModularCoefficients(ifac, a);
            Ai.add(genPolynomial);
        }
        ArrayList<GenPolynomial<BigInteger>> Bi = new ArrayList<GenPolynomial<BigInteger>>(A.size());
        for (GenPolynomial genPolynomial : Bp) {
            GenPolynomial<BigInteger> bi = PolyUtil.integerFromModularCoefficients(ifac, genPolynomial);
            Bi.add(bi);
        }
        GenPolynomial<BigInteger> Ci = PolyUtil.integerFromModularCoefficients(ifac, C);
        ArrayList arrayList = new ArrayList(A.size());
        for (GenPolynomial genPolynomial : Ai) {
            GenPolynomial aq = PolyUtil.fromIntegerCoefficients(pkfac, genPolynomial);
            arrayList.add(aq);
        }
        GenPolynomial<RingElem<BigInteger>> E2 = Ci;
        boolean bl = false;
        for (GenPolynomial genPolynomial : Bi) {
            void var30_35;
            E2 = E2.subtract((RingElem<BigInteger>)genPolynomial.multiply((GenPolynomial)supi.get((int)(++var30_35))));
        }
        if (E2.isZERO()) {
            logger.info((Object)"liftDiophant leaving on zero E");
            return sup;
        }
        GenPolynomial Ep = PolyUtil.fromIntegerCoefficients(pkfac, E2);
        logger.info((Object)("Ep(0," + pkfac.nvar + ") = " + Ep));
        if (Ep.isZERO()) {
            logger.info((Object)"liftDiophant leaving on zero Ep mod p^k");
            return sup;
        }
        boolean bl2 = true;
        while ((long)var32_40 <= d) {
            GenPolynomial Epr = PolyUtil.recursive(qrfac, Ep);
            UnivPowerSeriesRing<GenPolynomial<Element>> psfac = new UnivPowerSeriesRing<GenPolynomial<Element>>(qrfac);
            PolynomialTaylorFunction F2 = new PolynomialTaylorFunction(Epr);
            ArrayList<Element> Vs = new ArrayList<Element>(1);
            Element vq = ckfac.fromInteger(((Modular)((Object)v)).getSymmetricInteger().getVal());
            Vs.add(vq);
            UnivPowerSeries<Element> Epst = psfac.seriesOfTaylor(F2, (GenPolynomial<Element>)vq);
            GenPolynomial cm = (GenPolynomial)Epst.coefficient((int)var32_40);
            if (!cm.isZERO()) {
                List<GenPolynomial<MOD>> S = HenselMultUtil.liftDiophant(Ap, cm, Vp, d, k);
                if (!ckfac.coFac.equals(S.get((int)0).ring.coFac)) {
                    throw new IllegalArgumentException("ckfac != pkfac: " + ckfac.coFac + " != " + S.get((int)0).ring.coFac);
                }
                if (pkfac.nvar == 2 && !HenselUtil.isDiophantLift(Ap, S, cm)) {
                    throw new NoLiftingException("isDiophantLift: false");
                }
                mon = mon.multiply(xv);
                ArrayList Sp = new ArrayList(S.size());
                int n = 0;
                supi = new ArrayList(su.size());
                for (GenPolynomial<MOD> genPolynomial : S) {
                    GenPolynomial<Object> de = genPolynomial.extend(pkfac, 0, 0L);
                    GenPolynomial dm = de.multiply((MOD)mon);
                    Sp.add(dm);
                    de = ((GenPolynomial)sup.get(n)).sum(dm);
                    sup.set(n++, de);
                    GenPolynomial<BigInteger> spi = PolyUtil.integerFromModularCoefficients(ifac, dm);
                    supi.add(spi);
                }
                n = 0;
                for (GenPolynomial<Object> genPolynomial : Bi) {
                    E2 = E2.subtract((RingElem<BigInteger>)genPolynomial.multiply((Object)((GenPolynomial)supi.get(n++))));
                }
                if (E2.isZERO()) {
                    logger.info((Object)"liftDiophant leaving on zero E");
                    return sup;
                }
                Ep = PolyUtil.fromIntegerCoefficients(pkfac, E2);
                logger.info((Object)("Ep(" + (int)var32_40 + "," + pkfac.nvar + ") = " + Ep));
                if (Ep.isZERO()) {
                    logger.info((Object)"liftDiophant leaving on zero Ep mod p^k");
                    return sup;
                }
            }
            ++var32_40;
        }
        return sup;
    }

    @Deprecated
    public static <MOD extends GcdRingElem<MOD> & Modular> boolean isHenselLift(GenPolynomial<BigInteger> C, GenPolynomial<MOD> Cp, List<GenPolynomial<MOD>> F2, long k, List<GenPolynomial<MOD>> L) {
        return HenselMultUtil.isHenselLift(C, Cp, F2, L);
    }

    public static <MOD extends GcdRingElem<MOD> & Modular> boolean isHenselLift(GenPolynomial<BigInteger> C, GenPolynomial<MOD> Cp, List<GenPolynomial<MOD>> F2, List<GenPolynomial<MOD>> L) {
        boolean t = true;
        GenPolynomialRing qfac = L.get((int)0).ring;
        GenPolynomial<GenPolynomial<MOD>> q = qfac.getONE();
        for (GenPolynomial<MOD> fi : L) {
            q = q.multiply(fi);
        }
        t = Cp.equals(q);
        if (!t) {
            System.out.println("Cp     = " + Cp);
            System.out.println("q      = " + q);
            System.out.println("Cp != q: " + Cp.subtract((MOD)q));
            return t;
        }
        GenPolynomialRing<BigInteger> dfac = C.ring;
        GenPolynomial<BigInteger> Ci = PolyUtil.integerFromModularCoefficients(dfac, q);
        t = C.equals(Ci);
        if (!t) {
            System.out.println("C      = " + C);
            System.out.println("Ci     = " + Ci);
            System.out.println("C != Ci: " + C.subtract((BigInteger)((Object)Ci)));
            return t;
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    public static <MOD extends GcdRingElem<MOD> & Modular> List<GenPolynomial<MOD>> liftHenselMonic(GenPolynomial<BigInteger> C, GenPolynomial<MOD> Cp, List<GenPolynomial<MOD>> F2, List<BigInteger> V, long k) throws NoLiftingException {
        GenPolynomialRing pkfac = Cp.ring;
        long d = C.degree();
        ArrayList<GenPolynomialRing> Pfac = new ArrayList<GenPolynomialRing>();
        ArrayList<GenPolynomial> Ap = new ArrayList<GenPolynomial>();
        ArrayList<GcdRingElem> Vb = new ArrayList<GcdRingElem>();
        GcdRingElem v = (GcdRingElem)pkfac.coFac.fromInteger(V.get(0).getVal());
        Pfac.add(pkfac);
        Ap.add(Cp);
        Vb.add(v);
        GenPolynomialRing pf = pkfac;
        GenPolynomial ap = Cp;
        for (int j = pkfac.nvar; j > 2; --j) {
            pf = pf.contract(1);
            Pfac.add(0, pf);
            GcdRingElem vp = (GcdRingElem)pkfac.coFac.fromInteger(V.get(j - 2).getVal());
            Vb.add(1, vp);
            ap = PolyUtil.evaluateMain(pf, ap, vp);
            Ap.add(0, ap);
        }
        if (debug) {
            logger.debug((Object)("Pfac   = " + Pfac));
        }
        GenPolynomialRing pk1fac = F2.get((int)0).ring;
        if (!pkfac.coFac.equals(pk1fac.coFac)) {
            throw new IllegalArgumentException("F.ring != pkfac: " + pk1fac + " != " + pkfac);
        }
        pkfac = (GenPolynomialRing)Pfac.get(0);
        GenPolynomialRing<BigInteger> i1fac = new GenPolynomialRing<BigInteger>(new BigInteger(), pk1fac);
        ArrayList<GenPolynomial<BigInteger>> Bi = new ArrayList<GenPolynomial<BigInteger>>(F2.size());
        for (GenPolynomial<MOD> b : F2) {
            GenPolynomial<BigInteger> bi = PolyUtil.integerFromModularCoefficients(i1fac, b);
            Bi.add(bi);
        }
        ArrayList<GenPolynomial<Object>> U = new ArrayList<GenPolynomial<MOD>>(F2.size());
        for (GenPolynomial<MOD> b : F2) {
            GenPolynomial<MOD> bi = b.extend(pkfac, 0, 0L);
            U.add(bi);
        }
        List<GenPolynomial<MOD>> U1 = F2;
        MonoidElem<GenPolynomial<Object>> E2 = C.ring.getZERO();
        ArrayList<GcdRingElem> Vh = new ArrayList<GcdRingElem>();
        while (Pfac.size() > 0) {
            void var30_28;
            pkfac = (GenPolynomialRing)Pfac.remove(0);
            Cp = (GenPolynomial)Ap.remove(0);
            v = (GcdRingElem)Vb.remove(0);
            GenPolynomial mon = pkfac.getONE();
            GenPolynomial<Element> xv = pkfac.univariate(0, 1L);
            xv = xv.subtract(pkfac.fromInteger(((Modular)((Object)v)).getSymmetricInteger().getVal()));
            long deg = Cp.degree(pkfac.nvar - 1);
            GenPolynomialRing<BigInteger> ifac = new GenPolynomialRing<BigInteger>(new BigInteger(), pkfac);
            ArrayList<GenPolynomial<BigInteger>> Bip = new ArrayList<GenPolynomial<BigInteger>>(F2.size());
            for (GenPolynomial genPolynomial : Bi) {
                GenPolynomial<BigInteger> genPolynomial2 = genPolynomial.extend(ifac, 0, 0L);
                Bip.add(genPolynomial2);
            }
            Bi = Bip;
            GenPolynomial<BigInteger> Ci = PolyUtil.integerFromModularCoefficients(ifac, Cp);
            E2 = ifac.getONE();
            for (GenPolynomial genPolynomial : Bi) {
                E2 = ((GenPolynomial)E2).multiply((GenPolynomial<Object>)((Object)((BigInteger)((Object)genPolynomial))));
            }
            E2 = Ci.subtract((BigInteger)E2);
            GenPolynomial genPolynomial = PolyUtil.fromIntegerCoefficients(pkfac, E2);
            logger.info((Object)("Ep(0," + deg + "," + pkfac.nvar + ") = " + genPolynomial));
            String[] stringArray = new String[]{pkfac.getVars()[pkfac.nvar - 1]};
            GenPolynomialRing ckfac = pkfac.contract(1);
            GenPolynomialRing pkrfac = new GenPolynomialRing(ckfac, 1, stringArray);
            int e = 1;
            while ((long)e <= deg && !var30_28.isZERO()) {
                GenPolynomial Epr = PolyUtil.recursive(pkrfac, var30_28);
                UnivPowerSeriesRing<GenPolynomial<Element>> univPowerSeriesRing = new UnivPowerSeriesRing<GenPolynomial<Element>>(pkrfac);
                PolynomialTaylorFunction T = new PolynomialTaylorFunction(Epr);
                ArrayList<Element> Vs = new ArrayList<Element>(1);
                Element vq = ckfac.fromInteger(((Modular)((Object)v)).getSymmetricInteger().getVal());
                Vs.add(vq);
                UnivPowerSeries<Element> Epst = univPowerSeriesRing.seriesOfTaylor(T, (GenPolynomial<Element>)vq);
                logger.info((Object)("Epst(" + e + "," + deg + ", " + pkfac.nvar + ") = " + Epst));
                GenPolynomial cm = (GenPolynomial)Epst.coefficient(e);
                if (!cm.isZERO()) {
                    List<GenPolynomial<MOD>> Ud = HenselMultUtil.liftDiophant(U1, cm, Vh, d, k);
                    mon = mon.multiply(xv);
                    ArrayList Sd = new ArrayList(Ud.size());
                    int i = 0;
                    ArrayList<GenPolynomial<BigInteger>> Si = new ArrayList<GenPolynomial<BigInteger>>(Ud.size());
                    for (GenPolynomial<MOD> genPolynomial3 : Ud) {
                        GenPolynomial<Object> de = genPolynomial3.extend(pkfac, 0, 0L);
                        GenPolynomial dm = de.multiply((MOD)mon);
                        Sd.add(dm);
                        de = ((GenPolynomial)U.get(i)).sum(dm);
                        U.set(i++, de);
                        GenPolynomial<BigInteger> si = PolyUtil.integerFromModularCoefficients(ifac, de);
                        Si.add(si);
                    }
                    E2 = ifac.getONE();
                    for (GenPolynomial<Object> genPolynomial4 : Si) {
                        E2 = ((GenPolynomial)E2).multiply(genPolynomial4);
                    }
                    E2 = Ci.subtract((BigInteger)E2);
                    GenPolynomial genPolynomial5 = PolyUtil.fromIntegerCoefficients(pkfac, E2);
                    logger.info((Object)("Ep(" + e + "," + deg + "," + pkfac.nvar + ") = " + genPolynomial5));
                }
                ++e;
            }
            Vh.add(v);
            U1 = U;
            if (Pfac.size() <= 0) continue;
            ArrayList U2 = new ArrayList(U.size());
            pkfac = (GenPolynomialRing)Pfac.get(0);
            for (GenPolynomial genPolynomial6 : U) {
                GenPolynomial bi = genPolynomial6.extend(pkfac, 0, 0L);
                U2.add(bi);
            }
            U = U2;
        }
        if (((GenPolynomial)E2).isZERO()) {
            logger.info((Object)"liftHensel leaving with zero E");
        }
        return U;
    }

    public static <MOD extends GcdRingElem<MOD> & Modular> List<GenPolynomial<MOD>> liftHensel(GenPolynomial<BigInteger> C, GenPolynomial<MOD> Cp, List<GenPolynomial<MOD>> F2, List<BigInteger> V, long k, List<GenPolynomial<BigInteger>> G) throws NoLiftingException {
        GenPolynomialRing pkfac = Cp.ring;
        long d = C.degree();
        GenPolynomialRing pkfac1 = new GenPolynomialRing(pkfac.coFac, G.get((int)0).ring);
        ArrayList Lp = new ArrayList(G.size());
        for (GenPolynomial<BigInteger> cd1 : G) {
            GenPolynomial cdq = PolyUtil.fromIntegerCoefficients(pkfac1, cd1);
            cdq = cdq.extendLower(pkfac, 0, 0L);
            Lp.add(cdq);
        }
        logger.info((Object)("G modulo p^k: " + Lp));
        ArrayList<GenPolynomialRing> Pfac = new ArrayList<GenPolynomialRing>();
        ArrayList<GenPolynomial> Ap = new ArrayList<GenPolynomial>();
        ArrayList Gp = new ArrayList();
        ArrayList Vb = new ArrayList();
        Pfac.add(pkfac);
        Ap.add(Cp);
        Gp.add(Lp);
        GenPolynomialRing pf = pkfac;
        GenPolynomial ap = Cp;
        List Lpp = Lp;
        for (int j = pkfac.nvar; j > 2; --j) {
            pf = pf.contract(1);
            Pfac.add(0, pf);
            GcdRingElem vp = (GcdRingElem)pkfac.coFac.fromInteger(V.get(pkfac.nvar - j).getVal());
            Vb.add(vp);
            ap = PolyUtil.evaluateMain(pf, ap, vp);
            Ap.add(0, ap);
            ArrayList<GenPolynomial<GcdRingElem>> Lps = new ArrayList<GenPolynomial<GcdRingElem>>(Lpp.size());
            for (GenPolynomial qp : Lpp) {
                GenPolynomial<GcdRingElem> qpe = PolyUtil.evaluateMain(pf, qp, vp);
                Lps.add(qpe);
            }
            Lpp = Lps;
            Gp.add(0, Lpp);
        }
        Vb.add(pkfac.coFac.fromInteger(V.get(pkfac.nvar - 2).getVal()));
        if (debug) {
            logger.debug((Object)("Pfac   = " + Pfac));
        }
        GenPolynomialRing pk1fac = F2.get((int)0).ring;
        if (!pkfac.coFac.equals(pk1fac.coFac)) {
            throw new IllegalArgumentException("F.ring != pkfac: " + pk1fac + " != " + pkfac);
        }
        List<GenPolynomial<MOD>> U = F2;
        MonoidElem<GenPolynomial<Object>> E2 = C.ring.getZERO();
        ArrayList<GcdRingElem> Vh = new ArrayList<GcdRingElem>();
        GcdRingElem v = null;
        while (Pfac.size() > 0) {
            pkfac = (GenPolynomialRing)Pfac.remove(0);
            Cp = (GenPolynomial)Ap.remove(0);
            Lpp = (List)Gp.remove(0);
            v = (GcdRingElem)Vb.remove(Vb.size() - 1);
            logger.info((Object)("stack loop: pkfac = " + pkfac.toScript() + " v = " + v));
            List<GenPolynomial<MOD>> U1 = U;
            logger.info((Object)("to lift U1 = " + U1));
            U = new ArrayList<GenPolynomial<MOD>>(U1.size());
            int j = 0;
            for (GenPolynomial<MOD> b : U1) {
                GenPolynomial<Object> bi = b.extend(pkfac, 0, 0L);
                GenPolynomial li = (GenPolynomial)Lpp.get(j);
                if (!li.isONE()) {
                    GenPolynomialRing pkrfac = pkfac.recursive(pkfac.nvar - 1);
                    GenPolynomial br = PolyUtil.recursive(pkrfac, bi);
                    GenPolynomial bs = PolyUtil.switchVariables(br);
                    GenPolynomial lr = PolyUtil.recursive(pkrfac, li);
                    GenPolynomial ls = PolyUtil.switchVariables(lr);
                    if (!ls.isConstant() && !ls.isZERO()) {
                        throw new RuntimeException("ls not constant " + ls + ", li = " + li);
                    }
                    bs.doPutToMap(bs.leadingExpVector(), ls.leadingBaseCoefficient());
                    br = PolyUtil.switchVariables(bs);
                    bi = PolyUtil.distribute(pkfac, br);
                }
                U.add(bi);
                ++j;
            }
            logger.info((Object)("U with leading coefficient replaced = " + U));
            GenPolynomial mon = pkfac.getONE();
            GenPolynomial<Element> xv = pkfac.univariate(0, 1L);
            xv = xv.subtract(pkfac.fromInteger(((Modular)((Object)v)).getSymmetricInteger().getVal()));
            long deg = Cp.degree(pkfac.nvar - 1);
            GenPolynomialRing<BigInteger> ifac = new GenPolynomialRing<BigInteger>(new BigInteger(), pkfac);
            List<GenPolynomial<BigInteger>> Bi = PolyUtil.integerFromModularCoefficients(ifac, U);
            GenPolynomial<BigInteger> Ci = PolyUtil.integerFromModularCoefficients(ifac, Cp);
            E2 = ifac.getONE();
            for (GenPolynomial<BigInteger> bi : Bi) {
                E2 = ((GenPolynomial)E2).multiply(bi);
            }
            E2 = Ci.subtract((BigInteger)E2);
            GenPolynomial Ep = PolyUtil.fromIntegerCoefficients(pkfac, E2);
            logger.info((Object)("Ep(0," + deg + "," + pkfac.nvar + ") = " + Ep));
            GenPolynomialRing pkrfac = pkfac.recursive(1);
            GenPolynomialRing ckfac = (GenPolynomialRing)pkrfac.coFac;
            int e = 1;
            while ((long)e <= deg && !Ep.isZERO()) {
                logger.info((Object)("approximation loop: e = " + e + " of deg = " + deg));
                GenPolynomial Epr = PolyUtil.recursive(pkrfac, Ep);
                UnivPowerSeriesRing<GenPolynomial<Element>> univPowerSeriesRing = new UnivPowerSeriesRing<GenPolynomial<Element>>(pkrfac);
                PolynomialTaylorFunction T = new PolynomialTaylorFunction(Epr);
                Element vq = ckfac.fromInteger(((Modular)((Object)v)).getSymmetricInteger().getVal());
                UnivPowerSeries<Element> Epst = univPowerSeriesRing.seriesOfTaylor(T, (GenPolynomial<Element>)vq);
                logger.info((Object)("Epst(" + e + "," + deg + "," + pkfac.nvar + ") = " + Epst));
                GenPolynomial cm = (GenPolynomial)Epst.coefficient(e);
                if (!cm.isZERO()) {
                    List<GenPolynomial<MOD>> Ud = HenselMultUtil.liftDiophant(U1, cm, Vh, d, k);
                    mon = mon.multiply(xv);
                    ArrayList Sd = new ArrayList(Ud.size());
                    int i = 0;
                    ArrayList<GenPolynomial<BigInteger>> Si = new ArrayList<GenPolynomial<BigInteger>>(Ud.size());
                    for (GenPolynomial<MOD> genPolynomial : Ud) {
                        GenPolynomial<Object> de = genPolynomial.extend(pkfac, 0, 0L);
                        GenPolynomial dm = de.multiply((MOD)mon);
                        Sd.add(dm);
                        de = U.get(i).sum((MOD)dm);
                        U.set(i++, de);
                        GenPolynomial<BigInteger> si = PolyUtil.integerFromModularCoefficients(ifac, de);
                        Si.add(si);
                    }
                    E2 = ifac.getONE();
                    for (GenPolynomial<Object> genPolynomial : Si) {
                        E2 = ((GenPolynomial)E2).multiply(genPolynomial);
                    }
                    E2 = Ci.subtract((BigInteger)E2);
                    Ep = PolyUtil.fromIntegerCoefficients(pkfac, E2);
                    logger.info((Object)("Ep(" + e + "," + deg + "," + pkfac.nvar + ") = " + Ep));
                }
                ++e;
            }
            Vh.add(v);
            GenPolynomial Uf = U.get((int)0).ring.getONE();
            for (GenPolynomial genPolynomial : U) {
                Uf = Uf.multiply(genPolynomial);
            }
        }
        if (((GenPolynomial)E2).isZERO()) {
            logger.info((Object)"liftHensel leaving with zero E, Ep");
        }
        logger.info((Object)("multivariate lift: U = " + U + ", of " + F2));
        return U;
    }

    /*
     * WARNING - void declaration
     */
    public static <MOD extends GcdRingElem<MOD> & Modular> List<GenPolynomial<MOD>> liftHenselFull(GenPolynomial<BigInteger> C, List<GenPolynomial<MOD>> F2, List<BigInteger> V, long k, List<GenPolynomial<BigInteger>> G) throws NoLiftingException {
        void var26_31;
        if (F2 == null || F2.size() == 0) {
            return new ArrayList<GenPolynomial<MOD>>();
        }
        GenPolynomialRing pkfac = F2.get((int)0).ring;
        RingFactory cfac = pkfac.coFac;
        ModularRingFactory pcfac = (ModularRingFactory)cfac;
        BigInteger p = pcfac.getIntegerModul();
        BigInteger q = Power.positivePower(p, k);
        Iterable<ModLong> mcfac = ModLongRing.MAX_LONG.compareTo(q.getVal()) > 0 ? new ModLongRing(q.getVal()) : new ModIntegerRing(q.getVal());
        GenPolynomialRing<ModLong> qcfac = new GenPolynomialRing<ModLong>((RingFactory<ModLong>)((Object)mcfac), C.ring);
        GenPolynomial<ModLong> Cq = PolyUtil.fromIntegerCoefficients(qcfac, C);
        GenPolynomialRing<ModLong> gcfac = new GenPolynomialRing<ModLong>((RingFactory<ModLong>)((Object)mcfac), G.get((int)0).ring);
        ArrayList<GenPolynomial<ModLong>> GQ = new ArrayList<GenPolynomial<ModLong>>();
        boolean allOnes = true;
        for (GenPolynomial<BigInteger> g : G) {
            if (!g.isONE()) {
                allOnes = false;
            }
            GenPolynomial<ModLong> gq = PolyUtil.fromIntegerCoefficients(gcfac, g);
            GQ.add(gq);
        }
        GenPolynomialRing<ModLong> pf = qcfac;
        GenPolynomial<GcdRingElem<ModLong>> ap = Cq;
        for (int j = C.ring.nvar; j > 1; --j) {
            pf = pf.contract(1);
            GcdRingElem vp = (GcdRingElem)mcfac.fromInteger(V.get(C.ring.nvar - j).getVal());
            ap = PolyUtil.evaluateMain(pf, ap, vp);
        }
        GenPolynomial<ModLong> Cq1 = ap;
        if (Cq1.isZERO()) {
            throw new NoLiftingException("C mod (I, p^k) == 0: " + C);
        }
        GenPolynomialRing<BigInteger> ifac = new GenPolynomialRing<BigInteger>(new BigInteger(), pf);
        AbelianGroupElem<GenPolynomial<BigInteger>> Ci = PolyUtil.integerFromModularCoefficients(ifac, Cq1);
        GreatestCommonDivisorAbstract<BigInteger> ufd = GCDFactory.getImplementation(new BigInteger());
        Ci = ((GenPolynomial)Ci).abs();
        BigInteger cCi = ufd.baseContent((GenPolynomial<BigInteger>)Ci);
        Ci = ((GenPolynomial)Ci).divide((GenPolynomial<BigInteger>)((Object)cCi));
        ArrayList<GenPolynomial<GcdRingElem>> GP = new ArrayList<GenPolynomial<GcdRingElem>>();
        for (GenPolynomial<GcdRingElem> genPolynomial : GQ) {
            GenPolynomialRing<ModLong> gf = gcfac;
            GenPolynomial<GcdRingElem> gp = genPolynomial;
            for (int j = gcfac.nvar; j > 1; --j) {
                gf = gf.contract(1);
                GcdRingElem vp = (GcdRingElem)mcfac.fromInteger(V.get(gcfac.nvar - j).getVal());
                gp = PolyUtil.evaluateMain(gf, gp, vp);
            }
            GP.add(gp);
        }
        BigInteger gi0 = (BigInteger)((GenPolynomial)Ci).leadingBaseCoefficient();
        Object var26_28 = null;
        if (gi0.isONE()) {
            List<GenPolynomial<MOD>> list = HenselUtil.liftHenselMonic(Ci, F2, k);
        } else {
            List<GenPolynomial<MOD>> list = HenselUtil.liftHensel(Ci, F2, k, gi0);
        }
        logger.info((Object)("univariate lift: Ci = " + Ci + ", F = " + F2 + ", U1 = " + var26_31));
        List<GenPolynomial<BigInteger>> U1i = PolyUtil.integerFromModularCoefficients(((GenPolynomial)Ci).ring, var26_31);
        boolean t = HenselUtil.isHenselLift(Ci, q, p, U1i);
        if (!t) {
            throw new NoLiftingException("Ci = " + Ci + ", U1i = " + U1i);
        }
        GcdRingElem cC = (GcdRingElem)mcfac.fromInteger(cCi.getVal());
        List U1f = PolyUtil.fromIntegerCoefficients(F2.get((int)0).ring, U1i);
        ArrayList<GenPolynomial<MOD>> U1s = new ArrayList<GenPolynomial<MOD>>(var26_31.size());
        int j = 0;
        int s = 0;
        for (GenPolynomial genPolynomial : var26_31) {
            void var35_43;
            void var35_46;
            AbelianGroupElem uf = U1f.get(j);
            GenPolynomial<MOD> f = F2.get(j);
            GenPolynomial<BigInteger> ui = U1i.get(j);
            GenPolynomial<BigInteger> gi = G.get(j);
            if (ui.signum() != gi.signum()) {
                AbelianGroupElem abelianGroupElem = genPolynomial.negate();
                uf = ((GenPolynomial)uf).negate();
                ++s;
            }
            ++j;
            if (((GenPolynomial)uf).isConstant()) {
                GenPolynomial<GcdRingElem> genPolynomial3 = var35_46.monic();
                genPolynomial3 = genPolynomial3.multiply(cC);
                cC = cC.divide(cC);
            } else {
                GcdRingElem x = (GcdRingElem)((GcdRingElem)f.leadingBaseCoefficient()).divide(((GenPolynomial)uf).leadingBaseCoefficient());
                if (!x.isONE()) {
                    GcdRingElem xq = (GcdRingElem)mcfac.fromInteger(((Modular)((Object)x)).getSymmetricInteger().getVal());
                    GenPolynomial<GcdRingElem> genPolynomial4 = var35_46.multiply(xq);
                    cC = cC.divide(xq);
                }
            }
            U1s.add((GenPolynomial<MOD>)var35_43);
        }
        if (!cC.isONE()) {
            throw new NoLiftingException("s = " + s + ", Ci = " + Ci + ", U1i = " + U1i + ", cC = " + cC);
        }
        ArrayList<GenPolynomial<MOD>> arrayList = U1s;
        U1i = PolyUtil.integerFromModularCoefficients(((GenPolynomial)Ci).ring, arrayList);
        U1f = PolyUtil.fromIntegerCoefficients(F2.get((int)0).ring, U1i);
        if (!F2.equals(U1f)) {
            System.out.println("F   = " + F2);
            System.out.println("U1f = " + U1f);
            throw new NoLiftingException("F = " + F2 + ", U1f = " + U1f);
        }
        logger.info((Object)("multivariate lift: U1 = " + arrayList));
        List<GenPolynomial<Object>> U = null;
        U = allOnes ? HenselMultUtil.liftHenselMonic(C, Cq, arrayList, V, k) : HenselMultUtil.liftHensel(C, Cq, arrayList, V, k, G);
        logger.info((Object)("multivariate lift: C = " + C + ", U1 = " + arrayList + ", U = " + U));
        return U;
    }
}

