/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.BigInteger;
import edu.jas.arith.Combinatoric;
import edu.jas.arith.ModIntegerRing;
import edu.jas.arith.ModLong;
import edu.jas.arith.ModLongRing;
import edu.jas.arith.Modular;
import edu.jas.arith.ModularRingFactory;
import edu.jas.arith.PrimeList;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.Power;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import edu.jas.ufd.GreatestCommonDivisorModEval;
import edu.jas.ufd.GreatestCommonDivisorSimple;
import edu.jas.ufd.GreatestCommonDivisorSubres;
import org.apache.log4j.Logger;

public class GreatestCommonDivisorModular<MOD extends GcdRingElem<MOD> & Modular>
extends GreatestCommonDivisorAbstract<BigInteger> {
    private static final Logger logger = Logger.getLogger(GreatestCommonDivisorModular.class);
    private final boolean debug = logger.isDebugEnabled();
    protected final GreatestCommonDivisorAbstract<MOD> mufd;
    protected final GreatestCommonDivisorAbstract<BigInteger> iufd = new GreatestCommonDivisorSubres<BigInteger>();

    public GreatestCommonDivisorModular() {
        this(false);
    }

    public GreatestCommonDivisorModular(boolean simple) {
        this.mufd = simple ? new GreatestCommonDivisorSimple<MOD>() : new GreatestCommonDivisorModEval();
    }

    @Override
    public GenPolynomial<BigInteger> baseGcd(GenPolynomial<BigInteger> P, GenPolynomial<BigInteger> S) {
        return this.iufd.baseGcd(P, S);
    }

    @Override
    public GenPolynomial<GenPolynomial<BigInteger>> recursiveUnivariateGcd(GenPolynomial<GenPolynomial<BigInteger>> P, GenPolynomial<GenPolynomial<BigInteger>> S) {
        return this.iufd.recursiveUnivariateGcd(P, S);
    }

    @Override
    public GenPolynomial<BigInteger> gcd(GenPolynomial<BigInteger> P, GenPolynomial<BigInteger> S) {
        BigInteger bn;
        AbelianGroupElem<GenPolynomial<BigInteger>> q;
        AbelianGroupElem<GenPolynomial<BigInteger>> r;
        if (S == null || S.isZERO()) {
            return P;
        }
        if (P == null || P.isZERO()) {
            return S;
        }
        GenPolynomialRing<BigInteger> fac = P.ring;
        if (fac.nvar <= 1) {
            GenPolynomial<BigInteger> T = this.baseGcd(P, S);
            return T;
        }
        long e = P.degree(0);
        long f = S.degree(0);
        if (f > e) {
            r = P;
            q = S;
            long g = f;
            f = e;
            e = g;
        } else {
            q = P;
            r = S;
        }
        if (this.debug) {
            logger.debug((Object)("degrees: e = " + e + ", f = " + f));
        }
        r = ((GenPolynomial)r).abs();
        q = ((GenPolynomial)q).abs();
        BigInteger a = this.baseContent(r);
        BigInteger b = this.baseContent(q);
        BigInteger c = this.gcd(a, b);
        r = this.divide(r, a);
        q = this.divide(q, b);
        if (((GenPolynomial)r).isONE()) {
            return ((GenPolynomial)r).multiply((GenPolynomial<BigInteger>)((Object)c));
        }
        if (((GenPolynomial)q).isONE()) {
            return ((GenPolynomial)q).multiply((GenPolynomial<BigInteger>)((Object)c));
        }
        BigInteger ac = (BigInteger)((GenPolynomial)r).leadingBaseCoefficient();
        BigInteger bc = (BigInteger)((GenPolynomial)q).leadingBaseCoefficient();
        BigInteger cc = this.gcd(ac, bc);
        BigInteger an = (BigInteger)((GenPolynomial)r).maxNorm();
        BigInteger n = an.compareTo(bn = (BigInteger)((GenPolynomial)q).maxNorm()) < 0 ? bn : an;
        n = n.multiply(cc).multiply(n.fromInteger(2L));
        ExpVector rdegv = ((GenPolynomial)r).degreeVector();
        ExpVector qdegv = ((GenPolynomial)q).degreeVector();
        BigInteger af = an.multiply(PolyUtil.factorBound(rdegv));
        BigInteger bf = bn.multiply(PolyUtil.factorBound(qdegv));
        BigInteger cf = af.compareTo(bf) < 0 ? bf : af;
        cf = cf.multiply(cc.multiply(cc.fromInteger(8L)));
        PrimeList primes = new PrimeList();
        int pn = 10;
        ExpVector wdegv = rdegv.subst(0, rdegv.getVal(0) + 1L);
        Iterable<ModLong> cofacM = null;
        GenPolynomialRing<ModLong> rfac = null;
        int i = 0;
        BigInteger M = null;
        BigInteger cfe = null;
        GenPolynomial<ModLong> cp = null;
        GenPolynomial<ModLong> cm = null;
        GenPolynomial<BigInteger> cpi = null;
        if (this.debug) {
            logger.debug((Object)("c = " + c));
            logger.debug((Object)("cc = " + cc));
            logger.debug((Object)("n  = " + n));
            logger.debug((Object)("cf = " + cf));
            logger.info((Object)("wdegv = " + wdegv));
        }
        for (java.math.BigInteger p : primes) {
            GenPolynomial<ModLong> rm;
            GenPolynomialRing<ModLong> mfac;
            GenPolynomial<ModLong> qm;
            if (p.longValue() == 2L) continue;
            if (++i >= pn) {
                logger.warn((Object)("prime list exhausted, pn = " + pn));
                return this.iufd.gcd(P, S);
            }
            Iterable<ModLong> cofac = ModLongRing.MAX_LONG.compareTo(p) > 0 ? new ModLongRing(p, true) : new ModIntegerRing(p, true);
            GcdRingElem nf = (GcdRingElem)cofac.fromInteger(cc.getVal());
            if (nf.isZERO() || (qm = PolyUtil.fromIntegerCoefficients(mfac = new GenPolynomialRing<ModLong>((RingFactory<ModLong>)((Object)cofac), fac.nvar, fac.tord, fac.getVars()), q)).isZERO() || !qm.degreeVector().equals(qdegv) || (rm = PolyUtil.fromIntegerCoefficients(mfac, r)).isZERO() || !rm.degreeVector().equals(rdegv)) continue;
            if (this.debug) {
                logger.info((Object)("cofac = " + cofac.getIntegerModul()));
            }
            if ((cm = this.mufd.gcd(rm, qm)).isConstant()) {
                logger.debug((Object)("cm, constant = " + cm));
                return ((GenPolynomial)fac.getONE()).multiply(c);
            }
            ExpVector mdegv = cm.degreeVector();
            if (wdegv.equals(mdegv)) {
                if (M != null && M.compareTo(cfe) > 0) {
                    System.out.println("M > cfe: " + M + " > " + cfe);
                }
            } else {
                boolean ok = false;
                if (wdegv.multipleOf(mdegv)) {
                    M = null;
                    ok = true;
                }
                if (mdegv.multipleOf(wdegv)) continue;
                if (!ok) {
                    M = null;
                    continue;
                }
            }
            cm = cm.multiply((ModLong)nf);
            if (M == null) {
                M = new BigInteger(p);
                cofacM = cofac;
                rfac = mfac;
                cp = cm;
                wdegv = wdegv.gcd(mdegv);
                cfe = cf;
                for (int k = 0; k < wdegv.length(); ++k) {
                    cfe = cfe.multiply(new BigInteger(wdegv.getVal(k) + 1L));
                }
            } else {
                BigInteger Mp = M;
                GcdRingElem mi = (GcdRingElem)cofac.fromInteger(Mp.getVal());
                mi = (GcdRingElem)mi.inverse();
                cofacM = ModLongRing.MAX_LONG.compareTo((M = M.multiply(new BigInteger(p))).getVal()) > 0 ? new ModLongRing(M.getVal()) : new ModIntegerRing(M.getVal());
                rfac = new GenPolynomialRing<ModLong>((RingFactory<ModLong>)((Object)cofacM), fac);
                if (!cofac.getClass().equals(cofacM.getClass())) {
                    logger.info((Object)("adjusting coefficents: cofacM = " + cofacM.getClass() + ", cofacP = " + cofac.getClass()));
                    cofac = new ModIntegerRing(p);
                    mfac = new GenPolynomialRing<ModLong>((RingFactory<ModLong>)((Object)cofac), fac);
                    GenPolynomial<BigInteger> mm = PolyUtil.integerFromModularCoefficients(fac, cm);
                    cm = PolyUtil.fromIntegerCoefficients(mfac, mm);
                    mi = (GcdRingElem)cofac.fromInteger(Mp.getVal());
                    mi = (GcdRingElem)mi.inverse();
                }
                if (!cp.ring.coFac.getClass().equals(cofacM.getClass())) {
                    logger.info((Object)("adjusting coefficents: cofacM = " + cofacM.getClass() + ", cofacM' = " + cp.ring.coFac.getClass()));
                    ModularRingFactory cop = (ModularRingFactory)cp.ring.coFac;
                    cofac = new ModIntegerRing(cop.getIntegerModul().getVal());
                    mfac = new GenPolynomialRing<ModLong>((RingFactory<ModLong>)((Object)cofac), fac);
                    GenPolynomial<BigInteger> mm = PolyUtil.integerFromModularCoefficients(fac, cp);
                    cp = PolyUtil.fromIntegerCoefficients(mfac, mm);
                }
                cp = PolyUtil.chineseRemainder(rfac, cp, mi, cm);
            }
            if (n.compareTo(M) <= 0) break;
            cpi = PolyUtil.integerFromModularCoefficients(fac, cp);
            BigInteger cmn = cpi.sumNorm();
            cmn = cmn.multiply(cmn.fromInteger(4L));
            if (i % 2 == 0 || cp.isZERO()) continue;
            GenPolynomial<BigInteger> x = PolyUtil.integerFromModularCoefficients(fac, cp);
            if (!PolyUtil.baseSparsePseudoRemainder(q, x = this.basePrimitivePart(x)).isZERO() || !PolyUtil.baseSparsePseudoRemainder(r, x).isZERO()) continue;
            logger.info((Object)("done on exact division, #primes = " + i));
            break;
        }
        if (this.debug) {
            logger.info((Object)("done on M = " + M + ", #primes = " + i));
        }
        q = PolyUtil.integerFromModularCoefficients(fac, cp);
        q = this.basePrimitivePart(q);
        return ((GenPolynomial)((GenPolynomial)q).abs()).multiply(c);
    }

    @Override
    public GenPolynomial<BigInteger> baseResultant(GenPolynomial<BigInteger> P, GenPolynomial<BigInteger> S) {
        return this.resultant(P, S);
    }

    @Override
    public GenPolynomial<GenPolynomial<BigInteger>> recursiveUnivariateResultant(GenPolynomial<GenPolynomial<BigInteger>> P, GenPolynomial<GenPolynomial<BigInteger>> S) {
        return this.recursiveResultant(P, S);
    }

    @Override
    public GenPolynomial<BigInteger> resultant(GenPolynomial<BigInteger> P, GenPolynomial<BigInteger> S) {
        GenPolynomial<BigInteger> q;
        GenPolynomial<BigInteger> r;
        if (S == null || S.isZERO()) {
            return S;
        }
        if (P == null || P.isZERO()) {
            return P;
        }
        GenPolynomialRing<BigInteger> fac = P.ring;
        long e = P.degree(0);
        long f = S.degree(0);
        if (f > e) {
            r = P;
            q = S;
            long g = f;
            f = e;
            e = g;
        } else {
            q = P;
            r = S;
        }
        BigInteger an = r.maxNorm();
        BigInteger bn = q.maxNorm();
        an = Power.power(fac.coFac, an, f);
        bn = Power.power(fac.coFac, bn, e);
        BigInteger cn = Combinatoric.factorial(e + f);
        BigInteger n = cn.multiply(an).multiply(bn);
        ExpVector rdegv = r.leadingExpVector();
        ExpVector qdegv = q.leadingExpVector();
        PrimeList primes = new PrimeList();
        int pn = 30;
        Iterable<ModLong> cofacM = null;
        GenPolynomialRing<ModLong> rfac = null;
        int i = 0;
        BigInteger M = null;
        GenPolynomial<ModLong> cp = null;
        GenPolynomial<ModLong> cm = null;
        if (this.debug) {
            logger.debug((Object)("an  = " + an));
            logger.debug((Object)("bn  = " + bn));
            logger.debug((Object)("e+f = " + (e + f)));
            logger.debug((Object)("cn  = " + cn));
            logger.info((Object)("n     = " + n));
        }
        for (java.math.BigInteger p : primes) {
            if (p.longValue() == 2L) continue;
            if (++i >= pn) {
                logger.warn((Object)("prime list exhausted, pn = " + pn));
                return this.iufd.resultant(P, S);
            }
            Iterable<ModLong> cofac = ModLongRing.MAX_LONG.compareTo(p) > 0 ? new ModLongRing(p, true) : new ModIntegerRing(p, true);
            GenPolynomialRing<ModLong> mfac = new GenPolynomialRing<ModLong>((RingFactory<ModLong>)((Object)cofac), fac);
            GenPolynomial<ModLong> qm = PolyUtil.fromIntegerCoefficients(mfac, q);
            if (qm.isZERO() || !qm.leadingExpVector().equals(qdegv)) {
                if (!this.debug) continue;
                logger.info((Object)("unlucky prime = " + cofac.getIntegerModul() + ", degv = " + qm.leadingExpVector()));
                continue;
            }
            GenPolynomial<ModLong> rm = PolyUtil.fromIntegerCoefficients(mfac, r);
            if (rm.isZERO() || !rm.leadingExpVector().equals(rdegv)) {
                if (!this.debug) continue;
                logger.info((Object)("unlucky prime = " + cofac.getIntegerModul() + ", degv = " + rm.leadingExpVector()));
                continue;
            }
            logger.info((Object)("lucky prime = " + cofac.getIntegerModul()));
            cm = this.mufd.resultant(qm, rm);
            if (this.debug) {
                logger.info((Object)("res_p = " + cm));
            }
            if (M == null) {
                M = new BigInteger(p);
                cofacM = cofac;
                cp = cm;
            } else {
                BigInteger Mp = M;
                GcdRingElem mi = (GcdRingElem)cofac.fromInteger(Mp.getVal());
                mi = (GcdRingElem)mi.inverse();
                cofacM = ModLongRing.MAX_LONG.compareTo((M = M.multiply(new BigInteger(p))).getVal()) > 0 ? new ModLongRing(M.getVal()) : new ModIntegerRing(M.getVal());
                rfac = new GenPolynomialRing<ModLong>((RingFactory<ModLong>)((Object)cofacM), fac);
                if (!cofac.getClass().equals(cofacM.getClass())) {
                    logger.info((Object)("adjusting coefficents: cofacM = " + cofacM.getClass() + ", cofacP = " + cofac.getClass()));
                    cofac = new ModIntegerRing(p);
                    mfac = new GenPolynomialRing<ModLong>((RingFactory<ModLong>)((Object)cofac), fac);
                    GenPolynomial<BigInteger> mm = PolyUtil.integerFromModularCoefficients(fac, cm);
                    cm = PolyUtil.fromIntegerCoefficients(mfac, mm);
                    mi = (GcdRingElem)cofac.fromInteger(Mp.getVal());
                    mi = (GcdRingElem)mi.inverse();
                }
                if (!cp.ring.coFac.getClass().equals(cofacM.getClass())) {
                    logger.info((Object)("adjusting coefficents: cofacM = " + cofacM.getClass() + ", cofacM' = " + cp.ring.coFac.getClass()));
                    ModularRingFactory cop = (ModularRingFactory)cp.ring.coFac;
                    cofac = new ModIntegerRing(cop.getIntegerModul().getVal());
                    mfac = new GenPolynomialRing<ModLong>((RingFactory<ModLong>)((Object)cofac), fac);
                    GenPolynomial<BigInteger> mm = PolyUtil.integerFromModularCoefficients(fac, cp);
                    cp = PolyUtil.fromIntegerCoefficients(mfac, mm);
                }
                cp = PolyUtil.chineseRemainder(rfac, cp, mi, cm);
            }
            if (n.compareTo(M) > 0) continue;
            break;
        }
        if (this.debug) {
            logger.info((Object)("done on M = " + M + ", #primes = " + i));
        }
        q = PolyUtil.integerFromModularCoefficients(fac, cp);
        return q;
    }
}

