/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolynomialList;
import edu.jas.structure.GcdRingElem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Factors<C extends GcdRingElem<C>>
implements Comparable<Factors<C>>,
Serializable {
    public final GenPolynomial<C> poly;
    public final AlgebraicNumberRing<C> afac;
    public final GenPolynomial<AlgebraicNumber<C>> apoly;
    public final List<GenPolynomial<AlgebraicNumber<C>>> afactors;
    public final List<Factors<AlgebraicNumber<C>>> arfactors;

    public Factors(GenPolynomial<C> p) {
        this(p, null, null, null, null);
    }

    public Factors(GenPolynomial<C> p, AlgebraicNumberRing<C> af, GenPolynomial<AlgebraicNumber<C>> ap, List<GenPolynomial<AlgebraicNumber<C>>> afact) {
        this(p, af, ap, afact, null);
    }

    public Factors(GenPolynomial<C> p, AlgebraicNumberRing<C> af, GenPolynomial<AlgebraicNumber<C>> ap, List<GenPolynomial<AlgebraicNumber<C>>> afact, List<Factors<AlgebraicNumber<C>>> arfact) {
        this.poly = p;
        this.afac = af;
        this.apoly = ap;
        this.afactors = afact;
        this.arfactors = arfact;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.poly.toString());
        if (this.afac == null) {
            return sb.toString();
        }
        sb.append(" = ");
        boolean first = true;
        for (GenPolynomial<AlgebraicNumber<C>> genPolynomial : this.afactors) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(genPolynomial.toString());
        }
        sb.append("\n  ## over " + this.afac.toString() + "\n");
        if (this.arfactors == null) {
            return sb.toString();
        }
        first = true;
        for (Factors factors : this.arfactors) {
            if (first) {
                first = false;
            } else {
                sb.append(",\n");
            }
            sb.append(factors.toString());
        }
        return sb.toString();
    }

    public String toScript() {
        StringBuffer sb = new StringBuffer();
        if (this.afac == null) {
            return sb.toString();
        }
        boolean first = true;
        for (GenPolynomial<AlgebraicNumber<C>> genPolynomial : this.afactors) {
            if (first) {
                first = false;
            } else {
                sb.append("\n * ");
            }
            sb.append(genPolynomial.toScript());
        }
        sb.append("   #:: " + this.afac.toScript() + "");
        if (this.arfactors == null) {
            return sb.toString();
        }
        for (Factors factors : this.arfactors) {
            if (first) {
                first = false;
            } else {
                sb.append("\n * ");
            }
            sb.append(factors.toScript());
        }
        return sb.toString();
    }

    public int hashCode() {
        int h = this.poly.hashCode();
        if (this.afac == null) {
            return h;
        }
        h <<= 27;
        h += this.afac.hashCode();
        if (this.afactors != null) {
            h <<= 27;
            h += this.afactors.hashCode();
        }
        if (this.arfactors != null) {
            h <<= 27;
            h += this.arfactors.hashCode();
        }
        return h;
    }

    public boolean equals(Object B) {
        if (B == null) {
            return false;
        }
        if (!(B instanceof Factors)) {
            return false;
        }
        Factors a = (Factors)B;
        return this.compareTo(a) == 0;
    }

    @Override
    public int compareTo(Factors<C> facs) {
        int s = this.poly.compareTo(facs.poly);
        if (s != 0) {
            return s;
        }
        if (this.afac == null) {
            return -1;
        }
        if (facs.afac == null) {
            return 1;
        }
        s = this.afac.modul.compareTo(facs.afac.modul);
        if (s != 0) {
            return s;
        }
        GenPolynomialRing ar = this.afactors.get((int)0).ring;
        PolynomialList ap = new PolynomialList(ar, this.afactors);
        GenPolynomialRing br = facs.afactors.get((int)0).ring;
        PolynomialList bp = new PolynomialList(br, facs.afactors);
        s = ap.compareTo(bp);
        if (s != 0) {
            return s;
        }
        if (this.arfactors == null && facs.arfactors == null) {
            return 0;
        }
        if (this.arfactors == null) {
            return -1;
        }
        if (facs.arfactors == null) {
            return 1;
        }
        int i = 0;
        for (Factors<AlgebraicNumber<AlgebraicNumber<C>>> factors : this.arfactors) {
            if (i >= facs.arfactors.size()) {
                return 1;
            }
            Factors<AlgebraicNumber<C>> brp = facs.arfactors.get(i);
            s = factors.compareTo(brp);
            if (s != 0) {
                return s;
            }
            ++i;
        }
        if (i < facs.arfactors.size()) {
            return -1;
        }
        return 0;
    }

    public AlgebraicNumberRing<C> findExtensionField() {
        if (this.afac == null) {
            return null;
        }
        if (this.arfactors == null) {
            return this.afac;
        }
        AlgebraicNumberRing<Object> arr = this.afac;
        int depth = 1;
        for (Factors<AlgebraicNumber<C>> af : this.arfactors) {
            int d;
            AlgebraicNumberRing<AlgebraicNumber<C>> aring = af.findExtensionField();
            if (aring == null || (d = aring.depth()) <= depth) continue;
            depth = d;
            arr = aring;
        }
        return arr;
    }

    public List<GenPolynomial<AlgebraicNumber<C>>> getFactors() {
        ArrayList<GenPolynomial<AlgebraicNumber<C>>> af = new ArrayList<GenPolynomial<AlgebraicNumber<C>>>();
        if (this.afac == null) {
            return af;
        }
        af.addAll(this.afactors);
        if (this.arfactors == null) {
            return af;
        }
        for (Factors<AlgebraicNumber<C>> arp : this.arfactors) {
            af.add(arp.poly);
        }
        return af;
    }

    public Factors<AlgebraicNumber<C>> getFactor(GenPolynomial<AlgebraicNumber<C>> p) {
        if (this.afac == null) {
            return null;
        }
        for (Factors<AlgebraicNumber<C>> arp : this.arfactors) {
            if (!p.equals(arp.poly)) continue;
            return arp;
        }
        return null;
    }
}

