/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.BigInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.arith.ModLong;
import edu.jas.arith.ModLongRing;
import edu.jas.arith.Modular;
import edu.jas.arith.ModularRingFactory;
import edu.jas.arith.PrimeList;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.OptimizedPolynomialList;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.TermOrderOptimization;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.MonoidElem;
import edu.jas.structure.Power;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.FactorAbstract;
import edu.jas.ufd.FactorFactory;
import edu.jas.ufd.GCDFactory;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import edu.jas.ufd.HenselApprox;
import edu.jas.ufd.HenselMultUtil;
import edu.jas.ufd.HenselUtil;
import edu.jas.ufd.NoLiftingException;
import edu.jas.ufd.TrialParts;
import edu.jas.util.KsubSet;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import org.apache.log4j.Logger;

public class FactorInteger<MOD extends GcdRingElem<MOD> & Modular>
extends FactorAbstract<BigInteger> {
    private static final Logger logger = Logger.getLogger(FactorInteger.class);
    private final boolean debug = logger.isDebugEnabled();
    protected final FactorAbstract<MOD> mfactor;
    protected final GreatestCommonDivisorAbstract<MOD> mengine;

    public FactorInteger() {
        this(BigInteger.ONE);
    }

    public FactorInteger(RingFactory<BigInteger> cfac) {
        super(cfac);
        ModularRingFactory mcofac = new ModLongRing(13L, true);
        this.mfactor = FactorFactory.getImplementation(mcofac);
        this.mengine = GCDFactory.getImplementation(mcofac);
    }

    @Override
    public List<GenPolynomial<BigInteger>> baseFactorsSquarefree(GenPolynomial<BigInteger> P) {
        ArrayList factors;
        block30: {
            if (P == null) {
                throw new IllegalArgumentException(this.getClass().getName() + " P == null");
            }
            factors = new ArrayList<GenPolynomial<BigInteger>>();
            if (P.isZERO()) {
                return factors;
            }
            if (P.isONE()) {
                factors.add(P);
                return factors;
            }
            GenPolynomialRing pfac = P.ring;
            if (pfac.nvar > 1) {
                throw new IllegalArgumentException(this.getClass().getName() + " only for univariate polynomials");
            }
            if (!this.engine.baseContent(P).isONE()) {
                throw new IllegalArgumentException(this.getClass().getName() + " P not primitive");
            }
            if (P.degree(0) <= 1L) {
                factors.add(P);
                return factors;
            }
            BigInteger an = P.maxNorm();
            BigInteger ac = P.leadingBaseCoefficient();
            ExpVector degv = P.degreeVector();
            int degi = (int)P.degree(0);
            BigInteger M = an.multiply(PolyUtil.factorBound(degv));
            M = M.multiply(ac.abs().multiply(ac.fromInteger(8L)));
            PrimeList primes = new PrimeList(PrimeList.Range.small);
            int pn = 30;
            Iterable<ModLong> cofac = null;
            GenPolynomial<MonoidElem> am = null;
            GenPolynomialRing<ModLong> mfac = null;
            int TT = 5;
            List[] modfac = new List[5];
            List[] intfac = new List[5];
            BigInteger[] plist = new BigInteger[5];
            List mlist = null;
            Object ilist = null;
            int i = 0;
            if (this.debug) {
                logger.debug((Object)("an  = " + an));
                logger.debug((Object)("ac  = " + ac));
                logger.debug((Object)("M   = " + M));
                logger.info((Object)("degv = " + degv));
            }
            Iterator<java.math.BigInteger> pit = primes.iterator();
            pit.next();
            pit.next();
            MonoidElem nf = null;
            for (int k = 0; k < 5; ++k) {
                if (k == 4) {
                    primes = new PrimeList(PrimeList.Range.medium);
                    pit = primes.iterator();
                }
                if (k == 6) {
                    primes = new PrimeList(PrimeList.Range.large);
                    pit = primes.iterator();
                }
                while (pit.hasNext()) {
                    java.math.BigInteger p = pit.next();
                    if (++i >= pn) {
                        logger.error((Object)("prime list exhausted, pn = " + pn));
                        throw new ArithmeticException("prime list exhausted");
                    }
                    cofac = ModLongRing.MAX_LONG.compareTo(p) > 0 ? new ModLongRing(p, true) : new ModIntegerRing(p, true);
                    logger.info((Object)("prime = " + cofac));
                    nf = (GcdRingElem)cofac.fromInteger(ac.getVal());
                    if (nf.isZERO()) {
                        logger.info((Object)("unlucky prime (nf) = " + p));
                        continue;
                    }
                    mfac = new GenPolynomialRing<ModLong>((RingFactory<ModLong>)((Object)cofac), pfac);
                    am = PolyUtil.fromIntegerCoefficients(mfac, P);
                    if (!am.degreeVector().equals(degv)) {
                        logger.info((Object)("unlucky prime (deg) = " + p));
                        continue;
                    }
                    GenPolynomial<MonoidElem> ap = PolyUtil.baseDeriviative(am);
                    if (ap.isZERO()) {
                        logger.info((Object)("unlucky prime (a')= " + p));
                        continue;
                    }
                    GenPolynomial<MonoidElem> g = this.mengine.baseGcd(am, ap);
                    if (!g.isONE()) continue;
                    logger.info((Object)("**lucky prime = " + p));
                    break;
                }
                if (!nf.isONE()) {
                    am = am.divide(nf);
                }
                mlist = this.mfactor.baseFactorsSquarefree(am);
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("modlist  = " + mlist));
                }
                if (mlist.size() <= 1) {
                    factors.add(P);
                    return factors;
                }
                if (!nf.isONE()) {
                    GenPolynomial<MonoidElem> mp = mfac.getONE();
                    mp = mp.multiply(nf);
                    mlist.add(0, mp);
                }
                modfac[k] = mlist;
                plist[k] = cofac.getIntegerModul();
            }
            int min = Integer.MAX_VALUE;
            BitSet AD = null;
            for (int k = 0; k < 5; ++k) {
                List<ExpVector> ev = PolyUtil.leadingExpVector(modfac[k]);
                BitSet D2 = this.factorDegrees(ev, degi);
                if (AD == null) {
                    AD = D2;
                } else {
                    AD.and(D2);
                }
                int s = modfac[k].size();
                logger.info((Object)("mod(" + plist[k] + ") #s = " + s + ", D = " + D2));
                if (s >= min) continue;
                min = s;
                mlist = modfac[k];
            }
            logger.info((Object)("min = " + min + ", AD = " + AD));
            if (mlist.size() <= 1) {
                logger.info((Object)"mlist.size() = 1");
                factors.add(P);
                return factors;
            }
            if (AD.cardinality() <= 2) {
                logger.info((Object)("degree set cardinality = " + AD.cardinality()));
                factors.add(P);
                return factors;
            }
            boolean allLists = false;
            if (this.debug) {
                logger.info((Object)("lifting shortest from " + mlist));
            }
            if (P.leadingBaseCoefficient().isONE()) {
                long t = System.currentTimeMillis();
                try {
                    mlist = PolyUtil.monic(mlist);
                    factors = this.searchFactorsMonic(P, M, mlist, AD);
                    t = System.currentTimeMillis() - t;
                    if (!this.debug) break block30;
                    t = System.currentTimeMillis();
                    List<GenPolynomial<BigInteger>> fnm = this.searchFactorsNonMonic(P, M, mlist, AD);
                    t = System.currentTimeMillis() - t;
                    System.out.println("non monic time = " + t);
                    if (!factors.equals(fnm)) {
                        System.out.println("monic factors     = " + factors);
                        System.out.println("non monic factors = " + fnm);
                    }
                }
                catch (RuntimeException e) {
                    t = System.currentTimeMillis();
                    factors = this.searchFactorsNonMonic(P, M, mlist, AD);
                    t = System.currentTimeMillis() - t;
                }
            } else {
                long t = System.currentTimeMillis();
                factors = this.searchFactorsNonMonic(P, M, mlist, AD);
                t = System.currentTimeMillis() - t;
            }
        }
        return this.normalizeFactorization(factors);
    }

    public BitSet factorDegrees(List<ExpVector> E2, int deg) {
        BitSet D2 = new BitSet(deg + 1);
        D2.set(0);
        for (ExpVector e : E2) {
            int i = (int)e.getVal(0);
            BitSet s = new BitSet(deg + 1);
            for (int k = 0; k < deg + 1 - i; ++k) {
                s.set(i + k, D2.get(k));
            }
            D2.or(s);
        }
        return D2;
    }

    public static <C extends RingElem<C>> long degreeSum(List<GenPolynomial<C>> L) {
        long s = 0L;
        for (GenPolynomial<C> p : L) {
            ExpVector e = p.leadingExpVector();
            long d = e.getVal(0);
            s += d;
        }
        return s;
    }

    List<GenPolynomial<BigInteger>> searchFactorsMonic(GenPolynomial<BigInteger> C, BigInteger M, List<GenPolynomial<MOD>> F2, BitSet D2) {
        List<GenPolynomial<Object>> lift;
        if (C == null || C.isZERO() || F2 == null || F2.size() == 0) {
            throw new IllegalArgumentException("C must be nonzero and F must be nonempty");
        }
        GenPolynomialRing<BigInteger> pfac = C.ring;
        if (pfac.nvar != 1) {
            throw new IllegalArgumentException("polynomial ring not univariate");
        }
        ArrayList factors = new ArrayList(F2.size());
        List<GenPolynomial<MOD>> mlist = F2;
        GenPolynomial<MOD> ct = mlist.get(0);
        if (ct.isConstant()) {
            mlist.remove(ct);
            if (mlist.size() <= 1) {
                factors.add(C);
                return factors;
            }
        }
        ModularRingFactory mcfac = (ModularRingFactory)ct.ring.coFac;
        BigInteger m = mcfac.getIntegerModul();
        long k = 1L;
        BigInteger pi = m;
        while (pi.compareTo(M) < 0) {
            ++k;
            pi = pi.multiply(m);
        }
        logger.info((Object)("p^k = " + m + "^" + k));
        GenPolynomial<BigInteger> PP = C;
        GenPolynomial<BigInteger> P = C;
        try {
            lift = HenselUtil.liftHenselMonic(PP, mlist, k);
        }
        catch (NoLiftingException e) {
            throw new RuntimeException(e);
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("lifted modlist = " + lift));
        }
        GenPolynomialRing mpfac = lift.get((int)0).ring;
        int dl = (lift.size() + 1) / 2;
        GenPolynomial<BigInteger> u = PP;
        long deg = (u.degree(0) + 1L) / 2L;
        block3: for (int j = 1; j <= dl; ++j) {
            KsubSet<GenPolynomial<MOD>> ps = new KsubSet<GenPolynomial<MOD>>(lift, j);
            for (List list : ps) {
                if (!D2.get((int)FactorInteger.degreeSum(list))) {
                    logger.info((Object)("skipped by degree set " + D2 + ", deg = " + FactorInteger.degreeSum(list)));
                    continue;
                }
                GenPolynomial mtrial = Power.multiply(mpfac, list);
                if (mtrial.degree(0) > deg) {
                    logger.info((Object)("degree " + mtrial.degree(0) + " > deg " + deg));
                }
                GenPolynomial<BigInteger> trial = PolyUtil.integerFromModularCoefficients(pfac, mtrial);
                if (!PolyUtil.baseSparsePseudoRemainder(u, trial = this.engine.basePrimitivePart(trial)).isZERO()) continue;
                logger.info((Object)("successful trial = " + trial));
                factors.add(trial);
                u = PolyUtil.basePseudoDivide(u, trial);
                lift = FactorInteger.removeOnce(lift, list);
                logger.info((Object)("new lift= " + lift));
                dl = (lift.size() + 1) / 2;
                j = 0;
                continue block3;
            }
        }
        if (!u.isONE() && !u.equals(P)) {
            logger.info((Object)("rest u = " + u));
            factors.add(u);
        }
        if (factors.size() == 0) {
            logger.info((Object)("irred u = " + u));
            factors.add(PP);
        }
        return this.normalizeFactorization(factors);
    }

    List<GenPolynomial<BigInteger>> searchFactorsNonMonic(GenPolynomial<BigInteger> C, BigInteger M, List<GenPolynomial<MOD>> F2, BitSet D2) {
        if (C == null || C.isZERO() || F2 == null || F2.size() == 0) {
            throw new IllegalArgumentException("C must be nonzero and F must be nonempty");
        }
        GenPolynomialRing pfac = C.ring;
        if (pfac.nvar != 1) {
            throw new IllegalArgumentException("polynomial ring not univariate");
        }
        ArrayList factors = new ArrayList(F2.size());
        List<GenPolynomial<Object>> mlist = F2;
        GcdRingElem nf = null;
        GenPolynomial<MOD> ct = mlist.get(0);
        if (ct.isConstant()) {
            nf = (GcdRingElem)ct.leadingBaseCoefficient();
            mlist.remove(ct);
            if (mlist.size() <= 1) {
                factors.add(C);
                return factors;
            }
        } else {
            nf = (GcdRingElem)ct.ring.coFac.getONE();
        }
        GenPolynomialRing mfac = ct.ring;
        GenPolynomial<GcdRingElem> Pm = PolyUtil.fromIntegerCoefficients(mfac, C);
        GenPolynomial<BigInteger> PP = C;
        GenPolynomial<BigInteger> P = C;
        int dl = (mlist.size() + 1) / 2;
        GenPolynomial<BigInteger> u = PP;
        long deg = (u.degree(0) + 1L) / 2L;
        GenPolynomial<GcdRingElem> um = Pm;
        HenselApprox<GcdRingElem> ilist = null;
        block2: for (int j = 1; j <= dl; ++j) {
            KsubSet<GenPolynomial<MOD>> ps = new KsubSet<GenPolynomial<MOD>>(mlist, j);
            for (List list : ps) {
                if (!D2.get((int)FactorInteger.degreeSum(list))) {
                    logger.info((Object)("skipped by degree set " + D2 + ", deg = " + FactorInteger.degreeSum(list)));
                    continue;
                }
                GenPolynomial trial = ((GenPolynomial)mfac.getONE()).multiply(nf);
                for (int kk = 0; kk < list.size(); ++kk) {
                    GenPolynomial fk = list.get(kk);
                    trial = trial.multiply(fk);
                }
                if (trial.degree(0) > deg) {
                    logger.info((Object)("degree > deg " + deg + ", degree = " + trial.degree(0)));
                }
                GenPolynomial<GcdRingElem> cofactor = um.divide(trial);
                try {
                    ilist = HenselUtil.liftHenselQuadratic(PP, M, trial, cofactor);
                }
                catch (NoLiftingException e) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.info((Object)("no liftable factors " + e));
                    continue;
                }
                GenPolynomial<BigInteger> itrial = ilist.A;
                GenPolynomial<BigInteger> icofactor = ilist.B;
                if (logger.isDebugEnabled()) {
                    logger.info((Object)("       modlist = " + trial + ", cofactor " + cofactor));
                    logger.info((Object)("lifted intlist = " + itrial + ", cofactor " + icofactor));
                }
                if (!PolyUtil.baseSparsePseudoRemainder(u, itrial = this.engine.basePrimitivePart(itrial)).isZERO()) continue;
                logger.info((Object)("successful trial = " + itrial));
                factors.add(itrial);
                PP = u = icofactor;
                um = cofactor;
                mlist = FactorInteger.removeOnce(mlist, list);
                logger.info((Object)("new mlist= " + mlist));
                dl = (mlist.size() + 1) / 2;
                j = 0;
                continue block2;
            }
        }
        if (!u.isONE() && !u.equals(P)) {
            logger.info((Object)("rest u = " + u));
            factors.add(u);
        }
        if (factors.size() == 0) {
            logger.info((Object)("irred u = " + PP));
            factors.add(PP);
        }
        return this.normalizeFactorization(factors);
    }

    @Override
    public List<GenPolynomial<BigInteger>> factorsSquarefree(GenPolynomial<BigInteger> P) {
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar <= 1) {
            return this.baseFactorsSquarefree(P);
        }
        ArrayList topt = new ArrayList(1);
        topt.add(P);
        OptimizedPolynomialList opt = TermOrderOptimization.optimizeTermOrder(pfac, topt);
        P = (GenPolynomial)opt.list.get(0);
        logger.info((Object)("optimized polynomial: " + P));
        List<Integer> iperm = TermOrderOptimization.inversePermutation(opt.perm);
        logger.info((Object)("optimize perm: " + opt.perm + ", de-optimize perm: " + iperm));
        ExpVector degv = P.degreeVector();
        int[] donv = degv.dependencyOnVariables();
        List<GenPolynomial<BigInteger>> facs = null;
        if (degv.length() == donv.length) {
            try {
                logger.info((Object)("try factorsSquarefreeHensel: " + P));
                facs = this.factorsSquarefreeHensel(P);
            }
            catch (Exception e) {
                logger.warn((Object)("exception " + e));
            }
        } else {
            GenPolynomial<BigInteger> pu = PolyUtil.removeUnusedUpperVariables(P);
            GenPolynomial pl = PolyUtil.removeUnusedLowerVariables(pu);
            try {
                logger.info((Object)("try factorsSquarefreeHensel: " + pl));
                facs = this.factorsSquarefreeHensel(pu);
                ArrayList<GenPolynomial<Object>> fs = new ArrayList<GenPolynomial<Object>>(facs.size());
                GenPolynomialRing pf = P.ring;
                GenPolynomialRing pfu = pu.ring;
                for (GenPolynomial<Object> genPolynomial : facs) {
                    GenPolynomial<Object> pel = genPolynomial.extendLower(pfu, 0, 0L);
                    GenPolynomial<Object> pe = pel.extend(pf, 0, 0L);
                    fs.add(pe);
                }
                facs = fs;
            }
            catch (Exception e) {
                logger.warn((Object)("exception " + e));
            }
        }
        if (facs == null) {
            logger.info((Object)("factorsSquarefreeHensel not applicable or failed, reverting to Kronecker for: " + P));
            facs = super.factorsSquarefree(P);
        }
        List iopt = TermOrderOptimization.permutation(iperm, pfac, facs);
        logger.info((Object)("de-optimized polynomials: " + iopt));
        facs = this.normalizeFactorization(iopt);
        return facs;
    }

    public List<GenPolynomial<BigInteger>> factorsSquarefreeHensel(GenPolynomial<BigInteger> P) {
        List<GenPolynomial<ModLong>> mlift22;
        if (P == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P != null");
        }
        GenPolynomialRing<BigInteger> pfac = P.ring;
        if (pfac.nvar == 1) {
            return this.baseFactorsSquarefree(P);
        }
        List<GenPolynomial<BigInteger>> factors = new ArrayList<GenPolynomial<BigInteger>>();
        if (P.isZERO()) {
            return factors;
        }
        if (P.degreeVector().totalDeg() <= 1L) {
            factors.add(P);
            return factors;
        }
        GenPolynomial<BigInteger> pd = P;
        BigInteger ac = pd.leadingBaseCoefficient();
        GenPolynomialRing rnfac = pfac.recursive(pfac.nvar - 1);
        GenPolynomial pr = PolyUtil.recursive(rnfac, pd);
        GenPolynomial prr = PolyUtil.switchVariables(pr);
        GenPolynomial<BigInteger> prrc = this.engine.recursiveContent(prr);
        List<GenPolynomial<BigInteger>> cfactors = null;
        if (!prrc.isONE()) {
            prr = PolyUtil.recursiveDivide(prr, prrc);
            GenPolynomial prrcu = prrc.extendLower(pfac, 0, 0L);
            pd = PolyUtil.basePseudoDivide(pd, prrcu);
            logger.info((Object)("recursive content = " + prrc + ", new P = " + pd));
            cfactors = this.factorsSquarefree(prrc);
            ArrayList<GenPolynomial<BigInteger>> cff = new ArrayList<GenPolynomial<BigInteger>>(cfactors.size());
            for (GenPolynomial<BigInteger> fs : cfactors) {
                GenPolynomial<BigInteger> fsp = fs.extendLower(pfac, 0, 0L);
                cff.add(fsp);
            }
            cfactors = cff;
            logger.info((Object)("cfactors = " + cfactors));
        }
        GenPolynomial lprr = prr.leadingBaseCoefficient();
        logger.info((Object)("leading coeffcient = " + lprr));
        boolean isMonic = false;
        if (lprr.isConstant()) {
            isMonic = true;
        }
        SortedMap lfactors = this.factors(lprr);
        ArrayList lfacs = new ArrayList(lfactors.keySet());
        logger.info((Object)("leading coefficient factors = " + lfacs));
        GenPolynomialRing<BigInteger> cpfac = pfac;
        GenPolynomial<BigInteger> pe = pd;
        GenPolynomialRing ccpfac = lprr.ring;
        List<GenPolynomial<Object>> ce = lfacs;
        List<GenPolynomial<Object>> cep = null;
        List<BigInteger> cei = null;
        ArrayList<BigInteger> dei = new ArrayList<BigInteger>();
        BigInteger pec = null;
        BigInteger pecw = null;
        BigInteger ped = null;
        List<GenPolynomial<BigInteger>> ufactors = null;
        ArrayList<TrialParts> tParts = new ArrayList<TrialParts>();
        List lf = null;
        GenPolynomial<BigInteger> lpx = null;
        ArrayList<GenPolynomial<BigInteger>> ln = null;
        ArrayList<GenPolynomial<BigInteger>> un = null;
        GenPolynomial<BigInteger> pes = null;
        List<Object> V = null;
        long evStart = 0L;
        ArrayList<Long> Evs = new ArrayList<Long>(pfac.nvar + 1);
        for (int j = 0; j <= pfac.nvar; ++j) {
            Evs.add(evStart);
        }
        int trials = 4;
        int countSeparate = 0;
        int COUNT_MAX = 50;
        double ran = 1.001;
        boolean isPrimitive = true;
        boolean notLucky = true;
        while (notLucky) {
            int ii;
            BigInteger Vi;
            if (Math.abs(evStart) > 371L) {
                logger.warn((Object)("no lucky evaluation point for: P = " + P + ", lprr = " + lprr + ", lfacs = " + lfacs));
                throw new RuntimeException("no lucky evaluation point found after " + Math.abs(evStart) + " iterations");
            }
            if (Math.abs(evStart) % 100L <= 3L) {
                ran *= 1.001592653589793;
            }
            notLucky = false;
            V = new ArrayList();
            cpfac = pfac;
            pe = pd;
            ccpfac = lprr.ring;
            ce = lfacs;
            cep = null;
            cei = null;
            pec = null;
            ped = null;
            long vi = 0L;
            for (int j = pfac.nvar; j > 1; --j) {
                long degp = pe.degree(cpfac.nvar - 2);
                cpfac = cpfac.contract(1);
                ccpfac = ccpfac.contract(1);
                vi = (Long)Evs.get(j);
                boolean doIt = true;
                Vi = null;
                GenPolynomial<BigInteger> pep = null;
                while (doIt) {
                    logger.info((Object)("vi(" + j + ") = " + vi));
                    Vi = new BigInteger(vi);
                    pep = PolyUtil.evaluateMain(cpfac, pe, Vi);
                    if (degp == pep.degree(cpfac.nvar - 1)) {
                        logger.info((Object)("pep = " + pep));
                        if (this.sengine.isSquarefree(pep)) {
                            doIt = false;
                        }
                    }
                    if (vi > 0L) {
                        vi = -vi;
                        continue;
                    }
                    vi = 1L - vi;
                }
                if (ccpfac.nvar >= 1) {
                    cep = PolyUtil.evaluateMain(ccpfac, ce, Vi);
                } else {
                    cei = PolyUtil.evaluateMain(ccpfac.coFac, ce, Vi);
                }
                int jj = (int)Math.round(ran + 0.52 * Math.random());
                if (vi > 0L) {
                    Evs.set(j, vi + (long)jj);
                    evStart = vi + (long)jj;
                } else {
                    Evs.set(j, vi - (long)jj);
                    evStart = vi - (long)jj;
                }
                V.add(Vi);
                pe = pep;
                ce = cep;
            }
            pecw = this.engine.baseContent(pe);
            isPrimitive = pecw.isONE();
            ped = (BigInteger)ccpfac.coFac.getONE();
            pec = (BigInteger)pe.ring.coFac.getONE();
            if (!isMonic) {
                pec = countSeparate > 50 ? (BigInteger)pe.ring.coFac.getONE() : pecw;
                if (((GenPolynomial)lfacs.get(0)).isConstant()) {
                    ped = cei.remove(0);
                }
                dei = new ArrayList();
                dei.add(pec.multiply(ped).abs());
                int i = 1;
                for (BigInteger ci : cei) {
                    if (ci.isZERO()) {
                        logger.info((Object)("condition (0) not met for cei = " + cei));
                        notLucky = true;
                        break;
                    }
                    BigInteger q = ci.abs();
                    for (ii = i - 1; ii >= 0; --ii) {
                        BigInteger r = (BigInteger)dei.get(ii);
                        while (!r.isONE()) {
                            r = r.gcd(q);
                            q = q.divide(r);
                        }
                    }
                    dei.add(q);
                    if (q.isONE()) {
                        logger.info((Object)("condition (1) not met for dei = " + dei + ", cei = " + cei));
                        if (!this.testSeparate(cei, pecw) && ++countSeparate > 50) {
                            logger.info((Object)("too many inseparable evaluation points: " + countSeparate + ", removing " + pecw));
                        }
                        notLucky = true;
                        break;
                    }
                    ++i;
                }
            }
            if (notLucky) continue;
            logger.info((Object)("evaluation points  = " + V + ", dei = " + dei));
            logger.info((Object)("univariate polynomial = " + pe + ", pecw = " + pecw));
            ufactors = this.baseFactorsSquarefree(pe.divide(pecw));
            if (!pecw.isONE()) {
                ufactors.add(0, ((GenPolynomial)cpfac.getONE()).multiply(pecw));
            }
            if (ufactors.size() <= 1) {
                logger.info((Object)"irreducible univariate polynomial");
                factors.add(pd);
                if (cfactors != null) {
                    cfactors.addAll(factors);
                    factors = cfactors;
                }
                return factors;
            }
            logger.info((Object)("univariate factors = " + ufactors));
            lf = new ArrayList<GenPolynomial<BigInteger>>();
            lpx = lprr.ring.getONE();
            for (GenPolynomial<BigInteger> unused : ufactors) {
                lf.add((GenPolynomial<BigInteger>)lprr.ring.getONE());
            }
            if (!isMonic || !pecw.isONE()) {
                if (lfacs.size() > 0 && ((GenPolynomial)lfacs.get(0)).isConstant()) {
                    GenPolynomial unused = (GenPolynomial)lfacs.remove(0);
                }
                for (int i = ufactors.size() - 1; i >= 0; --i) {
                    GenPolynomial<BigInteger> pp = ufactors.get(i);
                    BigInteger ppl = pp.leadingBaseCoefficient();
                    ppl = ppl.multiply(pec);
                    GenPolynomial<BigInteger> lfp = lf.get(i);
                    ii = 0;
                    for (BigInteger ci : cei) {
                        if (ci.abs().isONE()) {
                            System.out.println("ppl = " + ppl + ", ci = " + ci + ", lfp = " + lfp + ", lfacs.get(ii) = " + lfacs.get(ii));
                            throw new RuntimeException("something is wrong, ci is a unit");
                        }
                        while (ppl.remainder(ci).isZERO() && lfacs.size() > ii) {
                            ppl = ppl.divide(ci);
                            lfp = lfp.multiply((BigInteger)((Object)((GenPolynomial)lfacs.get(ii))));
                        }
                        ++ii;
                    }
                    lfp = lfp.multiply(ppl);
                    lf.set(i, lfp);
                }
                pec = pecw;
                lpx = Power.multiply(lprr.ring, lf);
                if (!lprr.degreeVector().equals(lpx.degreeVector())) {
                    logger.info((Object)("deg(lprr) != deg(lpx): lprr = " + lprr + ", lpx = " + lpx));
                    notLucky = true;
                    continue;
                }
                if (!pec.isONE()) {
                    GenPolynomial<BigInteger> up;
                    int jj;
                    List<GenPolynomial<Object>> lfe = lf;
                    List<BigInteger> lfei = null;
                    ccpfac = lprr.ring;
                    for (int j = lprr.ring.nvar; j > 0; --j) {
                        ccpfac = ccpfac.contract(1);
                        Vi = (BigInteger)V.get(lprr.ring.nvar - j);
                        if (ccpfac.nvar >= 1) {
                            lfe = PolyUtil.evaluateMain(ccpfac, lfe, Vi);
                            continue;
                        }
                        lfei = PolyUtil.evaluateMain(ccpfac.coFac, lfe, Vi);
                    }
                    ln = new ArrayList<GenPolynomial<BigInteger>>(lf.size());
                    un = new ArrayList<GenPolynomial<BigInteger>>(lf.size());
                    for (jj = 0; jj < lf.size(); ++jj) {
                        BigInteger pec1;
                        up = ufactors.get(jj);
                        BigInteger ui = up.leadingBaseCoefficient();
                        BigInteger li = lfei.get(jj);
                        BigInteger di = ui.gcd(li).abs();
                        BigInteger udi = ui.divide(di);
                        BigInteger ldi = li.divide(di);
                        GenPolynomial<BigInteger> lp = lf.get(jj);
                        GenPolynomial<BigInteger> lpd = lp.multiply(udi);
                        GenPolynomial<BigInteger> upd = up.multiply(ldi);
                        if (pec.isONE()) {
                            ln.add(lp);
                            un.add(up);
                            continue;
                        }
                        ln.add(lpd);
                        un.add(upd);
                        pec = pec1 = pec.divide(ldi);
                    }
                    if (!lf.equals(ln) || !un.equals(ufactors)) {
                        logger.debug((Object)"!lf.equals(ln) || !un.equals(ufactors)");
                    }
                    if (!pec.isONE()) {
                        ln = new ArrayList(lf.size());
                        un = new ArrayList(lf.size());
                        pes = pe;
                        for (jj = 0; jj < lf.size(); ++jj) {
                            up = ufactors.get(jj);
                            GenPolynomial<BigInteger> lp = lf.get(jj);
                            if (!up.isConstant()) {
                                up = up.multiply(pec);
                            }
                            lp = lp.multiply(pec);
                            if (jj != 0) {
                                pes = pes.multiply(pec);
                            }
                            un.add(up);
                            ln.add(lp);
                        }
                        if (pes.equals(Power.multiply(pe.ring, un))) {
                            isPrimitive = false;
                        }
                    }
                }
                if (notLucky) continue;
                logger.info((Object)("distributed factors of leading coefficient = " + lf));
                lpx = Power.multiply(lprr.ring, lf);
                if (!((GenPolynomial)lprr.abs()).equals(lpx.abs()) && !lprr.degreeVector().equals(lpx.degreeVector())) {
                    logger.info((Object)("lprr != lpx: lprr = " + lprr + ", lpx = " + lpx));
                    notLucky = true;
                }
            }
            if (notLucky) continue;
            TrialParts tp = null;
            tp = isPrimitive ? new TrialParts(V, pe, ufactors, cei, lf) : new TrialParts(V, pes, un, cei, ln);
            if (tp.univPoly != null && tp.ldcfEval.size() != 0) {
                tParts.add(tp);
            }
            if (tParts.size() >= 4) continue;
            notLucky = true;
        }
        int min = Integer.MAX_VALUE;
        TrialParts tpmin = null;
        for (TrialParts tp : tParts) {
            logger.info((Object)("tp.univFactors.size() = " + tp.univFactors.size()));
            if (tp.univFactors.size() >= min) continue;
            min = tp.univFactors.size();
            tpmin = tp;
        }
        for (TrialParts tp : tParts) {
            if (tp.univFactors.size() != min || tp.univFactors.get(0).isConstant()) continue;
            tpmin = tp;
            break;
        }
        V = tpmin.evalPoints;
        pe = tpmin.univPoly;
        ufactors = tpmin.univFactors;
        cei = tpmin.ldcfEval;
        lf = tpmin.ldcfFactors;
        logger.info((Object)("iterations    = " + Math.abs(evStart)));
        logger.info((Object)("minimal trial = " + tpmin));
        GenPolynomialRing ufac = pe.ring;
        PrimeList primes = new PrimeList(PrimeList.Range.medium);
        Iterator<java.math.BigInteger> primeIter = primes.iterator();
        int pn = 50;
        BigInteger ae = pe.leadingBaseCoefficient();
        GenPolynomial<ModLong> Pm = null;
        Object cofac = null;
        GenPolynomialRing<ModLong> mufac = null;
        for (int i = 0; i < 11; ++i) {
            java.math.BigInteger p = null;
            if (i == 0) {
                primes = new PrimeList(PrimeList.Range.medium);
                primeIter = primes.iterator();
            }
            if (i == 5) {
                primes = new PrimeList(PrimeList.Range.small);
                primeIter = primes.iterator();
                p = primeIter.next();
                p = primeIter.next();
                p = primeIter.next();
                p = primeIter.next();
            }
            if (i == 7) {
                primes = new PrimeList(PrimeList.Range.large);
                primeIter = primes.iterator();
            }
            int pi = 0;
            while (pi < pn && primeIter.hasNext()) {
                p = primeIter.next();
                logger.info((Object)("prime = " + p));
                Iterable<ModLong> cf = null;
                cf = ModLongRing.MAX_LONG.compareTo(p) > 0 ? new ModLongRing(p, true) : new ModIntegerRing(p, true);
                GcdRingElem nf = (GcdRingElem)cf.fromInteger(ae.getVal());
                if (nf.isZERO() || !this.mfactor.isSquarefree(Pm = PolyUtil.fromIntegerCoefficients(mufac = new GenPolynomialRing<ModLong>((RingFactory<ModLong>)((Object)cf), ufac), pe))) continue;
                cofac = cf;
                break;
            }
            if (cofac != null) break;
        }
        if (cofac == null) {
            throw new RuntimeException("giving up on Hensel preparation, no lucky prime found");
        }
        logger.info((Object)("lucky prime = " + cofac.getIntegerModul()));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("univariate modulo p: = " + Pm));
        }
        BigInteger an = pd.maxNorm();
        BigInteger mn = an.multiply(ac.abs()).multiply(new BigInteger(2L));
        long k = Power.logarithm(cofac.getIntegerModul(), mn) + 1L;
        BigInteger q = Power.positivePower(cofac.getIntegerModul(), k);
        Iterable<ModLong> muqfac = ModLongRing.MAX_LONG.compareTo(q.getVal()) > 0 ? new ModLongRing(q.getVal()) : new ModIntegerRing(q.getVal());
        GenPolynomialRing<ModLong> mucpfac = new GenPolynomialRing<ModLong>((RingFactory<ModLong>)((Object)muqfac), ufac);
        List muqfactors = PolyUtil.fromIntegerCoefficients(mucpfac, ufactors);
        GenPolynomial<ModLong> peqq = PolyUtil.fromIntegerCoefficients(mucpfac, pe);
        if (this.debug && !this.mfactor.isFactorization(peqq, muqfactors)) {
            System.out.println("muqfactors = " + muqfactors);
            System.out.println("peqq       = " + peqq);
            throw new RuntimeException("something is wrong, no modular p^k factorization");
        }
        logger.info((Object)("univariate modulo p^k: " + peqq + " = " + muqfactors));
        GenPolynomialRing<ModLong> qcfac = new GenPolynomialRing<ModLong>((RingFactory<ModLong>)((Object)muqfac), pd.ring);
        GenPolynomial<ModLong> pq = PolyUtil.fromIntegerCoefficients(qcfac, pd);
        logger.info((Object)("multivariate modulo p^k: " + pq));
        try {
            mlift22 = HenselMultUtil.liftHensel(pd, pq, muqfactors, V, k, lf);
            logger.info((Object)("mlift = " + mlift22));
        }
        catch (NoLiftingException nle) {
            ArrayList mlift22 = new ArrayList();
            throw new RuntimeException(nle);
        }
        catch (ArithmeticException aex) {
            ArrayList mlift22 = new ArrayList();
            throw aex;
        }
        if (mlift22.size() <= 1) {
            logger.info((Object)("modular lift size == 1: " + mlift22));
            factors.add(pd);
            if (cfactors != null) {
                cfactors.addAll(factors);
                factors = cfactors;
            }
            return factors;
        }
        GenPolynomialRing mfac = mlift22.get((int)0).ring;
        int dl = (mlift22.size() + 1) / 2;
        GenPolynomial<BigInteger> u = P;
        long deg = (u.degree() + 1L) / 2L;
        GenPolynomial<BigInteger> ui = pd;
        block22: for (int j = 1; j <= dl; ++j) {
            KsubSet<GenPolynomial<ModLong>> subs = new KsubSet<GenPolynomial<ModLong>>(mlift22, j);
            for (List<GenPolynomial<ModLong>> list : subs) {
                GenPolynomial<ModLong> mtrial = Power.multiply(mfac, list);
                if (mtrial.degree() > deg) {
                    logger.info((Object)("degree > deg " + deg + ", degree = " + mtrial.degree()));
                }
                GenPolynomial<BigInteger> trial = PolyUtil.integerFromModularCoefficients(pfac, mtrial);
                trial = this.engine.basePrimitivePart(trial);
                if (this.debug) {
                    logger.info((Object)("trial    = " + trial));
                }
                if (!PolyUtil.baseSparsePseudoRemainder(ui, trial).isZERO()) continue;
                logger.info((Object)("successful trial = " + trial));
                factors.add(trial);
                ui = PolyUtil.basePseudoDivide(ui, trial);
                mlift22 = FactorInteger.removeOnce(mlift22, list);
                logger.info((Object)("new mlift= " + mlift22));
                if (mlift22.size() > 1) {
                    dl = (mlift22.size() + 1) / 2;
                    j = 0;
                    continue block22;
                }
                logger.info((Object)("last factor = " + ui));
                factors.add(ui);
                if (cfactors != null) {
                    cfactors.addAll(factors);
                    factors = cfactors;
                }
                return this.normalizeFactorization(factors);
            }
        }
        if (!ui.isONE() && !ui.equals(pd)) {
            logger.info((Object)("rest factor = " + ui));
            factors.add(ui);
        }
        if (factors.size() == 0) {
            logger.info((Object)("irreducible P = " + P));
            factors.add(pd);
        }
        if (cfactors != null) {
            cfactors.addAll(factors);
            factors = cfactors;
        }
        return this.normalizeFactorization(factors);
    }

    boolean testSeparate(List<BigInteger> A, BigInteger b) {
        int i = 0;
        ArrayList<BigInteger> gei = new ArrayList<BigInteger>(A.size());
        for (BigInteger c : A) {
            BigInteger g = c.gcd(b).abs();
            gei.add(g);
            if (g.isONE()) continue;
            ++i;
        }
        return i <= 1;
    }

    boolean isNearlySquarefree(GenPolynomial<BigInteger> P) {
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar >= 0) {
            return this.sengine.isSquarefree(P);
        }
        GenPolynomialRing rfac = pfac.recursive(1);
        GenPolynomial<GenPolynomial<Object>> Pr = PolyUtil.recursive(rfac, P);
        GenPolynomial Ps = PolyUtil.recursiveDeriviative(Pr);
        System.out.println("Pr = " + Pr);
        System.out.println("Ps = " + Ps);
        GenPolynomial g = this.engine.recursiveUnivariateGcd(Pr, Ps);
        System.out.println("g_m = " + g);
        if (!g.isONE()) {
            return false;
        }
        rfac = pfac.recursive(pfac.nvar - 1);
        Pr = PolyUtil.recursive(rfac, P);
        Pr = PolyUtil.switchVariables(Pr);
        Ps = PolyUtil.recursiveDeriviative(Pr);
        System.out.println("Pr = " + Pr);
        System.out.println("Ps = " + Ps);
        g = this.engine.recursiveUnivariateGcd(Pr, Ps);
        System.out.println("g_1 = " + g);
        return g.isONE();
    }
}

