/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.Complex;
import edu.jas.poly.ComplexRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.FactorAbsolute;
import edu.jas.ufd.FactorAbstract;
import edu.jas.ufd.FactorFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class FactorComplex<C extends GcdRingElem<C>>
extends FactorAbsolute<Complex<C>> {
    private static final Logger logger = Logger.getLogger(FactorComplex.class);
    private final boolean debug = logger.isDebugEnabled();
    public final FactorAbstract<AlgebraicNumber<C>> factorAlgeb;
    public final AlgebraicNumberRing<C> afac;

    protected FactorComplex() {
        throw new IllegalArgumentException("don't use this constructor");
    }

    public FactorComplex(RingFactory<Complex<C>> fac) {
        this((ComplexRing)fac);
    }

    public FactorComplex(ComplexRing<C> fac) {
        super(fac);
        this.afac = fac.algebraicRing();
        this.factorAlgeb = FactorFactory.getImplementation(this.afac);
    }

    public FactorComplex(ComplexRing<C> fac, FactorAbstract<AlgebraicNumber<C>> factorAlgeb) {
        super(fac);
        this.afac = fac.algebraicRing();
        this.factorAlgeb = factorAlgeb;
    }

    @Override
    public List<GenPolynomial<Complex<C>>> baseFactorsSquarefree(GenPolynomial<Complex<C>> P) {
        if (P == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P == null");
        }
        ArrayList<GenPolynomial<Complex<C>>> factors = new ArrayList<GenPolynomial<Complex<C>>>();
        if (P.isZERO()) {
            return factors;
        }
        if (P.isONE()) {
            factors.add(P);
            return factors;
        }
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar > 1) {
            throw new IllegalArgumentException("only for univariate polynomials");
        }
        ComplexRing cfac = (ComplexRing)pfac.coFac;
        if (!this.afac.ring.coFac.equals(cfac.ring)) {
            throw new IllegalArgumentException("coefficient rings do not match");
        }
        Complex<C> ldcf = P.leadingBaseCoefficient();
        if (!ldcf.isONE()) {
            P = P.monic();
            factors.add(((GenPolynomial)pfac.getONE()).multiply(ldcf));
        }
        GenPolynomialRing pafac = new GenPolynomialRing(this.afac, pfac);
        GenPolynomial A = PolyUtil.algebraicFromComplex(pafac, P);
        List afactors = this.factorAlgeb.baseFactorsSquarefree(A);
        if (this.debug) {
            logger.info((Object)("complex afactors = " + afactors));
        }
        for (GenPolynomial pa : afactors) {
            GenPolynomial pc = PolyUtil.complexFromAlgebraic(pfac, pa);
            factors.add(pc);
        }
        return factors;
    }
}

