/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.structure.GcdRingElem;
import edu.jas.ufd.FactorAbsolute;
import edu.jas.ufd.FactorAbstract;
import edu.jas.ufd.FactorFactory;
import edu.jas.ufd.PolyUfdUtil;
import edu.jas.ufd.SquarefreeAbstract;
import edu.jas.ufd.SquarefreeFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class FactorAlgebraic<C extends GcdRingElem<C>>
extends FactorAbsolute<AlgebraicNumber<C>> {
    private static final Logger logger = Logger.getLogger(FactorAlgebraic.class);
    private final boolean debug = logger.isDebugEnabled();
    public final FactorAbstract<C> factorCoeff;

    protected FactorAlgebraic() {
        throw new IllegalArgumentException("don't use this constructor");
    }

    public FactorAlgebraic(AlgebraicNumberRing<C> fac) {
        this(fac, FactorFactory.getImplementation(fac.ring.coFac));
    }

    public FactorAlgebraic(AlgebraicNumberRing<C> fac, FactorAbstract<C> factorCoeff) {
        super(fac);
        this.factorCoeff = factorCoeff;
    }

    @Override
    public List<GenPolynomial<AlgebraicNumber<C>>> baseFactorsSquarefree(GenPolynomial<AlgebraicNumber<C>> P) {
        long k;
        if (P == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P == null");
        }
        ArrayList<GenPolynomial<AlgebraicNumber<C>>> factors = new ArrayList<GenPolynomial<AlgebraicNumber<C>>>();
        if (P.isZERO()) {
            return factors;
        }
        if (P.isONE()) {
            factors.add(P);
            return factors;
        }
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar > 1) {
            throw new IllegalArgumentException("only for univariate polynomials");
        }
        AlgebraicNumberRing afac = (AlgebraicNumberRing)pfac.coFac;
        AlgebraicNumber<C> ldcf = P.leadingBaseCoefficient();
        if (!ldcf.isONE()) {
            P = P.monic();
            factors.add(((GenPolynomial)pfac.getONE()).multiply(ldcf));
        }
        if (this.debug) {
            SquarefreeAbstract<AlgebraicNumber<C>> sqengine = SquarefreeFactory.getImplementation(afac);
            if (!sqengine.isSquarefree(P)) {
                throw new RuntimeException("P not squarefree: " + sqengine.squarefreeFactors(P));
            }
            GenPolynomial modu = afac.modul;
            if (!this.factorCoeff.isIrreducible(modu)) {
                throw new RuntimeException("modul not irreducible: " + this.factorCoeff.factors(modu));
            }
            System.out.println("P squarefree and modul irreducible");
        }
        long ks = k = 0L;
        GenPolynomial<C> res = null;
        boolean sqf = false;
        int[] klist = new int[]{0, -1, -2, 1, 2};
        for (int ki = 0; !sqf && ki < klist.length; ++ki) {
            k = klist[ki];
            ks = k;
            res = PolyUfdUtil.norm(P, ks);
            if (res.isZERO() || res.isConstant()) continue;
            sqf = this.factorCoeff.isSquarefree(res);
        }
        if (!sqf) {
            System.out.println("sqf(" + ks + ") = " + res.degree());
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("res = " + res));
        }
        List<GenPolynomial<C>> nfacs = this.factorCoeff.baseFactorsRadical(res);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("res facs = " + nfacs));
        }
        if (nfacs.size() == 1) {
            factors.add(P);
            return factors;
        }
        GenPolynomial<AlgebraicNumber<AlgebraicNumber<C>>> Pp = P;
        for (GenPolynomial<C> nfi : nfacs) {
            GenPolynomial<AlgebraicNumber<C>> pni;
            GenPolynomial Ni = PolyUfdUtil.substituteConvertToAlgebraicCoefficients(pfac, nfi, ks);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Ni = " + Ni));
            }
            if (!(pni = this.engine.gcd(Ni, Pp)).leadingBaseCoefficient().isONE()) {
                pni = pni.monic();
            }
            if (logger.isInfoEnabled()) {
                logger.info((Object)("gcd(Ni,Pp) = " + pni));
            }
            if (pni.isONE()) continue;
            factors.add(pni);
            Pp = Pp.divide(pni);
        }
        if (!Pp.isZERO() && !Pp.isONE()) {
            factors.add(Pp);
        }
        return factors;
    }
}

