/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.kern.TimeStatus;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.OptimizedPolynomialList;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.TermOrderOptimization;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.Factorization;
import edu.jas.ufd.GCDFactory;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import edu.jas.ufd.PolyUfdUtil;
import edu.jas.ufd.SquarefreeAbstract;
import edu.jas.ufd.SquarefreeFactory;
import edu.jas.util.KsubSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public abstract class FactorAbstract<C extends GcdRingElem<C>>
implements Factorization<C> {
    private static final Logger logger = Logger.getLogger(FactorAbstract.class);
    private final boolean debug = logger.isDebugEnabled();
    protected final GreatestCommonDivisorAbstract<C> engine;
    protected final SquarefreeAbstract<C> sengine;

    protected FactorAbstract() {
        throw new IllegalArgumentException("don't use this constructor");
    }

    public FactorAbstract(RingFactory<C> cfac) {
        this.engine = GCDFactory.getProxy(cfac);
        this.sengine = SquarefreeFactory.getImplementation(cfac);
    }

    public String toString() {
        return this.getClass().getName();
    }

    @Override
    public boolean isIrreducible(GenPolynomial<C> P) {
        if (!this.isSquarefree(P)) {
            return false;
        }
        List<GenPolynomial<C>> F2 = this.factorsSquarefree(P);
        if (F2.size() == 1) {
            return true;
        }
        if (F2.size() > 2) {
            return false;
        }
        boolean cnst = false;
        for (GenPolynomial<C> p : F2) {
            if (!p.isConstant()) continue;
            cnst = true;
        }
        return cnst;
    }

    @Override
    public boolean isReducible(GenPolynomial<C> P) {
        return !this.isIrreducible(P);
    }

    @Override
    public boolean isSquarefree(GenPolynomial<C> P) {
        return this.sengine.isSquarefree(P);
    }

    public List<GenPolynomial<C>> factorsSquarefreeOptimize(GenPolynomial<C> P) {
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar <= 1) {
            return this.baseFactorsSquarefree(P);
        }
        ArrayList topt = new ArrayList(1);
        topt.add(P);
        OptimizedPolynomialList opt = TermOrderOptimization.optimizeTermOrder(pfac, topt);
        P = (GenPolynomial)opt.list.get(0);
        logger.info((Object)("optimized polynomial: " + P));
        List<Integer> iperm = TermOrderOptimization.inversePermutation(opt.perm);
        logger.info((Object)("optimize perm: " + opt.perm + ", de-optimize perm: " + iperm));
        ExpVector degv = P.degreeVector();
        int[] donv = degv.dependencyOnVariables();
        List<GenPolynomial<C>> facs = null;
        if (degv.length() == donv.length) {
            logger.info((Object)("do.full factorsSquarefreeKronecker: " + P));
            facs = this.factorsSquarefreeKronecker(P);
        } else {
            GenPolynomial pu = PolyUtil.removeUnusedUpperVariables(P);
            logger.info((Object)("do.sparse factorsSquarefreeKronecker: " + pu));
            facs = this.factorsSquarefreeKronecker(pu);
            ArrayList<GenPolynomial<C>> fs = new ArrayList<GenPolynomial<C>>(facs.size());
            GenPolynomialRing pf = P.ring;
            for (GenPolynomial p : facs) {
                GenPolynomial<C> pe = p.extend(pf, 0, 0L);
                fs.add(pe);
            }
            facs = fs;
        }
        List iopt = TermOrderOptimization.permutation(iperm, pfac, facs);
        logger.info((Object)("de-optimized polynomials: " + iopt));
        facs = this.normalizeFactorization(iopt);
        return facs;
    }

    @Override
    public List<GenPolynomial<C>> factorsSquarefree(GenPolynomial<C> P) {
        return this.factorsSquarefreeKronecker(P);
    }

    public List<GenPolynomial<C>> factorsSquarefreeKronecker(GenPolynomial<C> P) {
        if (P == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P != null");
        }
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar == 1) {
            return this.baseFactorsSquarefree(P);
        }
        ArrayList<GenPolynomial<C>> factors = new ArrayList<GenPolynomial<C>>();
        if (P.isZERO()) {
            return factors;
        }
        if (P.degreeVector().totalDeg() <= 1L) {
            factors.add(P);
            return factors;
        }
        long d = P.degree() + 1L;
        GenPolynomial<C> kr = PolyUfdUtil.substituteKronecker(P, d);
        GenPolynomialRing ufac = kr.ring;
        ufac.setVars(ufac.newVars("zz"));
        logger.info((Object)("deg(subs(P,d=" + d + ")) = " + kr.degree(0) + ", original degrees: " + P.degreeVector()));
        if (this.debug) {
            logger.info((Object)("subs(P,d=" + d + ") = " + kr));
        }
        if (kr.degree(0) > 100L) {
            logger.warn((Object)"Kronecker substitution has to high degree");
            TimeStatus.checkTime("degree > 100");
        }
        List ulist = new ArrayList<GenPolynomial<C>>();
        SortedMap<GenPolynomial<C>, Long> slist = this.baseFactors(kr);
        if (this.debug && !this.isFactorization(kr, slist)) {
            System.out.println("kr    = " + kr);
            System.out.println("slist = " + slist);
            throw new ArithmeticException("no factorization");
        }
        for (Map.Entry<GenPolynomial<C>, Long> me : slist.entrySet()) {
            GenPolynomial<C> g = me.getKey();
            long e = me.getValue();
            int i = 0;
            while ((long)i < e) {
                ulist.add(g);
                ++i;
            }
        }
        if (ulist.size() == 1 && ((GenPolynomial)ulist.get(0)).degree() == P.degree()) {
            factors.add(P);
            return factors;
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("ulist = " + ulist));
        }
        int dl = ulist.size() - 1;
        int ti = 0;
        GenPolynomial<C> u = P;
        long deg = (u.degree() + 1L) / 2L;
        ExpVector evl = u.leadingExpVector();
        ExpVector evt = u.trailingExpVector();
        block2: for (int j = 1; j <= dl; ++j) {
            KsubSet ps = new KsubSet(ulist, j);
            for (List flist : ps) {
                GenPolynomial<C> rem;
                GenPolynomial<GenPolynomial> utrial = ufac.getONE();
                for (int k = 0; k < flist.size(); ++k) {
                    utrial = utrial.multiply((GenPolynomial)flist.get(k));
                }
                GenPolynomial trial = PolyUfdUtil.backSubstituteKronecker(pfac, utrial, d);
                if (++ti % 2000 == 0) {
                    System.out.print("ti(" + ti + ") ");
                    TimeStatus.checkTime(ti + " % 2000 == 0");
                }
                if (!evl.multipleOf(trial.leadingExpVector()) || !evt.multipleOf(trial.trailingExpVector()) || trial.degree() > deg || trial.isConstant()) continue;
                trial = trial.monic();
                if (ti % 15000 == 0) {
                    System.out.println("\ndl   = " + dl + ", deg(u) = " + deg);
                    System.out.println("ulist = " + ulist);
                    System.out.println("kr    = " + kr);
                    System.out.println("u     = " + u);
                    System.out.println("trial = " + trial);
                }
                if (!(rem = PolyUtil.baseSparsePseudoRemainder(u, trial)).isZERO()) continue;
                logger.info((Object)("trial = " + trial));
                factors.add(trial);
                u = PolyUtil.basePseudoDivide(u, trial);
                evl = u.leadingExpVector();
                evt = u.trailingExpVector();
                if (u.isConstant()) {
                    j = dl + 1;
                    continue block2;
                }
                ulist = FactorAbstract.removeOnce(ulist, flist);
                dl = (ulist.size() + 1) / 2;
                j = 0;
                continue block2;
            }
        }
        if (!u.isONE() && !u.equals(P)) {
            logger.info((Object)("rest u = " + u));
            factors.add(u);
        }
        if (factors.size() == 0) {
            logger.info((Object)("irred P = " + P));
            factors.add(P);
        }
        return this.normalizeFactorization(factors);
    }

    static <T> List<T> removeOnce(List<T> a, List<T> b) {
        ArrayList<T> res = new ArrayList<T>();
        res.addAll(a);
        for (T e : b) {
            boolean t = res.remove(e);
        }
        return res;
    }

    public List<GenPolynomial<C>> baseFactorsRadical(GenPolynomial<C> P) {
        return new ArrayList<GenPolynomial<C>>(this.baseFactors(P).keySet());
    }

    public SortedMap<GenPolynomial<C>, Long> baseFactors(GenPolynomial<C> P) {
        SortedMap<GenPolynomial<C>, Long> facs;
        GcdRingElem c;
        if (P == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P != null");
        }
        GenPolynomialRing pfac = P.ring;
        TreeMap<GenPolynomial<C>, Long> factors = new TreeMap<GenPolynomial<C>, Long>(pfac.getComparator());
        if (P.isZERO()) {
            return factors;
        }
        if (pfac.nvar > 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " only for univariate polynomials");
        }
        if (P.isConstant()) {
            factors.put(P, 1L);
            return factors;
        }
        if (pfac.coFac.isField()) {
            c = (GcdRingElem)P.leadingBaseCoefficient();
        } else {
            c = this.engine.baseContent(P);
            if (P.signum() < 0 && c.signum() > 0) {
                c = (GcdRingElem)c.negate();
            }
        }
        if (!c.isONE()) {
            GenPolynomial pc = ((GenPolynomial)pfac.getONE()).multiply(c);
            factors.put(pc, 1L);
            P = P.divide(c);
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("base facs for P = " + P));
        }
        if ((facs = this.sengine.baseSquarefreeFactors(P)) == null || facs.size() == 0) {
            facs = new TreeMap<GenPolynomial<C>, Long>();
            facs.put(P, 1L);
        }
        if (logger.isInfoEnabled() && (facs.size() > 1 || facs.size() == 1 && (Long)facs.get(facs.firstKey()) > 1L)) {
            logger.info((Object)("squarefree facs   = " + facs));
        }
        for (Map.Entry<GenPolynomial<C>, Long> me : facs.entrySet()) {
            GenPolynomial<C> g = me.getKey();
            Long k = me.getValue();
            if (pfac.coFac.isField() && !((GcdRingElem)g.leadingBaseCoefficient()).isONE()) {
                g = g.monic();
                logger.warn((Object)("squarefree facs mon = " + g));
            }
            if (g.degree(0) <= 1L) {
                if (g.isONE()) continue;
                factors.put(g, k);
                continue;
            }
            List<GenPolynomial<C>> sfacs = this.baseFactorsSquarefree(g);
            if (this.debug) {
                logger.info((Object)("factors of squarefree = " + sfacs));
            }
            for (GenPolynomial<C> h : sfacs) {
                Long j = (Long)factors.get(h);
                if (j != null) {
                    k = k + j;
                }
                if (h.isONE()) continue;
                factors.put(h, k);
            }
        }
        return factors;
    }

    public abstract List<GenPolynomial<C>> baseFactorsSquarefree(GenPolynomial<C> var1);

    @Override
    public List<GenPolynomial<C>> factorsRadical(GenPolynomial<C> P) {
        return new ArrayList<GenPolynomial<C>>(this.factors(P).keySet());
    }

    @Override
    public List<GenPolynomial<C>> factorsRadical(List<GenPolynomial<C>> L) {
        TreeSet<GenPolynomial<C>> facs = new TreeSet<GenPolynomial<C>>();
        for (GenPolynomial<C> p : L) {
            List<GenPolynomial<C>> fs = this.factorsRadical(p);
            facs.addAll(fs);
        }
        return new ArrayList<GenPolynomial<C>>(facs);
    }

    @Override
    public SortedMap<GenPolynomial<C>, Long> factors(GenPolynomial<C> P) {
        SortedMap<GenPolynomial<C>, Long> facs;
        GcdRingElem c;
        if (P == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P != null");
        }
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar == 1) {
            return this.baseFactors(P);
        }
        TreeMap<GenPolynomial<C>, Long> factors = new TreeMap<GenPolynomial<C>, Long>(pfac.getComparator());
        if (P.isZERO()) {
            return factors;
        }
        if (P.isConstant()) {
            factors.put(P, 1L);
            return factors;
        }
        if (pfac.coFac.isField()) {
            c = (GcdRingElem)P.leadingBaseCoefficient();
        } else {
            c = this.engine.baseContent(P);
            if (P.signum() < 0 && c.signum() > 0) {
                c = (GcdRingElem)c.negate();
            }
        }
        if (!c.isONE()) {
            GenPolynomial pc = ((GenPolynomial)pfac.getONE()).multiply(c);
            factors.put(pc, 1L);
            P = P.divide(c);
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("squarefree mfacs P = " + P));
        }
        if ((facs = this.sengine.squarefreeFactors(P)) == null || facs.size() == 0) {
            facs = new TreeMap<GenPolynomial<C>, Long>();
            facs.put(P, 1L);
            throw new RuntimeException("this should not happen, facs is empty: " + facs);
        }
        if (logger.isInfoEnabled()) {
            if (facs.size() > 1) {
                logger.info((Object)("squarefree mfacs      = " + facs));
            } else if (facs.size() == 1 && (Long)facs.get(facs.firstKey()) > 1L) {
                logger.info((Object)("squarefree #mfacs 1-n = " + facs));
            } else {
                logger.info((Object)("squarefree #mfacs 1-1 = " + facs));
            }
        }
        for (Map.Entry<GenPolynomial<C>, Long> me : facs.entrySet()) {
            GenPolynomial<C> g = me.getKey();
            if (g.isONE()) continue;
            Long d = me.getValue();
            List<GenPolynomial<C>> sfacs = this.factorsSquarefree(g);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("factors of squarefree ^" + d + " = " + sfacs));
            }
            for (GenPolynomial<C> h : sfacs) {
                long dd = d;
                Long j = (Long)factors.get(h);
                if (j != null) {
                    dd += j.longValue();
                }
                factors.put(h, dd);
            }
        }
        return factors;
    }

    @Override
    public GenPolynomial<C> squarefreePart(GenPolynomial<C> P) {
        return this.sengine.squarefreePart(P);
    }

    public GenPolynomial<C> primitivePart(GenPolynomial<C> P) {
        return this.engine.primitivePart(P);
    }

    public GenPolynomial<C> basePrimitivePart(GenPolynomial<C> P) {
        return this.engine.basePrimitivePart(P);
    }

    @Override
    public SortedMap<GenPolynomial<C>, Long> squarefreeFactors(GenPolynomial<C> P) {
        return this.sengine.squarefreeFactors(P);
    }

    @Override
    public boolean isFactorization(GenPolynomial<C> P, List<GenPolynomial<C>> F2) {
        return this.sengine.isFactorization(P, F2);
    }

    @Override
    public boolean isFactorization(GenPolynomial<C> P, SortedMap<GenPolynomial<C>, Long> F2) {
        return this.sengine.isFactorization(P, F2);
    }

    public long factorsDegree(SortedMap<GenPolynomial<C>, Long> F2) {
        long d = 0L;
        for (Map.Entry<GenPolynomial<C>, Long> me : F2.entrySet()) {
            GenPolynomial<C> p = me.getKey();
            long e = me.getValue();
            d += p.degree() * e;
        }
        return d;
    }

    public boolean isRecursiveFactorization(GenPolynomial<GenPolynomial<C>> P, SortedMap<GenPolynomial<GenPolynomial<C>>, Long> F2) {
        return this.sengine.isRecursiveFactorization(P, F2);
    }

    public List<GenPolynomial<GenPolynomial<C>>> recursiveFactorsSquarefree(GenPolynomial<GenPolynomial<C>> P) {
        GenPolynomialRing pfac;
        if (P == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P == null");
        }
        ArrayList<GenPolynomial<GenPolynomial<C>>> factors = new ArrayList<GenPolynomial<GenPolynomial<C>>>();
        if (P.isZERO()) {
            return factors;
        }
        if (P.isONE()) {
            factors.add(P);
            return factors;
        }
        GenPolynomialRing qi = (GenPolynomialRing)pfac.coFac;
        pfac = P.ring;
        GenPolynomialRing ifac = qi.extend(pfac.getVars());
        GenPolynomial Pi2 = PolyUtil.distribute(ifac, P);
        GcdRingElem ldcf = (GcdRingElem)Pi2.leadingBaseCoefficient();
        if (!ldcf.isONE() && ldcf.isUnit()) {
            Pi2 = Pi2.monic();
        }
        List ifacts = this.factorsSquarefree(Pi2);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("ifacts = " + ifacts));
        }
        if (ifacts.size() <= 1) {
            factors.add(P);
            return factors;
        }
        if (!ldcf.isONE() && ldcf.isUnit()) {
            GenPolynomial<GcdRingElem> r = ifacts.get(0);
            ifacts.remove(r);
            r = r.multiply(ldcf);
            ifacts.add(0, r);
        }
        List rfacts = PolyUtil.recursive(pfac, ifacts);
        if (logger.isDebugEnabled()) {
            logger.info((Object)("recfacts = " + rfacts));
        }
        factors.addAll(rfacts);
        return factors;
    }

    public SortedMap<GenPolynomial<GenPolynomial<C>>, Long> recursiveFactors(GenPolynomial<GenPolynomial<C>> P) {
        if (P == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P != null");
        }
        GenPolynomialRing pfac = P.ring;
        TreeMap<GenPolynomial<GenPolynomial<C>>, Long> factors = new TreeMap<GenPolynomial<GenPolynomial<C>>, Long>(pfac.getComparator());
        if (P.isZERO()) {
            return factors;
        }
        if (P.isONE()) {
            factors.put(P, 1L);
            return factors;
        }
        GenPolynomialRing qi = (GenPolynomialRing)pfac.coFac;
        GenPolynomialRing ifac = qi.extend(pfac.getVars());
        GenPolynomial Pi2 = PolyUtil.distribute(ifac, P);
        GcdRingElem ldcf = (GcdRingElem)Pi2.leadingBaseCoefficient();
        if (!ldcf.isONE() && ldcf.isUnit()) {
            Pi2 = Pi2.monic();
        }
        SortedMap dfacts = this.factors(Pi2);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("dfacts = " + dfacts));
        }
        if (!ldcf.isONE() && ldcf.isUnit()) {
            GenPolynomial<GcdRingElem> r = dfacts.firstKey();
            Long E2 = (Long)dfacts.remove(r);
            r = r.multiply(ldcf);
            dfacts.put(r, E2);
        }
        for (Map.Entry me : dfacts.entrySet()) {
            GenPolynomial f = me.getKey();
            Long E3 = me.getValue();
            GenPolynomial rp = PolyUtil.recursive(pfac, f);
            factors.put(rp, E3);
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("recursive factors = " + factors));
        }
        return factors;
    }

    public List<GenPolynomial<C>> normalizeFactorization(List<GenPolynomial<C>> F2) {
        if (F2 == null || F2.size() <= 1) {
            return F2;
        }
        ArrayList<GenPolynomial<C>> Fp = new ArrayList<GenPolynomial<C>>(F2.size());
        AbelianGroupElem<GenPolynomial<C>> f0 = F2.get(0);
        for (int i = 1; i < F2.size(); ++i) {
            AbelianGroupElem<GenPolynomial<C>> fi = F2.get(i);
            if (fi.signum() < 0) {
                fi = fi.negate();
                f0 = f0.negate();
            }
            Fp.add((GenPolynomial<C>)fi);
        }
        if (!f0.isONE()) {
            Fp.add(0, (GenPolynomial<C>)f0);
        }
        return Fp;
    }
}

