/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.root;

import edu.jas.arith.BigRational;
import edu.jas.arith.Rational;
import edu.jas.poly.Complex;
import edu.jas.poly.ComplexRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.root.ComplexAlgebraicNumber;
import edu.jas.root.ComplexAlgebraicRing;
import edu.jas.root.ComplexRootsSturm;
import edu.jas.root.Interval;
import edu.jas.root.InvalidBoundaryException;
import edu.jas.root.PolyUtilRoot;
import edu.jas.root.RealAlgebraicNumber;
import edu.jas.root.RealAlgebraicRing;
import edu.jas.root.RealRootsSturm;
import edu.jas.root.Rectangle;
import edu.jas.structure.ElemFactory;
import edu.jas.structure.GcdRingElem;
import edu.jas.ufd.FactorAbstract;
import edu.jas.ufd.FactorFactory;
import edu.jas.ufd.SquarefreeAbstract;
import edu.jas.ufd.SquarefreeFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;

public class RootFactory {
    public static <C extends GcdRingElem<C> & Rational> boolean isRoot(GenPolynomial<C> f, RealAlgebraicNumber<C> r) {
        ElemFactory rr = r.factory();
        GenPolynomialRing rfac = new GenPolynomialRing(rr, (GenPolynomialRing)f.factory());
        GenPolynomial p = PolyUtilRoot.convertToRealCoefficients(rfac, f);
        RealAlgebraicNumber<C> a = PolyUtil.evaluateMain(rr, p, r);
        return a.isZERO();
    }

    public static <C extends GcdRingElem<C> & Rational> List<RealAlgebraicNumber<C>> realAlgebraicNumbers(GenPolynomial<C> f) {
        RealRootsSturm rr = new RealRootsSturm();
        SquarefreeAbstract<GenPolynomial<C>> engine = SquarefreeFactory.getImplementation(f.ring.coFac);
        SortedMap<GenPolynomial<C>, Long> SF = engine.squarefreeFactors(f);
        Set S = SF.keySet();
        ArrayList<RealAlgebraicNumber<C>> list = new ArrayList<RealAlgebraicNumber<C>>();
        for (GenPolynomial sp : S) {
            List iv = rr.realRoots(sp);
            for (Interval I2 : iv) {
                RealAlgebraicRing rar = new RealAlgebraicRing(sp, I2);
                RealAlgebraicNumber rn = rar.getGenerator();
                long mult = (Long)SF.get(sp);
                int i = 0;
                while ((long)i < mult) {
                    list.add(rn);
                    ++i;
                }
            }
        }
        return list;
    }

    public static <C extends GcdRingElem<C> & Rational> List<RealAlgebraicNumber<C>> realAlgebraicNumbers(GenPolynomial<C> f, BigRational eps) {
        RealRootsSturm rr = new RealRootsSturm();
        SquarefreeAbstract<GenPolynomial<C>> engine = SquarefreeFactory.getImplementation(f.ring.coFac);
        SortedMap<GenPolynomial<C>, Long> SF = engine.squarefreeFactors(f);
        Set S = SF.keySet();
        ArrayList<RealAlgebraicNumber<C>> list = new ArrayList<RealAlgebraicNumber<C>>();
        for (GenPolynomial sp : S) {
            List iv = rr.realRoots(sp, eps);
            for (Interval I2 : iv) {
                RealAlgebraicRing rar = new RealAlgebraicRing(sp, I2);
                rar.setEps(eps);
                RealAlgebraicNumber rn = rar.getGenerator();
                long mult = (Long)SF.get(sp);
                int i = 0;
                while ((long)i < mult) {
                    list.add(rn);
                    ++i;
                }
            }
        }
        return list;
    }

    public static <C extends GcdRingElem<C> & Rational> List<RealAlgebraicNumber<C>> realAlgebraicNumbersField(GenPolynomial<C> f) {
        RealRootsSturm rr = new RealRootsSturm();
        FactorAbstract<C> engine = FactorFactory.getImplementation(f.ring.coFac);
        SortedMap SF = engine.baseFactors(f);
        Set S = SF.keySet();
        ArrayList<RealAlgebraicNumber<C>> list = new ArrayList<RealAlgebraicNumber<C>>();
        for (GenPolynomial sp : S) {
            List iv = rr.realRoots(sp);
            for (Interval I2 : iv) {
                RealAlgebraicRing rar = new RealAlgebraicRing(sp, I2, true);
                RealAlgebraicNumber rn = rar.getGenerator();
                long mult = (Long)SF.get(sp);
                int i = 0;
                while ((long)i < mult) {
                    list.add(rn);
                    ++i;
                }
            }
        }
        return list;
    }

    public static <C extends GcdRingElem<C> & Rational> List<RealAlgebraicNumber<C>> realAlgebraicNumbersField(GenPolynomial<C> f, BigRational eps) {
        RealRootsSturm rr = new RealRootsSturm();
        FactorAbstract<C> engine = FactorFactory.getImplementation(f.ring.coFac);
        SortedMap SF = engine.baseFactors(f);
        Set S = SF.keySet();
        ArrayList<RealAlgebraicNumber<C>> list = new ArrayList<RealAlgebraicNumber<C>>();
        for (GenPolynomial sp : S) {
            List iv = rr.realRoots(sp, eps);
            for (Interval I2 : iv) {
                RealAlgebraicRing rar = new RealAlgebraicRing(sp, I2, true);
                rar.setEps(eps);
                RealAlgebraicNumber rn = rar.getGenerator();
                long mult = (Long)SF.get(sp);
                int i = 0;
                while ((long)i < mult) {
                    list.add(rn);
                    ++i;
                }
            }
        }
        return list;
    }

    public static <C extends GcdRingElem<C> & Rational> List<RealAlgebraicNumber<C>> realAlgebraicNumbersIrred(GenPolynomial<C> f) {
        RealRootsSturm<C> rr = new RealRootsSturm<C>();
        ArrayList<RealAlgebraicNumber<C>> list = new ArrayList<RealAlgebraicNumber<C>>();
        List<Interval<C>> iv = rr.realRoots(f);
        for (Interval<C> I2 : iv) {
            RealAlgebraicRing<C> rar = new RealAlgebraicRing<C>(f, I2, true);
            RealAlgebraicNumber<C> rn = rar.getGenerator();
            list.add(rn);
        }
        return list;
    }

    public static <C extends GcdRingElem<C> & Rational> List<RealAlgebraicNumber<C>> realAlgebraicNumbersIrred(GenPolynomial<C> f, BigRational eps) {
        RealRootsSturm<C> rr = new RealRootsSturm<C>();
        ArrayList<RealAlgebraicNumber<C>> list = new ArrayList<RealAlgebraicNumber<C>>();
        List<Interval<C>> iv = rr.realRoots(f, eps);
        for (Interval<C> I2 : iv) {
            RealAlgebraicRing<C> rar = new RealAlgebraicRing<C>(f, I2, true);
            rar.setEps(eps);
            RealAlgebraicNumber<C> rn = rar.getGenerator();
            list.add(rn);
        }
        return list;
    }

    public static <C extends GcdRingElem<C> & Rational> boolean isRoot(GenPolynomial<C> f, ComplexAlgebraicNumber<C> r) {
        ElemFactory cr = r.factory();
        GenPolynomialRing cfac = new GenPolynomialRing(cr, (GenPolynomialRing)f.factory());
        GenPolynomial p = PolyUtilRoot.convertToComplexCoefficients(cfac, f);
        ComplexAlgebraicNumber<C> a = PolyUtil.evaluateMain(cr, p, r);
        return a.isZERO();
    }

    public static <C extends GcdRingElem<C> & Rational> boolean isRootComplex(GenPolynomial<Complex<C>> f, ComplexAlgebraicNumber<C> r) {
        ElemFactory cr = r.factory();
        GenPolynomialRing cfac = new GenPolynomialRing(cr, (GenPolynomialRing)f.factory());
        GenPolynomial p = PolyUtilRoot.convertToComplexCoefficientsFromComplex(cfac, f);
        ComplexAlgebraicNumber<C> a = PolyUtil.evaluateMain(cr, p, r);
        return a.isZERO();
    }

    public static <C extends GcdRingElem<C> & Rational> List<ComplexAlgebraicNumber<C>> complexAlgebraicNumbersComplex(GenPolynomial<Complex<C>> f) {
        ComplexRootsSturm cr = new ComplexRootsSturm(f.ring.coFac);
        SquarefreeAbstract<GenPolynomial<Complex<C>>> engine = SquarefreeFactory.getImplementation(f.ring.coFac);
        SortedMap<GenPolynomial<Complex<C>>, Long> SF = engine.squarefreeFactors(f);
        Set S = SF.keySet();
        ArrayList<ComplexAlgebraicNumber<C>> list = new ArrayList<ComplexAlgebraicNumber<C>>();
        for (GenPolynomial sp : S) {
            List iv = cr.complexRoots(sp);
            for (Rectangle I2 : iv) {
                ComplexAlgebraicRing car = new ComplexAlgebraicRing(sp, I2);
                ComplexAlgebraicNumber cn = car.getGenerator();
                long mult = (Long)SF.get(sp);
                int i = 0;
                while ((long)i < mult) {
                    list.add(cn);
                    ++i;
                }
            }
        }
        return list;
    }

    public static <C extends GcdRingElem<C> & Rational> List<ComplexAlgebraicNumber<C>> complexAlgebraicNumbersComplex(GenPolynomial<Complex<C>> f, BigRational eps) {
        ComplexRootsSturm cr = new ComplexRootsSturm(f.ring.coFac);
        SquarefreeAbstract<GenPolynomial<Complex<C>>> engine = SquarefreeFactory.getImplementation(f.ring.coFac);
        SortedMap<GenPolynomial<Complex<C>>, Long> SF = engine.squarefreeFactors(f);
        Set S = SF.keySet();
        ArrayList<ComplexAlgebraicNumber<C>> list = new ArrayList<ComplexAlgebraicNumber<C>>();
        for (GenPolynomial sp : S) {
            List iv = cr.complexRoots(sp);
            Iterator i$ = iv.iterator();
            while (i$.hasNext()) {
                Rectangle I2;
                Rectangle Iv = I2 = i$.next();
                try {
                    Iv = cr.complexRootRefinement(I2, sp, eps);
                }
                catch (InvalidBoundaryException e) {
                    e.printStackTrace();
                }
                ComplexAlgebraicRing car = new ComplexAlgebraicRing(sp, Iv);
                car.setEps(eps);
                ComplexAlgebraicNumber cn = car.getGenerator();
                long mult = (Long)SF.get(sp);
                int i = 0;
                while ((long)i < mult) {
                    list.add(cn);
                    ++i;
                }
            }
        }
        return list;
    }

    public static <C extends GcdRingElem<C> & Rational> List<ComplexAlgebraicNumber<C>> complexAlgebraicNumbers(GenPolynomial<C> f) {
        if (f.ring.coFac instanceof Complex) {
            throw new IllegalArgumentException("f already has Complex coefficients " + f.ring);
        }
        if (f.ring.coFac instanceof ComplexAlgebraicRing) {
            throw new UnsupportedOperationException("unsupported ComplexAlgebraicRing coefficients " + f.ring);
        }
        ComplexRing cr = new ComplexRing(f.ring.coFac);
        GenPolynomialRing fac = new GenPolynomialRing(cr, f.ring);
        GenPolynomial fc = PolyUtil.complexFromAny(fac, f);
        return RootFactory.complexAlgebraicNumbersComplex(fc);
    }

    public static <C extends GcdRingElem<C> & Rational> List<ComplexAlgebraicNumber<C>> complexAlgebraicNumbers(GenPolynomial<C> f, BigRational eps) {
        if (f.ring.coFac instanceof Complex) {
            throw new IllegalArgumentException("f already has Complex coefficients " + f.ring);
        }
        if (f.ring.coFac instanceof ComplexAlgebraicRing) {
            throw new UnsupportedOperationException("unsupported ComplexAlgebraicRing coefficients " + f.ring);
        }
        ComplexRing cr = new ComplexRing(f.ring.coFac);
        GenPolynomialRing fac = new GenPolynomialRing(cr, f.ring);
        GenPolynomial fc = PolyUtil.complexFromAny(fac, f);
        return RootFactory.complexAlgebraicNumbersComplex(fc, eps);
    }
}

