/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.root;

import edu.jas.arith.BigDecimal;
import edu.jas.arith.BigRational;
import edu.jas.arith.Rational;
import edu.jas.poly.Complex;
import edu.jas.poly.ComplexRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.root.ComplexRoots;
import edu.jas.root.InvalidBoundaryException;
import edu.jas.root.NoConvergenceException;
import edu.jas.root.Rectangle;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import edu.jas.structure.StarRingElem;
import edu.jas.structure.UnaryFunctor;
import edu.jas.ufd.Squarefree;
import edu.jas.ufd.SquarefreeFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.apache.log4j.Logger;

public abstract class ComplexRootsAbstract<C extends RingElem<C> & Rational>
implements ComplexRoots<C> {
    private static final Logger logger = Logger.getLogger(ComplexRootsAbstract.class);
    private final boolean debug = logger.isDebugEnabled();
    public final Squarefree<Complex<C>> engine;

    public ComplexRootsAbstract(RingFactory<Complex<C>> cf) {
        if (!(cf instanceof ComplexRing)) {
            throw new IllegalArgumentException("cf not supported coefficients " + cf);
        }
        this.engine = SquarefreeFactory.getImplementation(cf);
    }

    @Override
    public Complex<C> rootBound(GenPolynomial<Complex<C>> f) {
        if (f == null) {
            return null;
        }
        RingFactory cfac = f.ring.coFac;
        Complex M = (Complex)cfac.getONE();
        if (f.isZERO() || f.isConstant()) {
            return M;
        }
        StarRingElem a = f.leadingBaseCoefficient().norm();
        for (Complex<C> c : f.getMap().values()) {
            Complex d = ((Complex)c.norm()).divide(a);
            if (M.compareTo(d) >= 0) continue;
            M = d;
        }
        M = M.sum((Complex)cfac.getONE());
        return M;
    }

    public C magnitudeBound(Rectangle<C> rect, GenPolynomial<Complex<C>> f) {
        StarRingElem M1c;
        Object M1;
        if (f == null) {
            return null;
        }
        if (f.isZERO()) {
            return ((Complex)f.ring.coFac.getONE()).getRe();
        }
        if (f.isConstant()) {
            Complex<C> c = f.leadingBaseCoefficient();
            return ((Complex)c.norm()).getRe();
        }
        GenPolynomial<Complex<C>> fa = f.map(new UnaryFunctor<Complex<C>, Complex<C>>(){

            @Override
            public Complex<C> eval(Complex<C> a) {
                return a.norm();
            }
        });
        StarRingElem Mc = rect.getNW().norm();
        Object M = ((Complex)Mc).getRe();
        if (M.compareTo(M1 = ((Complex)(M1c = rect.getSW().norm())).getRe()) < 0) {
            M = M1;
            Mc = M1c;
        }
        if (M.compareTo(M1 = ((Complex)(M1c = rect.getSE().norm())).getRe()) < 0) {
            M = M1;
            Mc = M1c;
        }
        if (M.compareTo(M1 = ((Complex)(M1c = rect.getNE().norm())).getRe()) < 0) {
            Mc = M1c;
        }
        Complex B = (Complex)PolyUtil.evaluateMain(f.ring.coFac, fa, Mc);
        return B.getRe();
    }

    @Override
    public abstract long complexRootCount(Rectangle<C> var1, GenPolynomial<Complex<C>> var2) throws InvalidBoundaryException;

    @Override
    public abstract List<Rectangle<C>> complexRoots(Rectangle<C> var1, GenPolynomial<Complex<C>> var2) throws InvalidBoundaryException;

    @Override
    public List<Rectangle<C>> complexRoots(GenPolynomial<Complex<C>> a) {
        ArrayList<Rectangle<C>> roots = new ArrayList<Rectangle<C>>();
        if (a.isConstant() || a.isZERO()) {
            return roots;
        }
        ComplexRing cr = (ComplexRing)a.ring.coFac;
        SortedMap<GenPolynomial<Complex<C>>, Long> sa = this.engine.squarefreeFactors(a);
        for (Map.Entry<GenPolynomial<Complex<C>>, Long> me : sa.entrySet()) {
            GenPolynomial<Complex<C>> p = me.getKey();
            Complex<C> Mb = this.rootBound(p);
            AbelianGroupElem M = Mb.getRe();
            RingElem M1 = (RingElem)M.sum((AbelianGroupElem)((AbelianGroupElem)M.factory().fromInteger(1L)));
            if (this.debug) {
                logger.info((Object)("rootBound = " + M));
            }
            Complex[] corner = new Complex[]{new Complex<RingElem>(cr, (RingElem)M1.negate(), (RingElem)M), new Complex<RingElem>(cr, (RingElem)M1.negate(), (RingElem)M1.negate()), new Complex<RingElem>(cr, (RingElem)M, (RingElem)M1.negate()), new Complex<C>(cr, M, M)};
            Rectangle rect = new Rectangle(corner);
            try {
                List rs = this.complexRoots(rect, p);
                long e = me.getValue();
                int i = 0;
                while ((long)i < e) {
                    roots.addAll(rs);
                    ++i;
                }
            }
            catch (InvalidBoundaryException e) {
                throw new RuntimeException("this should never happen " + e);
            }
        }
        return roots;
    }

    @Override
    public Rectangle<C> complexRootRefinement(Rectangle<C> rect, GenPolynomial<Complex<C>> a, BigRational len) throws InvalidBoundaryException {
        long w;
        ComplexRing cr = (ComplexRing)a.ring.coFac;
        Rectangle<C> root = rect;
        if (this.debug && (w = this.complexRootCount(root, a)) != 1L) {
            System.out.println("#root = " + w);
            System.out.println("root = " + root);
            throw new ArithmeticException("no initial isolating rectangle " + rect);
        }
        Complex eps = cr.fromInteger(1L);
        eps = eps.divide(cr.fromInteger(1000L));
        BigRational length = len.multiply(len);
        Complex delta = null;
        boolean work = true;
        while (work) {
            try {
                while (root.rationalLength().compareTo(length) > 0) {
                    if (delta == null) {
                        delta = root.corners[3].subtract(root.corners[1]);
                        delta = delta.divide(cr.fromInteger(2L));
                    }
                    Complex center = root.corners[1].sum(delta);
                    if (this.debug) {
                        logger.info((Object)("new center = " + center));
                    }
                    Complex[] cp = this.copyOfComplex(root.corners, 4);
                    cp[1] = new Complex(cr, cp[1].getRe(), center.getIm());
                    cp[2] = center;
                    cp[3] = new Complex(cr, center.getRe(), cp[3].getIm());
                    Rectangle nw = new Rectangle(cp);
                    w = this.complexRootCount(nw, a);
                    if (w == 1L) {
                        root = nw;
                        delta = null;
                        continue;
                    }
                    cp = this.copyOfComplex(root.corners, 4);
                    cp[0] = new Complex(cr, cp[0].getRe(), center.getIm());
                    cp[2] = new Complex(cr, center.getRe(), cp[2].getIm());
                    cp[3] = center;
                    Rectangle sw = new Rectangle(cp);
                    w = this.complexRootCount(sw, a);
                    if (w == 1L) {
                        root = sw;
                        delta = null;
                        continue;
                    }
                    cp = this.copyOfComplex(root.corners, 4);
                    cp[0] = center;
                    cp[1] = new Complex(cr, center.getRe(), cp[1].getIm());
                    cp[3] = new Complex(cr, cp[3].getRe(), center.getIm());
                    Rectangle se = new Rectangle(cp);
                    w = this.complexRootCount(se, a);
                    if (w == 1L) {
                        root = se;
                        delta = null;
                        continue;
                    }
                    cp = this.copyOfComplex(root.corners, 4);
                    cp[0] = new Complex(cr, center.getRe(), cp[0].getIm());
                    cp[1] = center;
                    cp[2] = new Complex(cr, cp[2].getRe(), center.getIm());
                    Rectangle ne = new Rectangle(cp);
                    w = this.complexRootCount(ne, a);
                    if (w == 1L) {
                        root = ne;
                        delta = null;
                        continue;
                    }
                    w = this.complexRootCount(root, a);
                    System.out.println("#root = " + w);
                    System.out.println("root = " + root);
                    throw new ArithmeticException("no isolating rectangle " + rect);
                }
                work = false;
            }
            catch (InvalidBoundaryException e) {
                delta = delta.sum(delta.multiply(eps));
                eps = eps.sum(eps.multiply(cr.getIMAG()));
            }
        }
        return root;
    }

    public List<Rectangle<C>> complexRoots(GenPolynomial<Complex<C>> a, BigRational len) {
        ComplexRing cr = (ComplexRing)a.ring.coFac;
        SortedMap<GenPolynomial<Complex<C>>, Long> sa = this.engine.squarefreeFactors(a);
        ArrayList<Rectangle<C>> roots = new ArrayList<Rectangle<C>>();
        for (Map.Entry<GenPolynomial<Complex<C>>, Long> me : sa.entrySet()) {
            GenPolynomial<Complex<C>> p = me.getKey();
            Complex<C> Mb = this.rootBound(p);
            AbelianGroupElem M = Mb.getRe();
            RingElem M1 = (RingElem)M.sum((AbelianGroupElem)((AbelianGroupElem)M.factory().fromInteger(1L)));
            if (this.debug) {
                logger.info((Object)("rootBound = " + M));
            }
            Complex[] corner = new Complex[]{new Complex<RingElem>(cr, (RingElem)M1.negate(), (RingElem)M), new Complex<RingElem>(cr, (RingElem)M1.negate(), (RingElem)M1.negate()), new Complex<RingElem>(cr, (RingElem)M, (RingElem)M1.negate()), new Complex<C>(cr, M, M)};
            Rectangle rect = new Rectangle(corner);
            try {
                List rs = this.complexRoots(rect, p);
                ArrayList rf = new ArrayList(rs.size());
                for (Rectangle r : rs) {
                    Rectangle rr = this.complexRootRefinement(r, p, len);
                    rf.add(rr);
                }
                long e = me.getValue();
                int i = 0;
                while ((long)i < e) {
                    roots.addAll(rf);
                    ++i;
                }
            }
            catch (InvalidBoundaryException e) {
                throw new RuntimeException("this should never happen " + e);
            }
        }
        return roots;
    }

    public abstract Rectangle<C> invariantRectangle(Rectangle<C> var1, GenPolynomial<Complex<C>> var2, GenPolynomial<Complex<C>> var3) throws InvalidBoundaryException;

    public String toDecimal(Complex<C> a) {
        C r = a.getRe();
        String s = r.toString();
        BigRational rs = new BigRational(s);
        BigDecimal rd = new BigDecimal(rs);
        C i = a.getIm();
        s = i.toString();
        BigRational is = new BigRational(s);
        BigDecimal id = new BigDecimal(is);
        return rd.toString() + " i " + id.toString();
    }

    public Complex<BigDecimal> approximateRoot(Rectangle<C> rt, GenPolynomial<Complex<C>> f, C eps) throws NoConvergenceException {
        if (rt == null) {
            throw new IllegalArgumentException("null interval not allowed");
        }
        Complex<BigDecimal> d = rt.getDecimalCenter();
        if (f == null || f.isZERO() || f.isConstant() || eps == null) {
            return d;
        }
        if (rt.length().compareTo(eps) < 0) {
            return d;
        }
        ComplexRing cr = d.ring;
        Complex<C> sw = rt.getSW();
        BigDecimal swr = new BigDecimal(((Rational)sw.getRe()).getRational());
        BigDecimal swi = new BigDecimal(((Rational)sw.getIm()).getRational());
        Complex<BigDecimal> ll = new Complex<BigDecimal>(cr, swr, swi);
        Complex<C> ne = rt.getNE();
        BigDecimal ner = new BigDecimal(((Rational)ne.getRe()).getRational());
        BigDecimal nei = new BigDecimal(((Rational)ne.getIm()).getRational());
        Complex<BigDecimal> ur = new Complex<BigDecimal>(cr, ner, nei);
        BigDecimal e = new BigDecimal(((Rational)eps).getRational());
        Complex<BigDecimal> q = new Complex<BigDecimal>(cr, new BigDecimal("0.25"));
        e = e.multiply((BigDecimal)((Complex)d.norm()).getRe());
        GenPolynomialRing<Complex<BigDecimal>> dfac = new GenPolynomialRing<Complex<BigDecimal>>(cr, f.ring);
        GenPolynomial<Complex<BigDecimal>> df = PolyUtil.complexDecimalFromRational(dfac, f);
        GenPolynomial<Complex<C>> fp = PolyUtil.baseDeriviative(f);
        GenPolynomial<Complex<BigDecimal>> dfp = PolyUtil.complexDecimalFromRational(dfac, fp);
        int i = 0;
        int MITER = 50;
        int dir = -1;
        while (i++ < 50) {
            Complex<BigDecimal> fx = PolyUtil.evaluateMain(cr, df, d);
            if (fx.isZERO()) {
                return d;
            }
            Complex<BigDecimal> fpx = PolyUtil.evaluateMain(cr, dfp, d);
            if (fpx.isZERO()) {
                throw new NoConvergenceException("zero deriviative should not happen");
            }
            AbelianGroupElem x = fx.divide(fpx);
            Complex<BigDecimal> dx = d.subtract((Complex<BigDecimal>)x);
            if (((BigDecimal)((Complex)d.subtract(dx).norm()).getRe()).compareTo(e) <= 0) {
                return dx;
            }
            while (dx.getRe().compareTo(ll.getRe()) < 0 || dx.getIm().compareTo(ll.getIm()) < 0 || dx.getRe().compareTo(ur.getRe()) > 0 || dx.getIm().compareTo(ur.getIm()) > 0) {
                Complex<BigDecimal> sd;
                Rectangle<C> nrt;
                Complex<C> cc;
                if (i++ > 50) {
                    throw new NoConvergenceException("no convergence after " + i + " steps");
                }
                if (i > 25 && dir == 0) {
                    cc = rt.getCenter();
                    nrt = rt.exchangeSE(cc);
                    sd = nrt.getDecimalCenter();
                    d = sd;
                    x = cr.getZERO();
                    logger.info((Object)("trying new SE starting point " + d));
                    i = 0;
                    dir = 1;
                }
                if (i > 25 && dir == 1) {
                    cc = rt.getCenter();
                    nrt = rt.exchangeNW(cc);
                    sd = nrt.getDecimalCenter();
                    d = sd;
                    x = cr.getZERO();
                    logger.info((Object)("trying new NW starting point " + d));
                    i = 0;
                    dir = 2;
                }
                if (i > 25 && dir == 2) {
                    cc = rt.getCenter();
                    nrt = rt.exchangeSW(cc);
                    sd = nrt.getDecimalCenter();
                    d = sd;
                    x = cr.getZERO();
                    logger.info((Object)("trying new SW starting point " + d));
                    i = 0;
                    dir = 3;
                }
                if (i > 25 && dir == 3) {
                    cc = rt.getCenter();
                    nrt = rt.exchangeNE(cc);
                    sd = nrt.getDecimalCenter();
                    d = sd;
                    x = cr.getZERO();
                    logger.info((Object)("trying new NE starting point " + d));
                    i = 0;
                    dir = 4;
                }
                if (i > 25 && (dir == -1 || dir == 4 || dir == 5)) {
                    Complex<C> sr = rt.randomPoint();
                    BigDecimal srr = new BigDecimal(((Rational)sr.getRe()).getRational());
                    BigDecimal sri = new BigDecimal(((Rational)sr.getIm()).getRational());
                    Complex<BigDecimal> sd2 = new Complex<BigDecimal>(cr, srr, sri);
                    d = sd2;
                    x = cr.getZERO();
                    logger.info((Object)("trying new random starting point " + d));
                    if (dir == -1) {
                        i = 0;
                        dir = 0;
                    } else if (dir == 4) {
                        i = 0;
                        dir = 5;
                    } else {
                        dir = 6;
                    }
                }
                x = x.multiply(q);
                dx = d.subtract((Complex<BigDecimal>)x);
            }
            d = dx;
        }
        throw new NoConvergenceException("no convergence after " + i + " steps");
    }

    public List<Complex<BigDecimal>> approximateRoots(GenPolynomial<Complex<C>> a, C eps) {
        ComplexRing cr = (ComplexRing)a.ring.coFac;
        SortedMap<GenPolynomial<Complex<C>>, Long> sa = this.engine.squarefreeFactors(a);
        ArrayList<Complex<BigDecimal>> roots = new ArrayList<Complex<BigDecimal>>();
        for (Map.Entry<GenPolynomial<Complex<C>>, Long> me : sa.entrySet()) {
            GenPolynomial<Complex<C>> p = me.getKey();
            ArrayList<Complex<BigDecimal>> rf = null;
            if (p.degree(0) <= 1L) {
                AbelianGroupElem<Complex<C>> tc = p.trailingBaseCoefficient();
                tc = ((Complex)tc).negate();
                BigDecimal rr = new BigDecimal(((Rational)((Complex)tc).getRe()).getRational());
                BigDecimal ri = new BigDecimal(((Rational)((Complex)tc).getIm()).getRational());
                ComplexRing<BigDecimal> crf = new ComplexRing<BigDecimal>(rr);
                Complex<BigDecimal> r = new Complex<BigDecimal>(crf, rr, ri);
                rf = new ArrayList<Complex<BigDecimal>>(1);
                rf.add(r);
            } else {
                Complex<C> Mb = this.rootBound(p);
                AbelianGroupElem M = Mb.getRe();
                RingElem M1 = (RingElem)M.sum((AbelianGroupElem)((AbelianGroupElem)M.factory().fromInteger(1L)));
                if (this.debug) {
                    logger.info((Object)("rootBound = " + M));
                }
                Complex[] corner = new Complex[]{new Complex<RingElem>(cr, (RingElem)M1.negate(), (RingElem)M), new Complex<RingElem>(cr, (RingElem)M1.negate(), (RingElem)M1.negate()), new Complex<RingElem>(cr, (RingElem)M, (RingElem)M1.negate()), new Complex<C>(cr, M, M)};
                Rectangle rect = new Rectangle(corner);
                List rs = null;
                try {
                    rs = this.complexRoots(rect, p);
                }
                catch (InvalidBoundaryException e) {
                    throw new RuntimeException("this should never happen " + e);
                }
                rf = new ArrayList(rs.size());
                for (Rectangle r : rs) {
                    Complex<BigDecimal> rr = null;
                    while (rr == null) {
                        try {
                            rr = this.approximateRoot(r, p, eps);
                            rf.add(rr);
                        }
                        catch (NoConvergenceException e) {
                            BigRational len = r.rationalLength();
                            len = len.multiply(new BigRational(1L, 1000L));
                            try {
                                r = this.complexRootRefinement(r, p, len);
                                logger.info((Object)("fall back rootRefinement = " + r));
                            }
                            catch (InvalidBoundaryException ee) {
                                throw new RuntimeException("this should never happen " + ee);
                            }
                        }
                    }
                }
            }
            long e = me.getValue();
            int i = 0;
            while ((long)i < e) {
                roots.addAll(rf);
                ++i;
            }
        }
        return roots;
    }

    public Complex[] copyOfComplex(Complex[] original, int newLength) {
        Complex[] copy = new Complex[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    public Rectangle<C> invariantMagnitudeRectangle(Rectangle<C> rect, GenPolynomial<Complex<C>> f, GenPolynomial<Complex<C>> g, C eps) throws InvalidBoundaryException {
        Rectangle<C> v = rect;
        if (g == null || g.isZERO()) {
            return v;
        }
        if (g.isConstant()) {
            return v;
        }
        if (f == null || f.isZERO() || f.isConstant()) {
            return v;
        }
        GenPolynomial<Complex<C>> gp = PolyUtil.baseDeriviative(g);
        Object B = this.magnitudeBound(rect, gp);
        BigRational len = v.rationalLength();
        BigRational half = new BigRational(1L, 2L);
        Object vlen = v.length();
        vlen = (RingElem)vlen.multiply(vlen);
        while (((RingElem)B.multiply(vlen)).compareTo(eps) >= 0) {
            len = len.multiply(half);
            v = this.complexRootRefinement(v, f, len);
            vlen = v.length();
            vlen = (RingElem)vlen.multiply((Object)vlen);
        }
        return v;
    }

    public Complex<C> complexRectangleMagnitude(Rectangle<C> rect, GenPolynomial<Complex<C>> f, GenPolynomial<Complex<C>> g) {
        if (g.isZERO() || g.isConstant()) {
            return g.leadingBaseCoefficient();
        }
        RingFactory cfac = f.ring.coFac;
        Complex<C> c = rect.getCenter();
        Complex<C> ev = PolyUtil.evaluateMain(cfac, g, c);
        return ev;
    }

    public Complex<C> complexMagnitude(Rectangle<C> rect, GenPolynomial<Complex<C>> f, GenPolynomial<Complex<C>> g, C eps) throws InvalidBoundaryException {
        if (g.isZERO() || g.isConstant()) {
            return g.leadingBaseCoefficient();
        }
        Rectangle<C> v = this.invariantMagnitudeRectangle(rect, f, g, eps);
        return this.complexRectangleMagnitude(v, f, g);
    }
}

