/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.root;

import edu.jas.arith.BigRational;
import edu.jas.arith.Rational;
import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.Complex;
import edu.jas.poly.ComplexRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.root.ComplexAlgebraicNumber;
import edu.jas.root.ComplexRootsSturm;
import edu.jas.root.Rectangle;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.Power;
import edu.jas.structure.RingFactory;
import java.io.Reader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class ComplexAlgebraicRing<C extends GcdRingElem<C> & Rational>
implements RingFactory<ComplexAlgebraicNumber<C>> {
    public final AlgebraicNumberRing<Complex<C>> algebraic;
    Rectangle<C> root;
    protected C eps;
    public static final int PRECISION = 9;
    public final ComplexRootsSturm<C> engine;

    public ComplexAlgebraicRing(GenPolynomial<Complex<C>> m, Rectangle<C> root) {
        this.algebraic = new AlgebraicNumberRing<Complex<Complex<C>>>(m);
        this.root = root;
        this.engine = new ComplexRootsSturm(m.ring.coFac);
        if (m.ring.characteristic().signum() > 0) {
            throw new IllegalArgumentException("characteristic not zero");
        }
        GcdRingElem e = (GcdRingElem)((Complex)m.ring.coFac.fromInteger(10L)).getRe();
        e = (GcdRingElem)e.inverse();
        e = Power.positivePower(e, 9L);
        this.eps = e;
    }

    public ComplexAlgebraicRing(GenPolynomial<Complex<C>> m, Rectangle<C> root, boolean isField) {
        this.algebraic = new AlgebraicNumberRing<Complex<Complex<C>>>(m, isField);
        this.root = root;
        this.engine = new ComplexRootsSturm(m.ring.coFac);
        if (m.ring.characteristic().signum() > 0) {
            throw new IllegalArgumentException("characteristic not zero");
        }
        GcdRingElem e = (GcdRingElem)((Complex)m.ring.coFac.fromInteger(10L)).getRe();
        e = (GcdRingElem)e.inverse();
        e = Power.positivePower(e, 9L);
        this.eps = e;
    }

    public synchronized void setRoot(Rectangle<C> v) {
        this.root = v;
    }

    public synchronized Rectangle<C> getRoot() {
        return this.root;
    }

    public synchronized C getEps() {
        return this.eps;
    }

    public synchronized void setEps(C e) {
        this.eps = e;
    }

    public synchronized void setEps(BigRational e) {
        this.eps = (GcdRingElem)((Complex)this.algebraic.ring.coFac.parse(e.toString())).getRe();
    }

    @Override
    public boolean isFinite() {
        return this.algebraic.isFinite();
    }

    @Override
    public ComplexAlgebraicNumber<C> copy(ComplexAlgebraicNumber<C> c) {
        return new ComplexAlgebraicNumber(this, c.number);
    }

    @Override
    public ComplexAlgebraicNumber<C> getZERO() {
        return new ComplexAlgebraicNumber(this, this.algebraic.getZERO());
    }

    @Override
    public ComplexAlgebraicNumber<C> getONE() {
        return new ComplexAlgebraicNumber(this, this.algebraic.getONE());
    }

    public ComplexAlgebraicNumber<C> getIMAG() {
        ComplexRing cr = (ComplexRing)this.algebraic.ring.coFac;
        Complex I2 = cr.getIMAG();
        return new ComplexAlgebraicNumber(this, ((AlgebraicNumber)this.algebraic.getZERO()).sum(I2));
    }

    public ComplexAlgebraicNumber<C> getGenerator() {
        return new ComplexAlgebraicNumber<C>(this, this.algebraic.getGenerator());
    }

    @Override
    public List<ComplexAlgebraicNumber<C>> generators() {
        List<AlgebraicNumber<Complex<C>>> agens = this.algebraic.generators();
        ArrayList<ComplexAlgebraicNumber<C>> gens = new ArrayList<ComplexAlgebraicNumber<C>>(agens.size());
        for (AlgebraicNumber<Complex<C>> a : agens) {
            gens.add(((ComplexAlgebraicNumber)this.getZERO()).sum(a.getVal()));
        }
        return gens;
    }

    @Override
    public boolean isCommutative() {
        return this.algebraic.isCommutative();
    }

    @Override
    public boolean isAssociative() {
        return this.algebraic.isAssociative();
    }

    @Override
    public boolean isField() {
        return this.algebraic.isField();
    }

    @Override
    public BigInteger characteristic() {
        return this.algebraic.characteristic();
    }

    @Override
    public ComplexAlgebraicNumber<C> fromInteger(BigInteger a) {
        return new ComplexAlgebraicNumber(this, this.algebraic.fromInteger(a));
    }

    @Override
    public ComplexAlgebraicNumber<C> fromInteger(long a) {
        return new ComplexAlgebraicNumber(this, this.algebraic.fromInteger(a));
    }

    public String toString() {
        return "ComplexAlgebraicRing[ " + this.algebraic.modul.toString() + " in " + this.root + " | isField=" + this.algebraic.isField() + " :: " + this.algebraic.ring.toString() + " ]";
    }

    @Override
    public String toScript() {
        return "ComplexN( " + this.algebraic.modul.toScript() + ", " + this.root.toScript() + " )";
    }

    public boolean equals(Object b) {
        if (b == null) {
            return false;
        }
        if (!(b instanceof ComplexAlgebraicRing)) {
            return false;
        }
        ComplexAlgebraicRing a = (ComplexAlgebraicRing)b;
        return this.algebraic.equals(a.algebraic) && this.root.equals(a.root);
    }

    public int hashCode() {
        return 37 * this.algebraic.hashCode() + this.root.hashCode();
    }

    @Override
    public ComplexAlgebraicNumber<C> random(int n) {
        return new ComplexAlgebraicNumber(this, this.algebraic.random(n));
    }

    @Override
    public ComplexAlgebraicNumber<C> random(int n, Random rnd) {
        return new ComplexAlgebraicNumber(this, this.algebraic.random(n, rnd));
    }

    @Override
    public ComplexAlgebraicNumber<C> parse(String s) {
        return new ComplexAlgebraicNumber(this, this.algebraic.parse(s));
    }

    @Override
    public ComplexAlgebraicNumber<C> parse(Reader r) {
        return new ComplexAlgebraicNumber(this, this.algebraic.parse(r));
    }
}

