/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ps;

import edu.jas.ps.MultiVarPowerSeries;
import edu.jas.ps.ReductionSeq;
import edu.jas.structure.RingElem;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class StandardBaseSeq<C extends RingElem<C>> {
    private static final Logger logger = Logger.getLogger(StandardBaseSeq.class);
    private final boolean debug = logger.isDebugEnabled();
    public final ReductionSeq<C> red;

    public StandardBaseSeq() {
        this(new ReductionSeq());
    }

    public StandardBaseSeq(ReductionSeq<C> red) {
        this.red = red;
    }

    public List<MultiVarPowerSeries<C>> normalizeZerosOnes(List<MultiVarPowerSeries<C>> A) {
        ArrayList<MultiVarPowerSeries<C>> N2 = new ArrayList<MultiVarPowerSeries<C>>(A.size());
        if (A == null || A.isEmpty()) {
            return N2;
        }
        for (MultiVarPowerSeries<C> p : A) {
            if (p == null || p.isZERO()) continue;
            if (p.isUnit()) {
                N2.clear();
                N2.add((MultiVarPowerSeries<C>)p.ring.getONE());
                return N2;
            }
            N2.add((MultiVarPowerSeries<C>)p.abs());
        }
        return N2;
    }

    public boolean isSTD(List<MultiVarPowerSeries<C>> F2) {
        return this.isSTD(0, F2);
    }

    public boolean isSTD(int modv, List<MultiVarPowerSeries<C>> F2) {
        if (F2 == null) {
            return true;
        }
        for (int i = 0; i < F2.size(); ++i) {
            MultiVarPowerSeries<C> pi = F2.get(i);
            for (int j = i + 1; j < F2.size(); ++j) {
                MultiVarPowerSeries<C> h;
                MultiVarPowerSeries<C> s;
                MultiVarPowerSeries<C> pj = F2.get(j);
                if (!this.red.moduleCriterion(modv, pi, pj) || (s = this.red.SPolynomial(pi, pj)).isZERO() || (h = this.red.normalform(F2, s)).isZERO()) continue;
                System.out.println("pi = " + pi + ", pj = " + pj);
                System.out.println("s  = " + s + ", h = " + h);
                return false;
            }
        }
        return true;
    }

    public List<MultiVarPowerSeries<C>> minimalSTD(List<MultiVarPowerSeries<C>> Gp) {
        if (Gp == null || Gp.size() <= 1) {
            return Gp;
        }
        ArrayList<MultiVarPowerSeries<C>> G = new ArrayList<MultiVarPowerSeries<C>>(Gp.size());
        for (MultiVarPowerSeries<C> a : Gp) {
            if (a == null || a.isZERO()) continue;
            a = a.monic();
            G.add(a);
        }
        if (G.size() <= 1) {
            return G;
        }
        ArrayList F2 = new ArrayList(G.size());
        while (G.size() > 0) {
            MultiVarPowerSeries<C> a = (MultiVarPowerSeries<C>)G.remove(0);
            if (this.red.isTopReducible(G, a) || this.red.isTopReducible(F2, a)) {
                if (!this.debug) continue;
                System.out.println("dropped " + a);
                ArrayList<MultiVarPowerSeries<C>> ff = new ArrayList<MultiVarPowerSeries<C>>(G);
                ff.addAll(F2);
                if ((a = this.red.normalform(ff, a)).isZERO()) continue;
                System.out.println("error, nf(a) " + a);
                continue;
            }
            F2.add(a);
        }
        G = F2;
        return G;
    }
}

