/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ps;

import edu.jas.poly.ExpVector;
import edu.jas.ps.MultiVarPowerSeries;
import edu.jas.ps.MultiVarPowerSeriesRing;
import edu.jas.ps.Pair;
import edu.jas.ps.ReductionSeq;
import edu.jas.structure.RingElem;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class OrderedPairlist<C extends RingElem<C>> {
    protected final ArrayList<MultiVarPowerSeries<C>> P;
    protected final TreeMap<ExpVector, LinkedList<Pair<C>>> pairlist;
    protected final ArrayList<BitSet> red;
    protected final MultiVarPowerSeriesRing<C> ring;
    protected final ReductionSeq<C> reduction;
    protected boolean oneInGB = false;
    protected boolean useCriterion4 = true;
    protected boolean useCriterion3 = true;
    protected int putCount;
    protected int remCount;
    protected final int moduleVars;
    private static final Logger logger = Logger.getLogger(OrderedPairlist.class);

    public OrderedPairlist(MultiVarPowerSeriesRing<C> r) {
        this(0, r);
    }

    public OrderedPairlist(int m, MultiVarPowerSeriesRing<C> r) {
        this.moduleVars = m;
        this.ring = r;
        this.P = new ArrayList();
        this.pairlist = new TreeMap(this.ring.polyRing().tord.getAscendComparator());
        this.red = new ArrayList();
        this.putCount = 0;
        this.remCount = 0;
        this.reduction = new ReductionSeq();
    }

    public String toString() {
        StringBuffer s = new StringBuffer("OrderedPairlist(");
        s.append("#put=" + this.putCount);
        s.append(", #rem=" + this.remCount);
        if (this.pairlist.size() != 0) {
            s.append(", size=" + this.pairlist.size());
        }
        s.append(")");
        return s.toString();
    }

    public synchronized int put(MultiVarPowerSeries<C> p) {
        ++this.putCount;
        if (this.oneInGB) {
            return this.P.size() - 1;
        }
        ExpVector e = p.orderExpVector();
        int l = this.P.size();
        for (int j = 0; j < l; ++j) {
            MultiVarPowerSeries<C> pj = this.P.get(j);
            ExpVector f = pj.orderExpVector();
            if (this.moduleVars > 0 && !this.reduction.moduleCriterion(this.moduleVars, e, f)) continue;
            ExpVector g = e.lcm(f);
            Pair<C> pair = new Pair<C>(pj, p, j, l);
            LinkedList<Pair<Object>> xl = this.pairlist.get(g);
            if (xl == null) {
                xl = new LinkedList();
            }
            xl.addFirst(pair);
            this.pairlist.put(g, xl);
        }
        this.P.add(p);
        BitSet redi = new BitSet();
        redi.set(0, l);
        this.red.add(redi);
        return this.P.size() - 1;
    }

    public int put(List<MultiVarPowerSeries<C>> F2) {
        int i = 0;
        for (MultiVarPowerSeries<C> p : F2) {
            i = this.put(p);
        }
        return i;
    }

    public synchronized Pair<C> removeNext() {
        if (this.oneInGB) {
            return null;
        }
        Iterator<Map.Entry<ExpVector, LinkedList<Pair<C>>>> ip = this.pairlist.entrySet().iterator();
        Pair<C> pair = null;
        boolean c = false;
        while (!c && ip.hasNext()) {
            Map.Entry<ExpVector, LinkedList<Pair<C>>> me = ip.next();
            ExpVector g = me.getKey();
            LinkedList<Pair<C>> xl = me.getValue();
            if (logger.isInfoEnabled()) {
                logger.info((Object)("g  = " + g));
            }
            pair = null;
            while (!c && xl.size() > 0) {
                pair = xl.removeFirst();
                int i = pair.i;
                int j = pair.j;
                c = true;
                if (this.useCriterion4) {
                    c = this.reduction.criterion4(pair.pi, pair.pj, g);
                }
                if (c && this.useCriterion3) {
                    c = this.criterion3(i, j, g);
                }
                this.red.get(j).clear(i);
            }
            if (xl.size() != 0) continue;
            ip.remove();
        }
        if (!c) {
            pair = null;
        } else {
            ++this.remCount;
        }
        return pair;
    }

    public synchronized boolean hasNext() {
        return this.pairlist.size() > 0;
    }

    public List<MultiVarPowerSeries<C>> getList() {
        return this.P;
    }

    public synchronized int putCount() {
        return this.putCount;
    }

    public synchronized int remCount() {
        return this.remCount;
    }

    public synchronized int putOne(MultiVarPowerSeries<C> one) {
        ++this.putCount;
        if (one == null) {
            return this.P.size() - 1;
        }
        if (!one.isONE()) {
            return this.P.size() - 1;
        }
        return this.putOne();
    }

    public synchronized int putOne() {
        this.oneInGB = true;
        this.pairlist.clear();
        this.P.clear();
        this.P.add((MultiVarPowerSeries<C>)this.ring.getONE());
        this.red.clear();
        return this.P.size() - 1;
    }

    public boolean criterion3(int i, int j, ExpVector eij) {
        boolean s = this.red.get(j).get(i);
        if (!s) {
            logger.warn((Object)("c3.s false for " + j + " " + i));
            return s;
        }
        for (int k = 0; k < this.P.size(); ++k) {
            MultiVarPowerSeries<C> A = this.P.get(k);
            ExpVector ek = A.orderExpVector();
            boolean m = eij.multipleOf(ek);
            if (!m) continue;
            if (k < i) {
                s = this.red.get(i).get(k) || this.red.get(j).get(k);
            } else if (i < k && k < j) {
                s = this.red.get(k).get(i) || this.red.get(j).get(k);
            } else if (j < k) {
                boolean bl = s = this.red.get(k).get(i) || this.red.get(k).get(j);
            }
            if (s) continue;
            return s;
        }
        return true;
    }
}

