/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.kern.StringUtil;
import edu.jas.poly.ExpVector;
import edu.jas.poly.Word;
import edu.jas.structure.MonoidFactory;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import org.apache.log4j.Logger;

public final class WordFactory
implements MonoidFactory<Word> {
    final String alphabet;
    public final Word ONE;
    public static final String transRef = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    public final String[] translation;
    private static final Random random = new Random();
    private static final Logger logger = Logger.getLogger(WordFactory.class);
    private static final WordComparator horder = new WordComparator(){

        @Override
        public int compare(Word e1, Word e2) {
            return e1.gradInvlexCompareTo(e2);
        }
    };
    private static final WordComparator lorder = new WordComparator(){

        @Override
        public int compare(Word e1, Word e2) {
            return -e1.gradInvlexCompareTo(e2);
        }
    };

    public WordFactory() {
        this("");
    }

    public WordFactory(String s) {
        if (s == null) {
            throw new IllegalArgumentException("null string not allowed");
        }
        this.alphabet = WordFactory.cleanSpace(s);
        this.translation = null;
        this.ONE = new Word(this, "", false);
    }

    public WordFactory(String[] S) {
        String[] V = WordFactory.cleanAll(S);
        if (WordFactory.isSingleLetters(V)) {
            this.alphabet = WordFactory.concat(V);
            this.translation = null;
        } else {
            this.alphabet = transRef.substring(0, V.length);
            this.translation = V;
            logger.info((Object)("alphabet = " + this.alphabet + ", translation = " + Arrays.toString(this.translation)));
        }
        this.ONE = new Word(this, "", false);
    }

    @Override
    public boolean isFinite() {
        return this.alphabet.length() == 0;
    }

    @Override
    public boolean isCommutative() {
        return false;
    }

    @Override
    public boolean isAssociative() {
        return true;
    }

    @Override
    public Word getONE() {
        return this.ONE;
    }

    @Override
    public Word copy(Word w) {
        return new Word(this, w.getVal(), false);
    }

    public int length() {
        return this.alphabet.length();
    }

    String getVal() {
        return this.alphabet;
    }

    String[] getTrans() {
        return this.translation;
    }

    public char getVal(int i) {
        return this.alphabet.charAt(i);
    }

    public String toString() {
        StringBuffer s = new StringBuffer("\"");
        if (this.translation == null) {
            for (int i = 0; i < this.alphabet.length(); ++i) {
                if (i != 0) {
                    s.append(",");
                }
                s.append(this.getVal(i));
            }
        } else {
            for (int i = 0; i < this.alphabet.length(); ++i) {
                if (i != 0) {
                    s.append(",");
                }
                s.append(this.translation[i]);
            }
        }
        s.append("\"");
        return s.toString();
    }

    @Override
    public String toScript() {
        return this.toString();
    }

    public boolean equals(Object B) {
        if (!(B instanceof WordFactory)) {
            return false;
        }
        WordFactory b = (WordFactory)B;
        return this.alphabet.equals(b.alphabet);
    }

    public int hashCode() {
        return this.alphabet.hashCode();
    }

    @Override
    public List<Word> generators() {
        int len = this.alphabet.length();
        ArrayList<Word> gens = new ArrayList<Word>(len);
        for (int i = 0; i < len; ++i) {
            Word w = new Word(this, String.valueOf(this.alphabet.charAt(i)), false);
            gens.add(w);
        }
        return gens;
    }

    @Override
    public Word fromInteger(long a) {
        throw new UnsupportedOperationException("not implemented for WordFactory");
    }

    @Override
    public Word fromInteger(BigInteger a) {
        throw new UnsupportedOperationException("not implemented for WordFactory");
    }

    public Word valueOf(ExpVector e) {
        Word w = this.ONE;
        List<Word> gens = this.generators();
        int n = this.alphabet.length();
        int m = e.length();
        if (m > n) {
            throw new IllegalArgumentException("alphabet to short for exponent " + e + ", alpahbet = " + this.alphabet);
        }
        for (int i = 0; i < m; ++i) {
            int x = (int)e.getVal(m - i - 1);
            Word y = gens.get(i);
            Word u = this.ONE;
            for (int j = 0; j < x; ++j) {
                u = u.multiply(y);
            }
            w = w.multiply(u);
        }
        return w;
    }

    @Override
    public Word random(int n) {
        return this.random(n, random);
    }

    @Override
    public Word random(int n, Random random) {
        StringBuffer sb = new StringBuffer();
        int len = this.alphabet.length();
        for (int i = 0; i < n; ++i) {
            int r = Math.abs(random.nextInt() % len);
            sb.append(this.alphabet.charAt(r));
        }
        return new Word(this, sb.toString(), false);
    }

    @Override
    public Word parse(String s) {
        String regex;
        String st = WordFactory.clean(s);
        if (!st.matches(regex = this.translation == null ? "[" + this.alphabet + " ]*" : "[" + WordFactory.concat(this.translation) + " ]*")) {
            throw new IllegalArgumentException("word '" + st + "' contains letters not from: " + this.alphabet + " or from " + WordFactory.concat(this.translation));
        }
        return new Word(this, st, true);
    }

    @Override
    public Word parse(Reader r) {
        return this.parse(StringUtil.nextString(r));
    }

    public WordComparator getDescendComparator() {
        return horder;
    }

    public WordComparator getAscendComparator() {
        return lorder;
    }

    public static String cleanSpace(String s) {
        String st = s.trim();
        st = st.replaceAll("\\*", "");
        st = st.replaceAll("\\s", "");
        st = st.replaceAll("\\(", "");
        st = st.replaceAll("\\)", "");
        st = st.replaceAll("\\\"", "");
        return st;
    }

    public static String clean(String s) {
        String st = s.trim();
        st = st.replaceAll("\\*", " ");
        st = st.replaceAll("\\(", "");
        st = st.replaceAll("\\)", "");
        st = st.replaceAll("\\\"", "");
        return st;
    }

    public static String[] cleanAll(String[] v) {
        String[] t = new String[v.length];
        for (int i = 0; i < v.length; ++i) {
            t[i] = WordFactory.cleanSpace(v[i]);
            if (t[i].length() != 0) continue;
            logger.error((Object)("empty v[i]: '" + v[i] + "'"));
        }
        return t;
    }

    public static String concat(String[] v) {
        StringBuffer s = new StringBuffer();
        if (v == null) {
            return s.toString();
        }
        for (int i = 0; i < v.length; ++i) {
            s.append(v[i]);
        }
        return s.toString();
    }

    public static String[] trimAll(String[] v) {
        String[] t = new String[v.length];
        for (int i = 0; i < v.length; ++i) {
            t[i] = v[i].trim();
            if (t[i].length() != 0) continue;
            logger.error((Object)("empty v[i]: '" + v[i] + "'"));
        }
        return t;
    }

    public static int indexOf(String[] v, String s) {
        for (int i = 0; i < v.length; ++i) {
            if (!s.equals(v[i])) continue;
            return i;
        }
        return -1;
    }

    public static boolean isSingleLetters(String[] v) {
        for (int i = 0; i < v.length; ++i) {
            if (v[i].length() == 1) continue;
            return false;
        }
        return true;
    }

    public String translate(String[] v) {
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < v.length; ++i) {
            String a = v[i];
            int k = WordFactory.indexOf(this.translation, a);
            if (k < 0) {
                System.out.println("t = " + Arrays.toString(this.translation));
                System.out.println("v = " + Arrays.toString(v));
                logger.error((Object)("v[i] not found in t: " + a));
                throw new IllegalArgumentException("v[i] not found in t: " + a);
            }
            s.append(transRef.charAt(k));
        }
        return s.toString();
    }

    public String transVar(char c) {
        int k = this.alphabet.indexOf(c);
        return this.translation[k];
    }

    public static abstract class WordComparator
    implements Comparator<Word>,
    Serializable {
        @Override
        public abstract int compare(Word var1, Word var2);
    }
}

