/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.poly.Residue;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import java.io.Reader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.log4j.Logger;

public class ResidueRing<C extends RingElem<C>>
implements RingFactory<Residue<C>> {
    private static final Logger logger = Logger.getLogger(ResidueRing.class);
    protected final C modul;
    protected final RingFactory<C> ring;
    protected int isField = -1;

    public ResidueRing(RingFactory<C> r, C m) {
        this.ring = r;
        if (m.isZERO()) {
            throw new IllegalArgumentException("modul may not be null");
        }
        if (m.isONE()) {
            logger.warn((Object)"modul is one");
        }
        if (m.signum() < 0) {
            m = (RingElem)m.negate();
        }
        this.modul = m;
    }

    @Override
    public boolean isFinite() {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public Residue<C> copy(Residue<C> c) {
        return new Residue(c.ring, c.val);
    }

    @Override
    public Residue<C> getZERO() {
        return new Residue<RingElem>(this, (RingElem)this.ring.getZERO());
    }

    @Override
    public Residue<C> getONE() {
        Residue<RingElem> one = new Residue<RingElem>(this, (RingElem)this.ring.getONE());
        if (one.isZERO()) {
            logger.warn((Object)"one is zero, so all residues are 0");
        }
        return one;
    }

    @Override
    public List<Residue<C>> generators() {
        List rgens = this.ring.generators();
        ArrayList<Residue<C>> gens = new ArrayList<Residue<C>>(rgens.size());
        for (RingElem c : rgens) {
            gens.add(new Residue<RingElem>(this, c));
        }
        return gens;
    }

    @Override
    public boolean isCommutative() {
        return this.ring.isCommutative();
    }

    @Override
    public boolean isAssociative() {
        return this.ring.isAssociative();
    }

    @Override
    public boolean isField() {
        if (this.isField > 0) {
            return true;
        }
        if (this.isField == 0) {
            return false;
        }
        return false;
    }

    @Override
    public BigInteger characteristic() {
        return this.ring.characteristic();
    }

    @Override
    public Residue<C> fromInteger(BigInteger a) {
        return new Residue<RingElem>(this, (RingElem)this.ring.fromInteger(a));
    }

    @Override
    public Residue<C> fromInteger(long a) {
        return new Residue<RingElem>(this, (RingElem)this.ring.fromInteger(a));
    }

    public String toString() {
        return "Residue[ " + this.modul.toString() + " ]";
    }

    @Override
    public String toScript() {
        return "ResidueRing(" + this.modul.toScript() + ")";
    }

    public boolean equals(Object b) {
        if (b == null) {
            return false;
        }
        if (!(b instanceof ResidueRing)) {
            return false;
        }
        ResidueRing a = (ResidueRing)b;
        if (!this.ring.equals(a.ring)) {
            return false;
        }
        return this.modul.equals(a.modul);
    }

    public int hashCode() {
        int h = this.ring.hashCode();
        h = 37 * h + this.modul.hashCode();
        return h;
    }

    @Override
    public Residue<C> random(int n) {
        RingElem x = (RingElem)this.ring.random(n);
        return new Residue<RingElem>(this, x);
    }

    @Override
    public Residue<C> random(int n, Random rnd) {
        RingElem x = (RingElem)this.ring.random(n, rnd);
        return new Residue<RingElem>(this, x);
    }

    @Override
    public Residue<C> parse(String s) {
        RingElem x = (RingElem)this.ring.parse(s);
        return new Residue<RingElem>(this, x);
    }

    @Override
    public Residue<C> parse(Reader r) {
        RingElem x = (RingElem)this.ring.parse(r);
        return new Residue<RingElem>(this, x);
    }
}

